package com.szboanda.android.platform.view;

import java.util.Arrays;

import android.content.Context;
import android.content.res.TypedArray;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.widget.CheckBox;

import com.szboanda.android.platform.R;

/**   
* 可绑定值的CheckBox
* @author 苏浩 2015年8月17日 上午11:12:24
* @version V1.0
*/

public class BindableCheckBox extends CheckBox implements IBindableView {

	/**被选中时绑定的值*/
	private String checkedValue;
	
	private BindableViewHandler mBindHandler;
	
	public BindableCheckBox(Context context) {
		super(context);
		mBindHandler = new BindableViewHandler(this);
	}
	
	public BindableCheckBox(Context context, AttributeSet attrs) {
		super(context, attrs);
		mBindHandler = new BindableViewHandler(this);
		mBindHandler.initWithTypedArray(getResources(), attrs);
		TypedArray ta = getResources().obtainAttributes(attrs, R.styleable.BindableCheckBox);
		checkedValue = ta.getString(R.styleable.BindableCheckBox_checkedValue);
		if(TextUtils.isEmpty(checkedValue)){
			checkedValue = getText().toString();
		}
		ta.recycle();
	}

	public void setDefaultValue(String checkedValue){
		this.checkedValue = checkedValue;
	}
	
	public void setField(String field){
		mBindHandler.setField(field);
	}
	
	@Override
	public void setEmptyMsg(String notEmptyTipMsg) {
		mBindHandler.setNotEmptyMsg(notEmptyTipMsg);
	}

	@Override
	public void setBindValue(String value) {
		if(TextUtils.isEmpty(value)){
			setChecked(false);
		}else{
			boolean hasCheckValue = Arrays.asList(
					value.split(mBindHandler.getMultiValueSeparator()))
					.contains(checkedValue);
			setChecked(hasCheckValue);
		}
	}
	
	@Override
	public String getBindValue() {
		return isChecked() ? checkedValue : "";
	}

	@Override
	public BindableViewHandler getBindHandler() {
		return mBindHandler;
	}
	
}
