
package com.szboanda.android.platform.util; 


/**
 * Title: 安全助手类 
 * fileName: SecurityHelper.java
 * Description: 一系列的常用方法 
 * @author 康庆
 * @version 1.0
 * create date:2009-4-25 
 */ 
public class SecurityHelper {
    /**16进制字符集*/
    private static final String HEXINDEX = "0123456789abcdefABCDEF";      
    
    
    public static String toBytesString(byte[] bytes){
    	if(bytes == null){
    		return null;
    	} 
    	StringBuilder buffer = new StringBuilder(256);
    	for(byte b : bytes){ 
    		buffer.append((char)b); 
    	}
    	return buffer.toString(); 
    }
    
    public static byte[] toBytes(String str){
    	if(str == null){ 
    		return null;
    	}
    	int length = str.length(); 
    	byte[] bytes = new byte[length]; 
    	for(int i=0;i< length;i++){
    		bytes[i] = (byte)str.charAt(i);
    	}
    	return bytes;
    }   
    
    /**
     * 将字节数组以16进制的方式编码 返回一个16进制字符串
     * @param  b    字节数组
     * @return     16进制字符串
     */
    public static String toHex(byte[] b){    
        StringBuilder buffer = new StringBuilder(128);
        for (byte i : b) {
            buffer.append(toHex(i));     
        }   
        return buffer.toString();  
    }
    /**
     * 将单个字节转换为16进制形式字符串
     * @param in
     * @return
     * @author: 康庆
     * @version:1.0
     * create date:2009-4-25
     */
    public static char[] toHex(byte in) {   
        char[] out = new char[2];
        int h = 0; 
        h = in >> 4 & 0xF;
        out[0] = (char) (h > 9 ? h + 0x37 : h + 0x30);
        h = in & 0xF;
        out[1] = (char) (h > 9 ? h + 0x37 : h + 0x30);
        return out;
    }
    

    
    /**
     * 将一个16进制字符串转化为字节数组
     * @param s 十六进制字符串
     * @return 字节数组
     */
    public static byte[] hexToByte(String s) { 
        int l = s.length() / 2;        
        byte data[] = new byte[l];       
        int j = 0;       
        for (int i = 0; i < l; i++) {           
            char c = s.charAt(j++);           
            int n, b;           
            n = HEXINDEX.indexOf(c);           
            b = (n & 0xf) << 4;           
            c = s.charAt(j++);           
            n = HEXINDEX.indexOf(c);           
            b += (n & 0xf);           
            data[i] = (byte) b;       
        }       
        return data;   
    }
    
}
