package com.szboanda.android.platform.nfc;

import android.app.Activity;
import android.nfc.FormatException;
import android.nfc.NdefMessage;
import android.nfc.NdefRecord;
import android.nfc.tech.Ndef;
import android.util.Base64;
import android.util.Log;

import java.io.IOException;
import java.nio.charset.Charset;

/**
 * Created by zhanggenhua on 16/4/14.
 */
public class NdefOperation extends NfcBaseOperation {

    public final static String TAG = "NdefOperation";
    
    public NdefOperation(Activity activity){
        super(activity);
    }

    @Override
    public String read() {
        if (mTagFromIntent == null) return "";

        Ndef ndef = Ndef.get(mTagFromIntent);

        try {
            ndef.connect();
            byte[] payload = ndef.getNdefMessage().getRecords()[0].getPayload();
            return new String(Base64.decode(payload, Base64.DEFAULT), Charset.forName("UTF-8"));
        } catch (IOException e) {
            Log.e(TAG, "IOException while read Ndef message...", e);
        } catch (FormatException e) {
            Log.e(TAG, "FormatException while read Ndef message...", e);
        } finally {
            try {
                ndef.close();
            } catch (IOException e) {
                Log.e(TAG, "Error closing tag...", e);
            }
        }

        return "";
    }

    @Override
    public boolean write(String content) {
        if(mTagFromIntent == null) return false;

        NdefRecord[] ndefRecords = new NdefRecord[]{createMimeRecord(content)};
        NdefMessage msg = new NdefMessage(ndefRecords);

        Ndef ndef = Ndef.get(mTagFromIntent);
        try {
            ndef.connect();
            ndef.writeNdefMessage(msg);
            return true;
        } catch (IOException e){
            Log.e(TAG, "IOException while write Ndef message...", e);
        } catch (FormatException e) {
            Log.e(TAG, "FormatException while write Ndef message...", e);
        } finally {
            try {
                ndef.close();
            } catch (IOException e) {
                Log.e(TAG, "Error closing tag...", e);
            }
        }
        return true;
    }

    private NdefRecord createMimeRecord(String content) {
        byte[] mimeData = Base64.encode(content.getBytes(Charset.forName("UTF-8")), Base64.DEFAULT);
        return NdefRecord.createMime(MIME_TYPE_NDEF, mimeData);
    }
}
