package com.szboanda.android.platform.http.impl;

import android.text.TextUtils;

import com.szboanda.android.platform.http.IDataProtocol;
import com.szboanda.android.platform.util.JsonUtils;

import org.json.JSONObject;

import java.lang.reflect.Type;

/**
 * <p>Description：</p>
 *
 * @author Created by Siyi Lu on 2017/2/28.
 */

public class JsonProtocol implements IDataProtocol {

    private String mDataKey = "";

    public void dataKey(String key){
        mDataKey = key;
    }

    @Override
    public <E> E convert(String result, Type type) {
        JSONObject resultJson = JsonUtils.parseJsonObject(result);
        JSONObject convertJson = TextUtils.isEmpty(mDataKey) ? resultJson : resultJson.optJSONObject(mDataKey);
        return (E)convertJson;
    }
}
