package com.szboanda.android.platform.http;

import android.content.Context;

import com.szboanda.android.platform.http.impl.ConnectErroResolver;
import com.szboanda.android.platform.http.impl.FZFErroResolver;
import com.szboanda.android.platform.http.impl.TimeoutErroResolver;

import org.xutils.ex.HttpException;

import java.net.ConnectException;
import java.net.SocketTimeoutException;

/**
 * <p>Description：</p>
 *
 * @author Created by Siyi Lu on 2017/3/6.
 */

public class ErrorResolverFactory {

    private ErrorResolverFactory(){}

    public static IErroResolver newResolver(Context context, Throwable ex){
        IErroResolver resolver = null;
        if(ex instanceof ConnectException){
            resolver = new ConnectErroResolver(context, ex);
        }else if (ex instanceof SocketTimeoutException){
            resolver = new TimeoutErroResolver(context, ex);
        }else if (ex instanceof HttpException){
            resolver = new FZFErroResolver(context, ex);
        }
        return resolver;
    }
}
