package com.szboanda.android.platform.dialog;

import com.szboanda.android.platform.http.impl.IProgressChangeView;
import com.szboanda.android.platform.util.BeanUtil;
import com.szboanda.android.platform.util.DimensionUtils;

import android.app.AlertDialog;
import android.content.Context;
import android.graphics.Color;
import android.graphics.PorterDuff.Mode;
import android.graphics.drawable.ClipDrawable;
import android.graphics.drawable.LayerDrawable;
import android.widget.ProgressBar;
import android.widget.RelativeLayout;
import android.widget.RelativeLayout.LayoutParams;
import android.widget.TextView;

public class PercentProgressDiaog extends ViewDialog implements IProgressChangeView{
	
	private Context mContext;
	
	private ProgressBar mProgressBar;
	
	/**百分比显示控件*/
    private TextView mProgressPercent;
    
    public AlertDialog mDialog;
    
    private String mTitle;
    
    private double mProgressMax = Double.MAX_VALUE; 
    
    private double mProgress = 0d;

	public PercentProgressDiaog(Context context, String title) {
		super(context);
		mContext = context;
		mTitle = title;
		buildDialog();
		clickWithDismiss = false;
	}
	
	/**创建进度条提示窗*/
	private void buildDialog(){
		setTitle(mTitle);
		RelativeLayout container = new RelativeLayout(mContext);
		mProgressBar = new ProgressBar(mContext);
		mProgressBar.setMax((int)mProgressMax);
		mProgressBar.setProgress((int)mProgress);
		mProgressBar.setId("progress".hashCode());
		BeanUtil.setFieldValue(mProgressBar, "mOnlyIndeterminate", Boolean.valueOf(false));
		mProgressBar.setIndeterminate(false);
		LayerDrawable layerDrawable = (LayerDrawable)mContext.getResources().getDrawable(android.R.drawable.progress_horizontal);
		ClipDrawable clipDrawable = (ClipDrawable)layerDrawable.getDrawable(2);
		clipDrawable.setColorFilter(Color.parseColor("#32B5E5"), Mode.SRC_IN);
		mProgressBar.setProgressDrawable(layerDrawable);
		mProgressBar.setPadding(0, 0, 0, 0);
		mProgressBar.setIndeterminateDrawable(
        		mContext.getResources().getDrawable(android.R.drawable.progress_indeterminate_horizontal));
		mProgressPercent = new TextView(mContext);
		mProgressPercent.setId("percent".hashCode());
		mProgressPercent.setText("0%");
		mProgressPercent.setTextSize(18);
		
		int lrPadding = DimensionUtils.dip2Px(mContext, 10);
		int tbPadding = DimensionUtils.dip2Px(mContext, 30);
		container.setPadding(lrPadding, tbPadding, lrPadding, tbPadding);
		
		LayoutParams progressLayoutParams = new LayoutParams(
				LayoutParams.MATCH_PARENT, DimensionUtils.dip2Px(mContext, 4));
		progressLayoutParams.addRule(RelativeLayout.CENTER_VERTICAL);
		progressLayoutParams.addRule(RelativeLayout.LEFT_OF, mProgressPercent.getId());
		progressLayoutParams.rightMargin = lrPadding;
		mProgressBar.setLayoutParams(progressLayoutParams);
		
		LayoutParams percentLayoutParams = new LayoutParams(
				LayoutParams.WRAP_CONTENT, LayoutParams.WRAP_CONTENT);
		percentLayoutParams.addRule(RelativeLayout.ALIGN_PARENT_RIGHT);
		percentLayoutParams.addRule(RelativeLayout.CENTER_VERTICAL);
		mProgressPercent.setLayoutParams(percentLayoutParams);
		
		container.addView(mProgressPercent);
		container.addView(mProgressBar);
		setView(container);
	}
	
	public void setProgress(int progress){
		mProgress = progress;
		mProgressBar.setProgress(progress);
		mProgressPercent.setText((int)((mProgress/mProgressMax)*100) + "%");
	}
	
	@Override
	public void initProgressMax(long progressMax) {
		mProgressMax = Double.parseDouble(progressMax + "");
		mProgressBar.setMax((int)progressMax);
	}

	@Override
	public void onProgressChanged(long total, final long current, int ratio) {
		try {
			setProgress((int)current);
		} catch (Exception e) {
			mProgressBar.post(new Runnable() {
				@Override
				public void run() {
					setProgress((int)current);
				}
			});
		}
	}
	
	@Override
	public void onFinish() {
		dismiss();
	}
	
}
