package com.szboanda.android.platform.db;

import android.database.Cursor;
import android.database.sqlite.SQLiteDatabase;
import android.text.TextUtils;


import com.szboanda.android.platform.util.BeanUtil;

import org.json.JSONArray;
import org.json.JSONObject;
import org.xutils.DbManager;
import org.xutils.common.util.KeyValue;
import org.xutils.db.DbManagerImpl;
import org.xutils.db.Selector;
import org.xutils.db.sqlite.SqlInfo;
import org.xutils.db.sqlite.SqlInfoBuilder;
import org.xutils.db.sqlite.WhereBuilder;
import org.xutils.db.table.DbModel;
import org.xutils.db.table.TableEntity;
import org.xutils.ex.DbException;

import java.io.IOException;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;

/**
 * <p>Description:数据库操作类 </p>
 * @author    Siyi Lu    Create Date: 2015-7-9
 */
public class SQLiteDao implements DbManager{

    private static SQLiteDao DAO = null;

    private static Object mLock = new Object();

    /**
     * 第三方数据库连接dao
     */
    protected DbManager m3tdPartyDao;

    private SQLiteDao(DaoConfig config){
        m3tdPartyDao = DbManagerImpl.getInstance(config);
    }

    public static SQLiteDao getInstance(DaoConfig config){
        if (DAO == null){
            synchronized (mLock){
                if (DAO == null){
                    DAO = new SQLiteDao(config);
                }
            }
        }
        return DAO;
    }

	public JSONObject getSingleValue(String sql){
		JSONArray array = getListValue(sql);
		if(array != null && array.length()>0){
			return array.optJSONObject(0);
		}else{
			return null;
		}
	}
	
	public synchronized JSONArray getListValue(String sql){
		JSONArray result = null;
		Cursor c = null;
		try{
			c = m3tdPartyDao.execQuery(sql);
			result = convertCursor2Array(c);
		}catch (Exception e) {
			e.printStackTrace();
		}finally{
			if(c != null){
				c.close();
			}
		}
		return result;
	}
	
	public static JSONArray convertCursor2Array(Cursor cursor){
		JSONArray jsonArray = new JSONArray();
		if (cursor != null && cursor.getCount() > 0) {
			String[] columns = cursor.getColumnNames();
			for (cursor.moveToFirst(); !cursor.isAfterLast(); cursor.moveToNext()) {
				if (columns == null || columns.length == 0) {
					break;
				} else {
					JSONObject jsonObject = new JSONObject();
					for (String columnName : columns) {
						try {
							String value = cursor.getString(cursor.getColumnIndex(columnName));
							if (TextUtils.isEmpty(value) || "null".equals(value)) {
								jsonObject.put(columnName.toUpperCase(Locale.getDefault()), "");
							} else {
								jsonObject.put(columnName.toUpperCase(Locale.getDefault()), value);
							}
						} catch (Exception e) {
							e.printStackTrace();
						}
					}
					jsonArray.put(jsonObject);
				}
			}
		}
		return jsonArray;
	}
	
	public void exeSql(String sql){
		try{
			m3tdPartyDao.execNonQuery(sql);
		}catch (Exception e) {
			e.printStackTrace();
		}
	}

    /**
     * 通用获取数据方法，property和value必须一一对应
     * @param dataList
     * @param property
     * @param value
     * @param arg
     * @param <T>
     * @return
     */
	public <T> List<T> getDataList(List<T> dataList,String[] property,String[] value,Class arg){
		dataList = new ArrayList<T>();
		try {
			Selector select = m3tdPartyDao.selector(arg);
			for(int i=0;i<property.length;i++){
				select.where(property[i], "=",value[i]);
			}
			dataList = select.findAll();
		} catch (DbException e) {
			e.printStackTrace();
		}
		return dataList;
	}

    @Override
    public DaoConfig getDaoConfig() {
        return m3tdPartyDao.getDaoConfig();
    }

    @Override
    public SQLiteDatabase getDatabase() {
        return m3tdPartyDao.getDatabase();
    }

    @Override
    public boolean saveBindingId(Object entity) throws DbException {
        return m3tdPartyDao.saveBindingId(entity);
    }

    @Override
    public void saveOrUpdate(Object entity) throws DbException {
        m3tdPartyDao.saveOrUpdate(entity);
    }

    @Override
    public void save(Object entity) throws DbException {
        m3tdPartyDao.save(entity);
    }

    @Override
    public void replace(Object entity) throws DbException {
        m3tdPartyDao.replace(entity);
    }

    @Override
    public void deleteById(Class<?> entityType, Object idValue) throws DbException {
        m3tdPartyDao.deleteById(entityType, idValue);
    }

    @Override
    public void delete(Object entity) throws DbException {
        m3tdPartyDao.delete(entity);
    }

    @Override
    public void delete(Class<?> entityType) throws DbException {
        m3tdPartyDao.delete(entityType);
    }

    @Override
    public int delete(Class<?> entityType, WhereBuilder whereBuilder) throws DbException {
        return m3tdPartyDao.delete(entityType, whereBuilder);
    }

    @Override
    public void update(Object entity, String... updateColumnNames) throws DbException {
        m3tdPartyDao.update(entity, updateColumnNames);
    }

    @Override
    public int update(Class<?> entityType, WhereBuilder whereBuilder, KeyValue... nameValuePairs) throws DbException {
        return m3tdPartyDao.update(entityType, whereBuilder, nameValuePairs);
    }

    @Override
    public <T> T findById(Class<T> entityType, Object idValue) throws DbException {
        return m3tdPartyDao.findById(entityType, idValue);
    }

    @Override
    public <T> T findFirst(Class<T> entityType) throws DbException {
        return m3tdPartyDao.findFirst(entityType);
    }

    @Override
    public <T> List<T> findAll(Class<T> entityType) throws DbException {
        return m3tdPartyDao.findAll(entityType);
    }

    @Override
    public <T> Selector<T> selector(Class<T> entityType) throws DbException {
        return m3tdPartyDao.selector(entityType);
    }

    @Override
    public DbModel findDbModelFirst(SqlInfo sqlInfo) throws DbException {
        return m3tdPartyDao.findDbModelFirst(sqlInfo);
    }

    @Override
    public List<DbModel> findDbModelAll(SqlInfo sqlInfo) throws DbException {
        return m3tdPartyDao.findDbModelAll(sqlInfo);
    }

    @Override
    public <T> TableEntity<T> getTable(Class<T> entityType) throws DbException {
        return m3tdPartyDao.getTable(entityType);
    }

    @Override
    public void dropTable(Class<?> entityType) throws DbException {
        m3tdPartyDao.dropTable(entityType);
    }

    @Override
    public void addColumn(Class<?> entityType, String column) throws DbException {
        m3tdPartyDao.addColumn(entityType, column);
    }

    @Override
    public void dropDb() throws DbException {
        m3tdPartyDao.dropDb();
    }

    @Override
    public void close() throws IOException {
        m3tdPartyDao.close();
    }

    @Override
    public int executeUpdateDelete(SqlInfo sqlInfo) throws DbException {
        return m3tdPartyDao.executeUpdateDelete(sqlInfo);
    }

    @Override
    public int executeUpdateDelete(String sql) throws DbException {
        return m3tdPartyDao.executeUpdateDelete(sql);
    }

    @Override
    public void execNonQuery(SqlInfo sqlInfo) throws DbException {
        m3tdPartyDao.execNonQuery(sqlInfo);
    }

    @Override
    public void execNonQuery(String sql) throws DbException {
        m3tdPartyDao.execNonQuery(sql);
    }

    @Override
    public Cursor execQuery(SqlInfo sqlInfo) throws DbException {
        return m3tdPartyDao.execQuery(sqlInfo);
    }

    @Override
    public Cursor execQuery(String sql) throws DbException {
        return m3tdPartyDao.execQuery(sql);
    }

    public void createTableIfNotExist(Class<?> tableCls){
        try{
            TableEntity<?> table = getTable(tableCls);
            if (!table.tableIsExist()) {
                synchronized (table.getClass()) {
                    if (!table.tableIsExist()) {
                        SqlInfo sqlInfo = SqlInfoBuilder.buildCreateTableSqlInfo(table);
                        execNonQuery(sqlInfo);
                        String execAfterTableCreated = table.getOnCreated();
                        if (!TextUtils.isEmpty(execAfterTableCreated)) {
                            execNonQuery(execAfterTableCreated);
                        }
                        Method method = TableEntity.class.getDeclaredMethod("setCheckedDatabase", boolean.class);
                        method.setAccessible(true);
                        if(method != null) {
                            method.invoke(table, true);
                        }
                        TableCreateListener listener = this.getDaoConfig().getTableCreateListener();
                        if (listener != null) {
                            listener.onTableCreated(this, table);
                        }
                    }
                }
            }
        }catch(Exception e){
            e.printStackTrace();
        }
    }

    public boolean isTableExist(Class<?> tableCls){
        boolean exist = false;
        try{
            TableEntity table = getTable(tableCls);
            exist = table.tableIsExist();
        }catch(Exception e){
            e.printStackTrace();
        }
        return exist;
    }

    public <E> List<E> getEntitysBySql(String sql, Type type){
        List<E> result = null;
        JSONArray array = getListValue(sql);
        if(array != null && array.length() > 0){
            result = BeanUtil.convertArrayStr2Entitys(array.toString(), type);
        }
        return result;
    }
}
