package com.szboanda.android.platform.activity;

import java.io.File;

import android.app.Activity;
import android.content.Intent;
import android.os.Bundle;
import android.os.Handler;
import android.text.TextUtils;

import com.szboanda.android.platform.util.AESUtils;
import com.szboanda.android.platform.util.FileUtils;

/**
 * <p>Description: 打开加密文件的过滤界面，主要是希望利用{@link #onActivityResult(int, int, Intent)}方法删除明文文件</p>
 * @author    Siyi Lu    Create Date: 2014-11-10
 */
public class OpenEncryptBridgeActivity extends Activity{
	
	public static final String P_REQUIRE_PATH = "";
	
	private String filePath = "";
	
	@Override
	protected void onCreate(Bundle savedInstanceState) {
		super.onCreate(savedInstanceState);
		getIntentParams();
		if(TextUtils.isEmpty(filePath)){
			asyncOpenFile();
		}
	}
	
	private void getIntentParams(){
		Intent intent = getIntent();
		filePath = intent.getStringExtra(P_REQUIRE_PATH);
	}
	
	Handler mHandler = new Handler();
	private void asyncOpenFile(){
		new Thread(){
			public void run() {
				File file = new File(filePath);
				if(!file.exists()){
					AESUtils au = new AESUtils();
					au.defaultAesDecrypt(OpenEncryptBridgeActivity.this, filePath);
				}
				mHandler.post(new Runnable() {
					@Override
					public void run() {
						Intent intent = FileUtils.openFile(filePath);
						startActivityForResult(intent, 12345);
					}
				});
			};
		}.start();
	}
	
	@Override
	protected void onActivityResult(int requestCode, int resultCode, Intent data) {
		super.onActivityResult(requestCode, resultCode, data);
		//使用第三方应用打开加密文件后需要删除解密后的文件
		File file = new File(filePath);
		if(file != null){
			file.delete();
		}
		finish();
	}
	
}
