/*
 * Decompiled with CFR 0.152.
 */
package org.xutils.http.body;

import android.text.TextUtils;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import org.xutils.http.body.RequestBody;

public class StringBody
implements RequestBody {
    private byte[] content;
    private String contentType;
    private String charset = "UTF-8";

    public StringBody(String str, String charset) throws UnsupportedEncodingException {
        if (!TextUtils.isEmpty((CharSequence)charset)) {
            this.charset = charset;
        }
        this.content = str.getBytes(this.charset);
    }

    @Override
    public long getContentLength() {
        return this.content.length;
    }

    @Override
    public void setContentType(String contentType) {
        this.contentType = contentType;
    }

    @Override
    public String getContentType() {
        return TextUtils.isEmpty((CharSequence)this.contentType) ? "application/json;charset=" + this.charset : this.contentType;
    }

    @Override
    public void writeTo(OutputStream out) throws IOException {
        out.write(this.content);
        out.flush();
    }
}

