/*
 * Decompiled with CFR 0.152.
 */
package com.szboanda.android.platform.view.wheel;

import android.database.DataSetObserver;
import android.view.View;
import android.view.ViewGroup;
import com.szboanda.android.platform.view.wheel.WheelViewAdapter;
import java.util.LinkedList;
import java.util.List;

public abstract class AbstractWheelAdapter
implements WheelViewAdapter {
    private List<DataSetObserver> datasetObservers;
    private int scopeFloorIndex = Integer.MIN_VALUE;
    private int scopeUpperIndex = Integer.MAX_VALUE;

    @Override
    public View getEmptyItem(View convertView, ViewGroup parent) {
        return null;
    }

    @Override
    public void registerDataSetObserver(DataSetObserver observer) {
        if (this.datasetObservers == null) {
            this.datasetObservers = new LinkedList<DataSetObserver>();
        }
        this.datasetObservers.add(observer);
    }

    @Override
    public void unregisterDataSetObserver(DataSetObserver observer) {
        if (this.datasetObservers != null) {
            this.datasetObservers.remove(observer);
        }
    }

    protected void notifyDataChangedEvent() {
        if (this.datasetObservers != null) {
            for (DataSetObserver observer : this.datasetObservers) {
                observer.onChanged();
            }
        }
    }

    protected void notifyDataInvalidatedEvent() {
        if (this.datasetObservers != null) {
            for (DataSetObserver observer : this.datasetObservers) {
                observer.onInvalidated();
            }
        }
    }

    @Override
    public void setScrollingScope(int floorIndex, int upperIndex) {
        this.scopeFloorIndex = floorIndex;
        this.scopeUpperIndex = upperIndex;
    }

    @Override
    public int getScopeFloorIndex() {
        return this.scopeFloorIndex;
    }

    @Override
    public int getScopeUpperIndex() {
        return this.scopeUpperIndex;
    }
}

