/*
 * Decompiled with CFR 0.152.
 */
package com.szboanda.android.platform.view;

import android.content.Context;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.AbsListView;
import android.widget.BaseAdapter;
import com.szboanda.android.platform.view.IChangeDataSet;
import com.szboanda.android.platform.view.IPinnedHeaderListItem;
import com.szboanda.android.platform.view.PinnedHeaderListView;
import java.util.ArrayList;
import java.util.List;

public abstract class UniversalPinnedHeaderAdapter<T extends IPinnedHeaderListItem>
extends BaseAdapter
implements PinnedHeaderListView.PinnedHeaderAdapter,
AbsListView.OnScrollListener,
IChangeDataSet<T> {
    public static final int TYPE_GROUP = 0;
    public static final int TYPE_ITEM = 1;
    private LayoutInflater mInflater;
    private List<T> mData = new ArrayList<T>();
    protected int groupItemLayoutId = -1;
    protected int childItemLayoutId = -1;
    private Context mContext;

    public UniversalPinnedHeaderAdapter(Context context, int groupItemLayoutId, int childItemLayoutId) {
        this.mInflater = LayoutInflater.from((Context)context);
        this.mContext = context;
        this.groupItemLayoutId = groupItemLayoutId;
        this.childItemLayoutId = childItemLayoutId;
    }

    public Context getContext() {
        return this.mContext;
    }

    public List<T> getData() {
        return this.mData;
    }

    @Override
    public void setData(List<T> items) {
        if (items != null) {
            this.mData.clear();
            this.mData.addAll(items);
        }
    }

    @Override
    public void addData(List<T> items) {
        if (items != null) {
            this.mData.addAll(items);
        }
    }

    public int getCount() {
        return this.mData.size();
    }

    public boolean areAllItemsEnabled() {
        return false;
    }

    public boolean isEnabled(int position) {
        if (this.mData == null && position <= 0 || position >= this.getCount()) {
            return false;
        }
        IPinnedHeaderListItem item = (IPinnedHeaderListItem)this.mData.get(position);
        return !item.isGroupItem();
    }

    public T getItem(int position) {
        return (T)(position >= 1 && position <= this.mData.size() - 1 ? (IPinnedHeaderListItem)this.mData.get(position) : null);
    }

    public long getItemId(int position) {
        return 0L;
    }

    public View getView(int position, View convertView, ViewGroup parent) {
        int viewType = this.getItemViewType(position);
        IPinnedHeaderListItem itemData = (IPinnedHeaderListItem)this.mData.get(position);
        View view = this.getItemView(convertView, parent, this.mInflater, itemData, viewType);
        return view;
    }

    public int getItemViewType(int position) {
        if (this.mData == null || position < 0 || position > this.getCount()) {
            return 1;
        }
        IPinnedHeaderListItem item = (IPinnedHeaderListItem)this.mData.get(position);
        if (item.isGroupItem()) {
            return 0;
        }
        return 1;
    }

    public int getViewTypeCount() {
        return 2;
    }

    @Override
    public int getPinnedHeaderState(int firstVisableItemPosition) {
        if (firstVisableItemPosition <= 0) {
            return 0;
        }
        Object item = this.getItem(firstVisableItemPosition);
        Object itemNext = this.getItem(firstVisableItemPosition + 1);
        if (itemNext != null) {
            boolean isNextNotGroup;
            boolean isFirstGroup = item.isGroupItem();
            boolean bl = itemNext != null ? !itemNext.isGroupItem() : (isNextNotGroup = true);
            if (isFirstGroup && isNextNotGroup) {
                return 2;
            }
        } else {
            return 0;
        }
        return 1;
    }

    @Override
    public abstract void refreshHeaderView(View var1, int var2, int var3);

    public void onScrollStateChanged(AbsListView view, int scrollState) {
    }

    public void onScroll(AbsListView view, int firstVisibleItem, int visibleItemCount, int totalItemCount) {
        if (view instanceof PinnedHeaderListView) {
            ((PinnedHeaderListView)view).layoutHeaderView(firstVisibleItem);
        }
    }

    public abstract View getItemView(View var1, ViewGroup var2, LayoutInflater var3, T var4, int var5);
}

