/*
 * Decompiled with CFR 0.152.
 */
package com.szboanda.android.platform.view;

import android.content.Context;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.BaseAdapter;
import com.szboanda.android.platform.view.IChangeDataSet;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public abstract class UniversalAdapter<T>
extends BaseAdapter
implements IChangeDataSet<T> {
    protected Context mContext;
    protected List<T> mData = new ArrayList<T>();
    public LayoutInflater mLayoutInflater;
    protected int mItemLayoutId;

    public UniversalAdapter(Context context) {
        this.mContext = context;
        this.mLayoutInflater = LayoutInflater.from((Context)this.mContext);
    }

    public UniversalAdapter(Context context, List<T> data, int itemLayoutId) {
        this.mContext = context;
        this.mItemLayoutId = itemLayoutId;
        this.mLayoutInflater = LayoutInflater.from((Context)this.mContext);
        this.setData(data);
    }

    public Context getContext() {
        return this.mContext;
    }

    @Override
    public void setData(List<T> data) {
        if (data != null) {
            this.mData.clear();
            this.mData.addAll(data);
        }
    }

    @Override
    public void addData(List<T> data) {
        if (data != null) {
            this.mData.addAll(data);
        }
    }

    public List<T> getData() {
        ArrayList<T> result = new ArrayList<T>();
        result.addAll(this.mData);
        return result;
    }

    public void clearData() {
        this.mData.clear();
    }

    public void setItemLayoutId(int itemLayoutId) {
        this.mItemLayoutId = itemLayoutId;
    }

    public int getCount() {
        return this.mData.size();
    }

    public T getItem(int position) {
        return this.mData.get(position);
    }

    public long getItemId(int position) {
        return position;
    }

    public View getView(int position, View convertView, ViewGroup parent) {
        ViewHolder holder = ViewHolder.get(this.mLayoutInflater, convertView, this.mItemLayoutId, position);
        this.bindViewsData(position, holder.getConvertView(), this.getItem(position));
        return holder.getConvertView();
    }

    public abstract void bindViewsData(int var1, View var2, T var3);

    public Map<String, Object> getMapData(int position) {
        return null;
    }

    static class ViewHolder {
        private View mConvertView;

        private ViewHolder(LayoutInflater inflater, int layoutId, int position) {
            this.mConvertView = inflater.inflate(layoutId, null);
            this.mConvertView.setTag((Object)this);
        }

        public static ViewHolder get(LayoutInflater inflater, View convertView, int layoutId, int position) {
            if (convertView == null) {
                return new ViewHolder(inflater, layoutId, position);
            }
            return (ViewHolder)convertView.getTag();
        }

        public View getConvertView() {
            return this.mConvertView;
        }
    }
}

