/*
 * Decompiled with CFR 0.152.
 */
package com.szboanda.android.platform.view;

import android.content.Context;
import android.graphics.drawable.Drawable;
import android.text.Editable;
import android.text.TextWatcher;
import android.text.method.HideReturnsTransformationMethod;
import android.text.method.PasswordTransformationMethod;
import android.text.method.TransformationMethod;
import android.util.AttributeSet;
import android.view.MotionEvent;
import android.view.View;
import android.view.animation.Animation;
import android.view.animation.CycleInterpolator;
import android.view.animation.Interpolator;
import android.view.animation.TranslateAnimation;
import android.widget.EditText;

public class PasswordInputText
extends EditText
implements View.OnFocusChangeListener,
TextWatcher {
    private Drawable mVisibleDrawable;
    private boolean visible = false;

    public PasswordInputText(Context context) {
        super(context);
        this.init();
    }

    public PasswordInputText(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init();
    }

    public PasswordInputText(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        this.init();
    }

    private void init() {
        if (this.getInputType() == 0) {
            this.setInputType(128);
            this.setTransformationMethod((TransformationMethod)PasswordTransformationMethod.getInstance());
        }
        this.mVisibleDrawable = this.getCompoundDrawables()[2];
        if (this.mVisibleDrawable == null) {
            this.mVisibleDrawable = this.getResources().getDrawable(17301591);
        }
        this.mVisibleDrawable.setBounds(0, 0, this.mVisibleDrawable.getIntrinsicWidth(), this.mVisibleDrawable.getIntrinsicHeight());
        this.setVisibleIconVisible(false);
        this.setOnFocusChangeListener(this);
        this.addTextChangedListener(this);
    }

    public boolean onTouchEvent(MotionEvent event) {
        if (this.getCompoundDrawables()[2] != null && event.getAction() == 1) {
            boolean touchable;
            boolean bl = touchable = event.getX() > (float)(this.getWidth() - this.getPaddingRight() - this.mVisibleDrawable.getIntrinsicWidth()) && event.getX() < (float)(this.getWidth() - this.getPaddingRight());
            if (touchable) {
                if (this.visible) {
                    this.visible = false;
                    this.setTransformationMethod((TransformationMethod)PasswordTransformationMethod.getInstance());
                } else {
                    this.visible = true;
                    this.setTransformationMethod((TransformationMethod)HideReturnsTransformationMethod.getInstance());
                }
            }
        }
        return super.onTouchEvent(event);
    }

    public void onFocusChange(View v, boolean hasFocus) {
        if (hasFocus) {
            this.setVisibleIconVisible(this.getText().length() > 0);
        } else {
            this.setVisibleIconVisible(false);
        }
    }

    protected void setVisibleIconVisible(boolean visible) {
        Drawable right = visible ? this.mVisibleDrawable : null;
        this.setCompoundDrawables(this.getCompoundDrawables()[0], this.getCompoundDrawables()[1], right, this.getCompoundDrawables()[3]);
    }

    public void onTextChanged(CharSequence s, int start, int count, int after) {
        this.setVisibleIconVisible(s.length() > 0);
    }

    public void beforeTextChanged(CharSequence s, int start, int count, int after) {
    }

    public void afterTextChanged(Editable s) {
    }

    public void setShakeAnimation() {
        this.setAnimation(PasswordInputText.shakeAnimation(5));
    }

    public static Animation shakeAnimation(int counts) {
        TranslateAnimation translateAnimation = new TranslateAnimation(0.0f, 10.0f, 0.0f, 0.0f);
        translateAnimation.setInterpolator((Interpolator)new CycleInterpolator((float)counts));
        translateAnimation.setDuration(1000L);
        return translateAnimation;
    }

    public String getFieldValue() {
        return this.getText().toString().trim();
    }
}

