/*
 * Decompiled with CFR 0.152.
 */
package com.szboanda.android.platform.view;

import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.text.TextUtils;
import android.util.DisplayMetrics;
import android.util.TypedValue;
import android.view.View;
import java.util.ArrayList;
import java.util.List;

public class LabelDrawer {
    private static final int DEFAULT_LABEL_COLOR = -10066330;
    private String mLabel = "";
    private int mLabelTextColor = -10066330;
    private List<String> mBreakedLabels;
    private int mOriginalPaddingLeft = 0;
    private int mOriginalPaddingTop = 0;
    private int mOriginalPaddingRight = 0;
    private int mOriginalPaddingBottom = 0;
    private int adjustPadding = 0;
    private boolean isHorizontalAlignRight = false;
    private boolean isLabelAlignVerticalCenter = true;
    private int labelWeight = -1;
    private int widthBetweenLableText = 0;
    private int mLabelPaddingLeft = 0;
    private Paint mLabelPaint = null;
    boolean hasMeasureLabel;
    int mLabelHeight;
    Context mContext;
    private int mSingleLineLabelHeight;
    private int mLabelHeightSum;
    private int mLineSpace;

    public LabelDrawer() {
        this.init();
    }

    public LabelDrawer(Context context) {
        this.mContext = context;
        this.init();
    }

    public LabelDrawer(String label) {
        this.mLabel = label;
        this.init();
    }

    private void init() {
        this.mLabelPaint = new Paint();
        this.mLabelPaint.setColor(this.mLabelTextColor);
        this.mLabelPaint.setAntiAlias(true);
        this.mLabelPaint.setTextAlign(Paint.Align.LEFT);
        if (this.mContext == null) {
            this.mLabelPaint.setTextSize(32.0f);
        } else {
            float labelSize = TypedValue.applyDimension((int)2, (float)16.0f, (DisplayMetrics)this.mContext.getResources().getDisplayMetrics());
            this.setLabelSize(labelSize);
        }
    }

    public void setLabel(String label) {
        this.mLabel = label;
    }

    public String getLabel() {
        return this.mLabel;
    }

    public void setLabelSize(float size) {
        this.mLabelPaint.setTextSize(size);
    }

    public void setLableTextColor(int color) {
        this.mLabelTextColor = color;
        this.mLabelPaint.setColor(color);
    }

    public int getLableTextColor() {
        return this.mLabelTextColor;
    }

    public void setLabelWeight(int labelWeight) {
        this.labelWeight = labelWeight > 50 ? 50 : labelWeight;
    }

    public void setLabelPaddingLeft(int padding) {
        this.mLabelPaddingLeft = padding;
    }

    public void setLabelMarginRight(int margin) {
        this.widthBetweenLableText = margin;
    }

    public void setHorizontalAlignRight(boolean isHorizontalAlignRight) {
        this.isHorizontalAlignRight = isHorizontalAlignRight;
    }

    public void setLabelAlignVerticalCenter(boolean isLabelAlignVerticalCenter) {
        this.isLabelAlignVerticalCenter = isLabelAlignVerticalCenter;
    }

    public int getAdjustedPadding() {
        return this.adjustPadding;
    }

    public int getOriginalPaddingLeft() {
        return this.mOriginalPaddingLeft;
    }

    public float getLabelTextSize() {
        return this.mLabelPaint.getTextSize();
    }

    public int measureLabel(View view, int measureWidth, int measureHeight) {
        if (!this.hasMeasureLabel) {
            this.mOriginalPaddingLeft = view.getPaddingLeft();
            this.mOriginalPaddingTop = view.getPaddingTop();
            this.mOriginalPaddingRight = view.getPaddingRight();
            this.mOriginalPaddingBottom = view.getPaddingBottom();
            this.caculateAdustPadding(measureWidth);
            view.setPadding(this.adjustPadding, this.mOriginalPaddingTop, this.mOriginalPaddingRight, this.mOriginalPaddingBottom);
            this.breakLabel(this.mLabel);
            this.hasMeasureLabel = true;
        }
        this.mLabelHeight = this.mLabelHeightSum + this.mOriginalPaddingTop + this.mOriginalPaddingBottom;
        this.mLabelHeight = Math.max(measureHeight, this.mLabelHeight);
        return this.mLabelHeight;
    }

    private int caculateAdustPadding(int measureWidth) {
        if (this.labelWeight == -1) {
            int labelWidth = (int)this.mLabelPaint.measureText(this.mLabel);
            this.adjustPadding = this.mLabelPaddingLeft + labelWidth + this.widthBetweenLableText + this.mOriginalPaddingLeft;
        } else {
            this.adjustPadding = measureWidth * this.labelWeight / 100 + this.mOriginalPaddingLeft;
        }
        return this.adjustPadding;
    }

    private void breakLabel(String label) {
        int residualWidth = this.adjustPadding - this.mLabelPaddingLeft - this.widthBetweenLableText - this.mOriginalPaddingLeft;
        int index = this.mLabelPaint.breakText(label, true, (float)residualWidth, null);
        Paint.FontMetrics fontMetrics = this.mLabelPaint.getFontMetrics();
        this.mSingleLineLabelHeight = (int)(fontMetrics.bottom + Math.abs(fontMetrics.top));
        if (index <= label.length()) {
            String lineLabel = label.substring(0, index);
            if (this.mBreakedLabels == null) {
                this.mBreakedLabels = new ArrayList<String>();
            }
            this.mBreakedLabels.add(lineLabel);
            this.mLabelHeightSum += this.mSingleLineLabelHeight + this.mLineSpace;
            String residualLabel = label.substring(index, label.length());
            if (!TextUtils.isEmpty((CharSequence)residualLabel)) {
                this.breakLabel(residualLabel);
            } else {
                this.mLabelHeightSum -= this.mLineSpace;
            }
        }
    }

    public void drawLabel(Canvas canvas) {
        int x2 = this.caculateX();
        int lineNum = 0;
        for (String label : this.mBreakedLabels) {
            int y = this.caculateY(lineNum);
            canvas.drawText(label, (float)x2, (float)y, this.mLabelPaint);
            ++lineNum;
        }
    }

    private int caculateX() {
        int x2;
        if (this.labelWeight != -1 && this.isHorizontalAlignRight) {
            this.mLabelPaint.setTextAlign(Paint.Align.RIGHT);
            x2 = this.adjustPadding - this.mOriginalPaddingLeft - this.widthBetweenLableText;
        } else {
            x2 = this.mLabelPaddingLeft;
        }
        return x2;
    }

    private int caculateY(int lineNum) {
        Paint.FontMetrics fontMetrics = this.mLabelPaint.getFontMetrics();
        int y = 0;
        int startY = this.isLabelAlignVerticalCenter ? this.mLabelHeight / 2 - this.mLabelHeightSum / 2 : this.mOriginalPaddingTop;
        y += ++startY + lineNum * this.mSingleLineLabelHeight + (int)Math.abs(fontMetrics.top);
        return y += lineNum * this.mLineSpace;
    }
}

