/*
 * Decompiled with CFR 0.152.
 */
package com.szboanda.android.platform.util;

import android.content.Context;
import android.os.Environment;
import java.io.File;

public class CleanUtils {
    private static void deleteFilesByDirectory(File directory) {
        if (directory != null && directory.exists() && directory.isDirectory()) {
            for (File item : directory.listFiles()) {
                if (item.isDirectory()) {
                    CleanUtils.deleteFilesByDirectory(item);
                }
                item.delete();
            }
            directory.delete();
        }
    }

    private static String getApplicationFilePath(Context context) {
        return context.getFilesDir().getParentFile().getPath();
    }

    public static void cleanInternalCache(Context context) {
        CleanUtils.deleteFilesByDirectory(context.getCacheDir());
    }

    public static void cleanDatabases(Context context) {
        CleanUtils.deleteFilesByDirectory(new File(CleanUtils.getApplicationFilePath(context) + "/databases"));
    }

    public static void cleanSharedPreference(Context context) {
        CleanUtils.deleteFilesByDirectory(new File(CleanUtils.getApplicationFilePath(context) + "/shared_prefs"));
    }

    public static void cleanDatabaseByName(Context context, String dbName) {
        context.deleteDatabase(dbName);
    }

    public static void cleanFiles(Context context) {
        CleanUtils.deleteFilesByDirectory(context.getFilesDir());
    }

    public static void cleanExternalCache(Context context) {
        if (Environment.getExternalStorageState().equals("mounted")) {
            CleanUtils.deleteFilesByDirectory(context.getExternalCacheDir());
        }
    }

    public static void cleanCustomCache(String filePath) {
        CleanUtils.deleteFilesByDirectory(new File(filePath));
    }

    public static void cleanApplicationData(Context context, String ... filepath) {
        CleanUtils.cleanInternalCache(context);
        CleanUtils.cleanExternalCache(context);
        CleanUtils.cleanDatabases(context);
        CleanUtils.cleanSharedPreference(context);
        CleanUtils.cleanFiles(context);
        for (String filePath : filepath) {
            CleanUtils.cleanCustomCache(filePath);
        }
    }
}

