/*
 * Decompiled with CFR 0.152.
 */
package com.szboanda.android.platform.util;

import android.annotation.SuppressLint;
import android.content.Context;
import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Canvas;
import android.graphics.Matrix;
import android.graphics.Paint;
import android.graphics.Path;
import android.graphics.Point;
import android.graphics.PointF;
import android.graphics.drawable.Drawable;
import android.text.TextPaint;
import android.text.TextUtils;
import android.util.Base64;
import android.widget.ImageView;
import com.szboanda.android.platform.util.DimensionUtils;
import com.szboanda.android.platform.util.FileUtils;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.util.HashSet;
import java.util.Set;

@SuppressLint(value={"RtlHardcoded"})
public class BitmapUtils {
    private static final Set<String> SUFFIXS = new HashSet<String>();

    public static String bitmapToBase64(Bitmap bitmap) {
        String string2 = null;
        ByteArrayOutputStream bStream = new ByteArrayOutputStream();
        bitmap.compress(Bitmap.CompressFormat.PNG, 100, (OutputStream)bStream);
        byte[] bytes = bStream.toByteArray();
        string2 = Base64.encodeToString((byte[])bytes, (int)0);
        return string2;
    }

    public static Bitmap base64ToBitmp(String content) {
        Bitmap b = null;
        try {
            byte[] bs = Base64.decode((String)content, (int)0);
            b = BitmapFactory.decodeByteArray((byte[])bs, (int)0, (int)bs.length);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return b;
    }

    public static Bitmap getAlphaBitmap(Context context, int resId) {
        Bitmap mBitmap = BitmapFactory.decodeResource((Resources)context.getResources(), (int)resId);
        Bitmap mAlphaBitmap = Bitmap.createBitmap((int)mBitmap.getWidth(), (int)mBitmap.getHeight(), (Bitmap.Config)Bitmap.Config.ARGB_8888);
        Canvas mCanvas = new Canvas(mAlphaBitmap);
        Paint mPaint = new Paint();
        mPaint.setColor(-16776961);
        Bitmap alphaBitmap = mBitmap.extractAlpha();
        mCanvas.drawBitmap(alphaBitmap, 0.0f, 0.0f, mPaint);
        return mAlphaBitmap;
    }

    public static Bitmap getRotatedBitmap(Context context, int resId, int degree) {
        Bitmap mBitmap = BitmapFactory.decodeResource((Resources)context.getResources(), (int)resId);
        Bitmap mRotateBitmap = BitmapUtils.getRotatedBitmap(mBitmap, degree);
        return mRotateBitmap;
    }

    public static Bitmap getRotatedBitmap(Bitmap mBitmap, int degree) {
        try {
            int width = mBitmap.getWidth();
            int height = mBitmap.getHeight();
            Matrix matrix = new Matrix();
            matrix.preRotate((float)degree);
            Bitmap mRotateBitmap = Bitmap.createBitmap((Bitmap)mBitmap, (int)0, (int)0, (int)width, (int)height, (Matrix)matrix, (boolean)true);
            return mRotateBitmap;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static int calculateInSampleSize(BitmapFactory.Options options, int reqWidth, int reqHeight) {
        int width = options.outWidth;
        int height = options.outHeight;
        int inSampleSize = 1;
        if (height > reqHeight || width > reqWidth) {
            int widthRatio;
            int heightRatio = Math.round((float)height / (float)reqHeight);
            inSampleSize = heightRatio < (widthRatio = Math.round((float)width / (float)reqWidth)) ? heightRatio : widthRatio;
        }
        return inSampleSize;
    }

    public static Bitmap decodeSampledBitmapFromResource(Resources res, int resId, int reqWidth, int reqHeight) {
        BitmapFactory.Options options = new BitmapFactory.Options();
        options.inJustDecodeBounds = true;
        BitmapFactory.decodeResource((Resources)res, (int)resId, (BitmapFactory.Options)options);
        options.inSampleSize = BitmapUtils.calculateInSampleSize(options, reqWidth, reqHeight);
        options.inJustDecodeBounds = false;
        return BitmapFactory.decodeResource((Resources)res, (int)resId, (BitmapFactory.Options)options);
    }

    public static Bitmap decodeSampledBitmapFromFile(String path, int reqWidth, int reqHeight) {
        if (!FileUtils.fileExist(path)) {
            return null;
        }
        BitmapFactory.Options options = new BitmapFactory.Options();
        options.inJustDecodeBounds = true;
        BitmapFactory.decodeFile((String)path, (BitmapFactory.Options)options);
        options.inSampleSize = BitmapUtils.calculateInSampleSize(options, reqWidth, reqHeight);
        options.inJustDecodeBounds = false;
        return BitmapFactory.decodeFile((String)path, (BitmapFactory.Options)options);
    }

    public static Bitmap drawableToBitmap(Drawable drawable2) {
        Bitmap bitmap = Bitmap.createBitmap((int)drawable2.getIntrinsicWidth(), (int)drawable2.getIntrinsicHeight(), (Bitmap.Config)(drawable2.getOpacity() != -1 ? Bitmap.Config.ARGB_8888 : Bitmap.Config.RGB_565));
        Canvas canvas = new Canvas(bitmap);
        drawable2.setBounds(0, 0, drawable2.getIntrinsicWidth(), drawable2.getIntrinsicHeight());
        drawable2.draw(canvas);
        return bitmap;
    }

    public static void saveBitmapToFile(Bitmap bitmap, String path) {
        File file = new File(path);
        try {
            FileOutputStream out = new FileOutputStream(file);
            if (bitmap.compress(Bitmap.CompressFormat.JPEG, 80, (OutputStream)out)) {
                out.flush();
                out.close();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static boolean saveToFile(ImageView imgView, String path) {
        if (imgView.getDrawable() == null) {
            return false;
        }
        Bitmap bmp = null;
        try {
            bmp = BitmapUtils.drawableToBitmap(imgView.getDrawable());
        }
        catch (Exception e) {
            return false;
        }
        if (bmp == null) {
            return false;
        }
        try {
            if (TextUtils.isEmpty((CharSequence)path)) {
                return false;
            }
            BitmapUtils.saveBitmapToFile(bmp, path);
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
        return true;
    }

    public static Bitmap drawDotWithText(int radius, int dotColor, String text, float textSize, int textColor) {
        int width = radius * 2;
        Bitmap dot = Bitmap.createBitmap((int)width, (int)width, (Bitmap.Config)Bitmap.Config.ARGB_8888);
        Canvas c = new Canvas(dot);
        Paint p = new Paint();
        p.setAntiAlias(true);
        p.setStyle(Paint.Style.FILL);
        p.setColor(dotColor);
        c.drawCircle((float)radius, (float)radius, (float)radius, p);
        TextPaint textPaint = new TextPaint();
        textPaint.setFlags(1);
        textPaint.setTextAlign(Paint.Align.CENTER);
        textPaint.setLinearText(true);
        textPaint.setColor(textColor);
        textPaint.setTextSize(textSize);
        if (text != null) {
            float length = textPaint.measureText(text);
            float per = length / (float)text.length();
            int total = (int)(Math.sqrt((float)(4 * radius * radius) - textSize * textSize) / (double)per);
            if (total > 0 && total < text.length()) {
                text = text.substring(0, total);
            } else if (total == 0) {
                text = "";
            }
            c.drawText(text, (float)radius, (float)radius - (textPaint.descent() + textPaint.ascent()) / 2.0f, (Paint)textPaint);
        }
        return dot;
    }

    public static Bitmap drawDot(int radius, int color) {
        Bitmap dot = Bitmap.createBitmap((int)(radius * 2), (int)(radius * 2), (Bitmap.Config)Bitmap.Config.ARGB_8888);
        Canvas c = new Canvas(dot);
        Paint p = new Paint();
        p.setAntiAlias(true);
        p.setStyle(Paint.Style.FILL);
        p.setColor(color);
        c.drawCircle((float)radius, (float)radius, (float)radius, p);
        return dot;
    }

    public static Bitmap drawItemNextIndicator(Context context) {
        return BitmapUtils.drawArrow(context, DimensionUtils.dip2Px(context, 20), -7829368, ArrowDirection.RIGHT);
    }

    public static Bitmap drawArrow(Context context, int sideLen, int color, ArrowDirection direct) {
        int lineWidth = DimensionUtils.dip2Px(context, 2);
        int offsetWidth = sideLen / 4;
        Point end1 = new Point(offsetWidth + lineWidth, lineWidth);
        Point end2 = new Point(offsetWidth + lineWidth, sideLen - lineWidth);
        Point header = new Point(offsetWidth + sideLen / 2, sideLen / 2);
        Path arrowPath = new Path();
        arrowPath.reset();
        arrowPath.moveTo((float)end1.x, (float)end1.y);
        arrowPath.lineTo((float)header.x, (float)header.y);
        arrowPath.lineTo((float)end2.x, (float)end2.y);
        Bitmap arrow = Bitmap.createBitmap((int)sideLen, (int)sideLen, (Bitmap.Config)Bitmap.Config.ARGB_8888);
        Canvas c = new Canvas(arrow);
        Paint p = new Paint();
        p.setAntiAlias(true);
        p.setStyle(Paint.Style.STROKE);
        p.setStrokeWidth((float)lineWidth);
        p.setColor(color);
        c.drawPath(arrowPath, p);
        Bitmap result = direct.getDegree() == 0 ? arrow : BitmapUtils.getRotatedBitmap(arrow, direct.getDegree());
        return result;
    }

    public static Bitmap drawCrossIcon(Context context, int sideLen, int color) {
        return BitmapUtils.drawCrossIcon(context, sideLen, -1, color);
    }

    public static Bitmap drawDeclineIcon(Context context, int sideLen, int color) {
        return BitmapUtils.drawDeclineIcon(context, sideLen, -1, color);
    }

    public static Bitmap drawDirectLeftTriangle(Context context, int size, int color, boolean solid) {
        return BitmapUtils.drawTriangle(context, size, color, solid, ArrowDirection.LEFT);
    }

    public static Bitmap drawTriangle(Context context, int size, int color, boolean solid, ArrowDirection direct) {
        float fSize = Float.parseFloat(size + "");
        PointF p1 = new PointF(0.0f, 0.0f);
        PointF p2 = new PointF(fSize / 2.0f, fSize / 2.0f);
        PointF p3 = new PointF(0.0f, fSize);
        Path arrowPath = new Path();
        arrowPath.reset();
        arrowPath.moveTo(p1.x, p1.y);
        arrowPath.lineTo(p2.x, p2.y);
        arrowPath.lineTo(p3.x, p3.y);
        Bitmap arrow = Bitmap.createBitmap((int)size, (int)size, (Bitmap.Config)Bitmap.Config.ARGB_8888);
        Canvas c = new Canvas(arrow);
        Paint p = new Paint();
        p.setAntiAlias(true);
        if (!solid) {
            int lineWidth = DimensionUtils.dip2Px(context, 2);
            p.setStyle(Paint.Style.STROKE);
            p.setStrokeWidth((float)lineWidth);
        } else {
            p.setStyle(Paint.Style.FILL);
        }
        p.setColor(color);
        c.drawPath(arrowPath, p);
        Bitmap result = direct.getDegree() == 0 ? arrow : BitmapUtils.getRotatedBitmap(arrow, direct.getDegree());
        return result;
    }

    public static Bitmap drawCrossIcon(Context context, int sideLen, int lineWidth, int color) {
        Point lp = new Point(0, sideLen / 2);
        Point rp = new Point(sideLen, sideLen / 2);
        Point tp = new Point(sideLen / 2, 0);
        Point bp = new Point(sideLen / 2, sideLen);
        Path path = new Path();
        path.moveTo((float)lp.x, (float)lp.y);
        path.lineTo((float)rp.x, (float)rp.y);
        path.moveTo((float)tp.x, (float)tp.y);
        path.lineTo((float)bp.x, (float)bp.y);
        Bitmap cross = Bitmap.createBitmap((int)sideLen, (int)sideLen, (Bitmap.Config)Bitmap.Config.ARGB_8888);
        Canvas c = new Canvas(cross);
        int lineWidthInDp = DimensionUtils.dip2Px(context, lineWidth == -1 ? 2 : lineWidth);
        Paint paint = BitmapUtils.createLinePaint(lineWidthInDp, color);
        c.drawPath(path, paint);
        return cross;
    }

    public static Bitmap drawDeclineIcon(Context context, int sideLen, int lineWidth, int color) {
        Point lp = new Point(0, sideLen / 2);
        Point rp = new Point(sideLen, sideLen / 2);
        Path path = new Path();
        path.moveTo((float)lp.x, (float)lp.y);
        path.lineTo((float)rp.x, (float)rp.y);
        Bitmap cross = Bitmap.createBitmap((int)sideLen, (int)sideLen, (Bitmap.Config)Bitmap.Config.ARGB_8888);
        Canvas c = new Canvas(cross);
        int lineWidthInDp = DimensionUtils.dip2Px(context, lineWidth == -1 ? 2 : lineWidth);
        Paint paint = BitmapUtils.createLinePaint(lineWidthInDp, color);
        c.drawPath(path, paint);
        return cross;
    }

    private static Paint createLinePaint(int lineWidth, int color) {
        Paint p = new Paint();
        p.setAntiAlias(true);
        p.setStyle(Paint.Style.STROKE);
        p.setStrokeWidth((float)lineWidth);
        p.setColor(color);
        p.setStrokeCap(Paint.Cap.ROUND);
        p.setStrokeJoin(Paint.Join.BEVEL);
        return p;
    }

    static {
        SUFFIXS.add("jpg");
        SUFFIXS.add("jpeg");
        SUFFIXS.add("png");
        SUFFIXS.add("bmp");
        SUFFIXS.add("gif");
    }

    public static enum ArrowDirection {
        LEFT(180),
        RIGHT(0),
        TOP(270),
        BOTTOM(90);

        int degree;

        private ArrowDirection(int degree) {
            this.degree = degree;
        }

        public int getDegree() {
            return this.degree;
        }
    }
}

