/*
 * Decompiled with CFR 0.152.
 */
package com.szboanda.android.platform.nfc.demo;

import android.app.Activity;
import android.content.Intent;
import android.os.Bundle;
import android.view.View;
import android.widget.Button;
import android.widget.EditText;
import android.widget.TextView;
import com.szboanda.android.platform.R;
import com.szboanda.android.platform.nfc.INfcListener;
import com.szboanda.android.platform.nfc.INfcOperation;
import com.szboanda.android.platform.nfc.NdefOperation;

public class NdefDemoActivity
extends Activity {
    private INfcOperation mNdefOpe;
    private TextView promt;
    private EditText writeTxt;
    private Button btnWrite;
    private Button btnRead;

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setContentView(R.layout.activity_nfc_demo);
        this.mNdefOpe = new NdefOperation(this);
        this.mNdefOpe.prepareForegroundDispatch();
        this.mNdefOpe.setNfcListener(new INfcListener(){

            @Override
            public void onRead(String content) {
                NdefDemoActivity.this.promt.setText((CharSequence)content);
            }
        });
        this.mNdefOpe.enableAutoRead(true);
        this.initViews();
        this.setViews();
    }

    protected void onResume() {
        super.onResume();
        this.mNdefOpe.enableForegroundDispatch();
    }

    protected void onPause() {
        super.onPause();
        this.mNdefOpe.disableForegroundDispatch();
    }

    protected void onNewIntent(Intent intent) {
        super.onNewIntent(intent);
        this.mNdefOpe.onNewIntent(intent);
    }

    protected void onActivityResult(int requestCode, int resultCode, Intent data) {
        super.onActivityResult(requestCode, resultCode, data);
        this.mNdefOpe.onPrepareForegroundDispatch(requestCode);
    }

    private void initViews() {
        this.promt = (TextView)this.findViewById(R.id.promt);
        this.writeTxt = (EditText)this.findViewById(R.id.editText);
        this.btnWrite = (Button)this.findViewById(R.id.write_btn);
        this.btnRead = (Button)this.findViewById(R.id.read_btn);
    }

    private void setViews() {
        this.btnWrite.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                NdefDemoActivity.this.mNdefOpe.write(NdefDemoActivity.this.writeTxt.getText().toString());
            }
        });
        this.btnRead.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                NdefDemoActivity.this.promt.setText((CharSequence)NdefDemoActivity.this.mNdefOpe.read());
            }
        });
    }
}

