/*
 * Decompiled with CFR 0.152.
 */
package com.szboanda.android.platform.http;

import android.app.Dialog;
import com.szboanda.android.platform.dialog.PercentNotification;
import com.szboanda.android.platform.http.ResponseProcessor;
import com.szboanda.android.platform.http.impl.IProgressChangeView;
import org.xutils.common.Callback;

public abstract class UploadResponseProcessor<T>
extends ResponseProcessor<T>
implements Callback.ProgressCallback<String> {
    private IProgressChangeView mChangeView;
    private boolean isBackgroundUpload = false;
    private PercentNotification mNotice = null;
    private String mTitle;

    public void setTitle(String title) {
        this.mTitle = title;
    }

    public void setBackgroundUpload(boolean backgroundUpload) {
        this.isBackgroundUpload = backgroundUpload;
    }

    @Override
    public void onSuccess(String responseInfo) {
        super.onSuccess(responseInfo);
        if (this.mChangeView != null) {
            this.mChangeView.onFinish();
        }
    }

    public void onLoading(long total, long current, boolean isUploading) {
        if (this.isBackgroundUpload) {
            this.noticeUpload(total, current, isUploading);
            if (this.mChangeView != null && this.mChangeView instanceof Dialog) {
                if (((Dialog)this.mChangeView).isShowing()) {
                    ((Dialog)this.mChangeView).dismiss();
                }
                return;
            }
        }
        int ratio = (int)(Double.valueOf(current + "") / Double.valueOf(total + "") * 100.0);
        if (this.mChangeView != null) {
            this.mChangeView.onProgressChanged(total, current, ratio);
        }
    }

    private void noticeUpload(long total, long current, boolean isUploading) {
        if (this.mNotice == null) {
            this.mNotice = new PercentNotification(this.getContext()).title(this.mTitle).total(total).current(current);
        }
        this.mNotice.current(current);
        this.mNotice.notice();
    }

    public void onWaiting() {
    }

    public void onStarted() {
    }

    public IProgressChangeView getChangeView() {
        return this.mChangeView;
    }

    public void setChangeView(IProgressChangeView changeView) {
        this.mChangeView = changeView;
    }
}

