/*
 * Decompiled with CFR 0.152.
 */
package com.szboanda.android.platform.activity;

import android.app.ActionBar;
import android.app.Activity;
import android.content.Context;
import android.net.Uri;
import android.os.Bundle;
import android.view.MenuItem;
import android.view.View;
import android.widget.Adapter;
import android.widget.RelativeLayout;
import android.widget.Toast;
import com.artifex.mupdfdemo.MuPDFCore;
import com.artifex.mupdfdemo.MuPDFPageAdapter;
import com.artifex.mupdfdemo.MuPDFReaderView;
import com.artifex.mupdfdemo.OutlineActivityData;
import com.szboanda.android.platform.R;
import com.szboanda.android.platform.dialog.MessageDialog;
import java.util.Locale;

public class PdfViewActivity
extends Activity {
    public static final String ACTION_VIEW_PDF = "szboanda.action.view.pdf";
    private MuPDFCore core;
    private String mFileName;
    private MuPDFReaderView mDocView;
    private Toast pageNumberToast;

    protected void onCreate(Bundle savedInstanceState) {
        Uri uri;
        super.onCreate(savedInstanceState);
        ActionBar actionBar = this.getActionBar();
        if (actionBar != null) {
            actionBar.setDisplayHomeAsUpEnabled(true);
            actionBar.setHomeButtonEnabled(true);
            actionBar.setIcon(R.drawable.ic_back_home_white);
        }
        if ((uri = this.getIntent().getData()) == null) {
            new MessageDialog((Context)this, "\u6587\u4ef6\u6253\u5f00\u5931\u8d25\uff01").show();
            return;
        }
        this.core = this.openFile(Uri.decode((String)uri.getEncodedPath()));
        if (this.core == null) {
            new MessageDialog((Context)this, "\u6587\u4ef6\u6253\u5f00\u5931\u8d25\uff01").show();
            return;
        }
        this.createUI(savedInstanceState);
    }

    public void createUI(Bundle savedInstanceState) {
        this.mDocView = new MuPDFReaderView(this){

            protected void onMoveToChild(int i) {
                if (PdfViewActivity.this.core == null) {
                    return;
                }
                String pageText = String.format(Locale.getDefault(), "%d / %d", i + 1, PdfViewActivity.this.core.countPages());
                if (PdfViewActivity.this.pageNumberToast != null) {
                    PdfViewActivity.this.pageNumberToast.setText((CharSequence)pageText);
                } else {
                    PdfViewActivity.this.pageNumberToast = Toast.makeText((Context)PdfViewActivity.this, (CharSequence)pageText, (int)0);
                }
                PdfViewActivity.this.pageNumberToast.setGravity(53, 0, 0);
                PdfViewActivity.this.pageNumberToast.show();
                super.onMoveToChild(i);
            }
        };
        this.mDocView.setAdapter((Adapter)new MuPDFPageAdapter((Context)this, this.core));
        this.mDocView.setDisplayedViewIndex(0);
        RelativeLayout layout = new RelativeLayout((Context)this);
        layout.addView((View)this.mDocView);
        this.setContentView((View)layout);
        this.getActionBar().setTitle((CharSequence)this.mFileName);
    }

    private MuPDFCore openFile(String path) {
        int lastSlashPos = path.lastIndexOf(47);
        this.mFileName = new String(lastSlashPos == -1 ? path : path.substring(lastSlashPos + 1));
        System.out.println("Trying to open " + path);
        try {
            this.core = new MuPDFCore((Context)this, path);
            OutlineActivityData.set(null);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
        return this.core;
    }

    public void onDestroy() {
        if (this.core != null) {
            this.core.onDestroy();
        }
        this.core = null;
        super.onDestroy();
    }

    public boolean onOptionsItemSelected(MenuItem item) {
        if (item.getItemId() == 16908332) {
            this.finish();
            return true;
        }
        return super.onOptionsItemSelected(item);
    }
}

