/*
 * Decompiled with CFR 0.152.
 */
package com.szboanda.android.platform;

import com.szboanda.android.platform.view.IPinnedHeaderListItem;
import com.szboanda.android.platform.view.ISortableEntity;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public abstract class Sorter<T> {
    Map<String, List<T>> sortedMap = new LinkedHashMap<String, List<T>>();
    List<T> mDatas = new ArrayList<T>();

    public Map<String, List<T>> getSortedMapData() {
        return this.sortedMap;
    }

    public List<T> getSortedData() {
        return this.mDatas;
    }

    public void sortAutoIncrement(List<T> datas) {
        for (T item : datas) {
            String typeName = ((ISortableEntity)item).getTypeName();
            if (!this.sortedMap.containsKey(typeName)) {
                ArrayList items = new ArrayList();
                this.sortedMap.put(typeName, items);
            }
            this.sortedMap.get(typeName).add(item);
        }
        for (String key : this.sortedMap.keySet()) {
            List<T> items = this.sortedMap.get(key);
            if (!(items.get(0) instanceof Comparable)) continue;
            Collections.sort(items);
        }
        this.generateListViewData();
    }

    private void generateListViewData() {
        this.mDatas.clear();
        if (this.sortedMap != null && this.sortedMap.size() > 0) {
            for (String key : this.sortedMap.keySet()) {
                List<T> items = this.sortedMap.get(key);
                this.addGroup(items);
            }
        }
    }

    private void addGroup(List<T> groupItems) {
        Object virtualItem = null;
        T groupFirstItem = groupItems.get(0);
        if (this.mDatas.isEmpty()) {
            virtualItem = this.createVirtualItem(groupFirstItem);
        } else {
            T lastItem = this.mDatas.get(this.mDatas.size() - 1);
            if (lastItem instanceof ISortableEntity && !((ISortableEntity)lastItem).getTypeName().equals(((ISortableEntity)groupFirstItem).getTypeName())) {
                virtualItem = this.createVirtualItem(groupFirstItem);
            }
        }
        if (virtualItem != null && virtualItem instanceof IPinnedHeaderListItem) {
            ((IPinnedHeaderListItem)virtualItem).setGroupItem(true);
            this.mDatas.add(virtualItem);
        }
        this.mDatas.addAll(groupItems);
    }

    public void clear() {
        this.sortedMap.clear();
        this.mDatas.clear();
    }

    public abstract T createVirtualItem(T var1);
}

