/*
 * source code copy from 
 * https://github.com/ShawnLin013/NumberPicker 
 */
package com.szboanda.android.platform.widget;

import java.lang.reflect.Field;
import java.util.Locale;

import android.content.Context;
import android.content.res.Resources;
import android.graphics.Paint;
import android.graphics.Typeface;
import android.graphics.drawable.ColorDrawable;
import android.support.annotation.ColorInt;
import android.text.TextUtils;
import android.view.VelocityTracker;
import android.view.View;
import android.view.ViewConfiguration;
import android.widget.EditText;

/**
 * This provide a simple and customizable NumberPicker.
 */
public class NumberPickerReflect extends android.widget.NumberPicker {

	private int mTouchSlop;
	
	private int mMinimumFlingVelocity;
	
	private int mMaximumFlingVelocity;
	
	private int mDividerColor;
	
    private String mFormatter;

    private boolean mFocusable = false;

    private int mMax = 100;

    private int mMin = 1;

    private int mTextColor = 0xFF000000;

    //pixel
    private float mTextSize;

    private Typeface mTypeface;
    
    public NumberPickerReflect(Context context){
    	super(context);
    	 // initialize constants
    }
    
    /**
     * 
     * @param slop ViewConfiguration.getScaledTouchSlop();
     */
    public void setTouchSlop(int slop){
    	mTouchSlop = slop;
    	Field[] fields = android.widget.NumberPicker.class.getDeclaredFields();
        for (Field field : fields) {
            if (field.getName().equals("mTouchSlop")) {
                field.setAccessible(true);
                try {
                    field.set(this, slop);
                } catch (IllegalAccessException e) {
                    e.printStackTrace();
                } catch (IllegalArgumentException e) {
                    e.printStackTrace();
                } catch (Resources.NotFoundException e) {
                    e.printStackTrace();
                }
                break;
            }
        }
    }
    
    /**
     * 
     * @param fling ViewConfiguration.getScaledMinimumFlingVelocity();
     */
    public void setMaximumFlingVelocity(int fling){
    	mMaximumFlingVelocity = fling;
    	Field[] fields = android.widget.NumberPicker.class.getDeclaredFields();
        for (Field field : fields) {
            if (field.getName().equals("mMaximumFlingVelocity")) {
                field.setAccessible(true);
                try {
                    field.set(this, fling);
                } catch (IllegalAccessException e) {
                    e.printStackTrace();
                } catch (IllegalArgumentException e) {
                    e.printStackTrace();
                } catch (Resources.NotFoundException e) {
                    e.printStackTrace();
                }
                break;
            }
        }
    }

    /**
     * 
     * @param fling ViewConfiguration.getScaledMinimumFlingVelocity();
     */
    public void setMinimumFlingVelocity(int fling){
    	mMinimumFlingVelocity = fling;
    	Field[] fields = android.widget.NumberPicker.class.getDeclaredFields();
        for (Field field : fields) {
            if (field.getName().equals("mMinimumFlingVelocity")) {
                field.setAccessible(true);
                try {
                    field.set(this, fling);
                } catch (IllegalAccessException e) {
                    e.printStackTrace();
                } catch (IllegalArgumentException e) {
                    e.printStackTrace();
                } catch (Resources.NotFoundException e) {
                    e.printStackTrace();
                }
                break;
            }
        }
    }
    
    public void setDividerColor(@ColorInt int color) {
        if (color == 0) {
            return;
        }
        mDividerColor = color;
        Field[] fields = android.widget.NumberPicker.class.getDeclaredFields();
        for (Field field : fields) {
            if (field.getName().equals("mSelectionDivider")) {
                field.setAccessible(true);
                try {
                    field.set(this, new ColorDrawable(color));
                } catch (IllegalAccessException e) {
                    e.printStackTrace();
                } catch (IllegalArgumentException e) {
                    e.printStackTrace();
                } catch (Resources.NotFoundException e) {
                    e.printStackTrace();
                }
                break;
            }
        }
    }
    
    public void setDividerDistance(int distance) {
        Field[] fields = android.widget.NumberPicker.class.getDeclaredFields();
        for (Field field : fields) {
            if (field.getName().equals("mSelectionDividersDistance")) {
                field.setAccessible(true);
                try {
                    field.set(this, distance);
                } catch (IllegalAccessException e) {
                    e.printStackTrace();
                } catch (IllegalArgumentException e) {
                    e.printStackTrace();
                } catch (Resources.NotFoundException e) {
                    e.printStackTrace();
                }
                break;
            }
        }
    }

    public void setMaxHeight(int height) {
        Field[] fields = android.widget.NumberPicker.class.getDeclaredFields();
        for (Field field : fields) {
            if (field.getName().equals("mMaxHeight")) {
                field.setAccessible(true);
                try {
                    field.set(this, height);
                } catch (IllegalAccessException e) {
                    e.printStackTrace();
                } catch (IllegalArgumentException e) {
                    e.printStackTrace();
                } catch (Resources.NotFoundException e) {
                    e.printStackTrace();
                }
                break;
            }
        }
    }
    
    public void setFormatter(String formatter) {
        if (TextUtils.isEmpty(formatter)) {
            return;
        }

        mFormatter = formatter;
        setFormatter(new Formatter() {
            @Override public String format(int i) {
                return String.format(Locale.getDefault(), mFormatter, i);
            }
        });
    }

    public void setFocusable(boolean focusable) {
        mFocusable = focusable;
        setTextAttributes();
    }

    public void setTextColor(@ColorInt int color) {
        mTextColor = color;
        setTextAttributes();
    }

    public void setTextSize(float textSize) {
        mTextSize = textSize;
        setTextAttributes();
    }

    public void setTypeface(Typeface typeface) {
        mTypeface = typeface;
        setTextAttributes();
    }

    private void setTextAttributes() {
    	if(mTextSize == 0){
    		mTextSize = spToPx(16f);//设置默认值
    	}
        for (int i = 0; i < getChildCount(); i++) {
            View child = getChildAt(i);
            if (child instanceof EditText) {
                try {
                    Field selectorWheelPaintField = android.widget.NumberPicker.class.getDeclaredField("mSelectorWheelPaint");
                    selectorWheelPaintField.setAccessible(true);

                    Paint wheelPaint = ((Paint) selectorWheelPaintField.get(this));
                    wheelPaint.setColor(mTextColor);
                    wheelPaint.setTextSize(mTextSize);
                    wheelPaint.setTypeface(mTypeface != null ? mTypeface : Typeface.MONOSPACE);

                    EditText editText = ((EditText) child);
                    editText.setTextColor(mTextColor);
                    editText.setFocusable(mFocusable);
                    editText.setTextSize(pxToSp(mTextSize));
                    editText.setTypeface(mTypeface != null ? mTypeface : Typeface.MONOSPACE);
                    invalidate();
                    break;
                } catch (NoSuchFieldException e) {
                    e.printStackTrace();
                } catch (IllegalAccessException e) {
                    e.printStackTrace();
                } catch (IllegalArgumentException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    private float pxToSp(float px) {
        float fontScale = getContext().getResources().getDisplayMetrics().scaledDensity;
        return (int) (px / fontScale + 0.5f * (px >= 0 ? 1 : -1));
    }
    
    private float spToPx(float sp){
    	float fontScale = getContext().getResources().getDisplayMetrics().scaledDensity;  
        return (int) (sp * fontScale + 0.5f); 
    }

}