package com.szboanda.android.platform.view;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;

import android.content.Context;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.BaseAdapter;

/**
 * <p>Description: AbsListView的通用适配器</p>
 * @Company    深圳市博安达软件开发有限公司
 * @author    Siyi Lu    Create Date: 2014-12-11
 * @modify  
 * @param <T>
 */
public abstract class UniversalAdapter<T> extends BaseAdapter implements IChangeDataSet<T>{
	protected Context mContext;
	/**用于适配的数据*/
	protected List<T> mData = new ArrayList<T>();
	
	public LayoutInflater mLayoutInflater;
	/**列表的item填充布局的ID*/
	protected int mItemLayoutId;
	
	public UniversalAdapter(Context context){
		mContext = context;
		mLayoutInflater = LayoutInflater.from(mContext);
	}
	
	public UniversalAdapter(Context context, List<T> data, int itemLayoutId){
		mContext = context;
		mItemLayoutId = itemLayoutId;
		mLayoutInflater = LayoutInflater.from(mContext);
		setData(data);
	}
	
	public Context getContext(){
		return mContext;
	}
	
	@Override
	public void setData(List<T> data){
		if(data != null){
			mData.clear();
			mData.addAll(data);
		}
	}
	
	@Override
	public void addData(List<T> data){
		if(data != null){
			mData.addAll(data);
		}
	}
	
	public List<T> getData(){
		List<T> result = new ArrayList<T>();
		result.addAll(mData);
		return result;
	}
	
	/**清除数据*/
	public void clearData(){
		mData.clear();
	}
	
	public void setItemLayoutId(int itemLayoutId){
		mItemLayoutId = itemLayoutId;
	}
	
	@Override
	public int getCount() {
		return mData.size();
	}

	@Override
	public T getItem(int position) {
		return mData.get(position);
	}

	@Override
	public long getItemId(int position) {
		return position;
	}

	@Override
	public View getView(int position, View convertView, ViewGroup parent) {
		ViewHolder holder = ViewHolder.get(mLayoutInflater, convertView, mItemLayoutId, position);
		bindViewsData(position, holder.getConvertView(), getItem(position));
		return holder.getConvertView();
	}
	
	/**Item的布局绑定数据的抽象方法*/
	public abstract void bindViewsData(int position, View convertView, T itemData);
	/** 获取指定位置Map类型数据，主要用于页面跳转传参 */
	public Map<String, Object> getMapData(int position){
		return null;
	}; 
	
	static class ViewHolder{
		private View mConvertView;
		
		private ViewHolder(LayoutInflater inflater, int layoutId, int position){
			mConvertView = inflater.inflate(layoutId, null);
			mConvertView.setTag(this);
		}
		
		public static ViewHolder get(LayoutInflater inflater, View convertView, int layoutId, int position) {
			if (convertView == null) {
				return new ViewHolder(inflater, layoutId, position);
			}
			return (ViewHolder) convertView.getTag();
		}
		
		public View getConvertView(){
			return mConvertView;
		}
		
	}

}
