package com.szboanda.android.platform.view;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.Bitmap.Config;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.Paint;
import android.graphics.Paint.FontMetrics;
import android.graphics.Paint.Style;
import android.graphics.Typeface;
import android.util.TypedValue;

import com.szboanda.android.platform.util.DimensionUtils;

/**
 * <p>Description: 单个字符位置绘制工具</p>
 * @Company    深圳市博安达信息技术股份有限公司
 * @author    Siyi Lu    Create Date: 2015-10-8
 * @modify  
 */
public class SingleCharStampDrawer {
	
	private float circleStrokeWidth = 2f;
	
	private float textStrokeWidth = 1f;
	
	private boolean isBgFill = false;
	
	private Paint mPaint;
	
	private float padding = -1;
	
	private boolean drawCircle = true;
	
	private int mStampColor = 0xFFFF0000;
	
	private Context mContext;
	
	private String mText;
	
	public SingleCharStampDrawer(Context context){
		mContext = context;
		initDrawPaint();
	}
	
	private void initDrawPaint(){
		mPaint = new Paint();
		float textSize = TypedValue.applyDimension(TypedValue.COMPLEX_UNIT_SP, 18
				,mContext.getResources().getDisplayMetrics());
		mPaint.setTextSize(textSize);
		mPaint.setColor(mStampColor);
		mPaint.setAntiAlias(true);
	}
	
	public SingleCharStampDrawer setText(String text){
		mText = text;
        return this;
	}
	
	public SingleCharStampDrawer setTextSize(float textSize){
		mPaint.setTextSize(textSize);
        return this;
	}
	
	public SingleCharStampDrawer setStampColor(int stampColor){
		mStampColor = stampColor;
        return this;
	}
	
	public SingleCharStampDrawer setPadding(int padding){
		this.padding = padding;
        return this;
	}

	public SingleCharStampDrawer setBackgroudFill(boolean fill){
        isBgFill = fill;
        return this;
    }
	
	float mTextWidth = -1;
	float mWidth = -1;
	float mHeight = -1;
	private void measureDimesion(){
		mTextWidth = mPaint.measureText(mText);
		if(padding == -1){
			padding = mTextWidth*2/3;
		}
		mWidth = mTextWidth + padding * 2;
		mHeight = drawCircle ? mWidth : mWidth + DimensionUtils.dip2Px(mContext, 5);
	}
	
	public Bitmap drawStamp(){
		measureDimesion();
		float x = mWidth / 2;
		float y = mHeight/ 2;
		mPaint.setColor(mStampColor);
		mPaint.setStyle(isBgFill ? Style.FILL : Style.STROKE);
		mPaint.setStrokeWidth(circleStrokeWidth);
		float radius = mWidth/3;
		Bitmap b = Bitmap.createBitmap((int)mWidth, (int)mHeight, Config.ARGB_8888);
		Canvas canvas = new Canvas(b);
		canvas.drawCircle(x, y, radius, mPaint);
		canvas.save();
		canvas.restore();
		
		//文字宽度
		mPaint.setStrokeWidth(textStrokeWidth);
		mPaint.setStyle(Style.FILL);
		mPaint.setTypeface(Typeface.DEFAULT);
		if(isBgFill){
			mPaint.setColor(Color.WHITE);
		}
		FontMetrics metrics = mPaint.getFontMetrics();
		float th = Math.abs(metrics.ascent) + metrics.descent;
		float txs = x - mTextWidth/2;
		float tys = (mWidth - th)/2 + Math.abs(metrics.ascent); 
		//绘制文字时的坐标起点指文字的左下角的坐标
		canvas.drawText(mText, txs, tys, mPaint);
		canvas.save();
		return b;
	}

}
