package com.szboanda.android.platform.view;

import android.content.Context;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.view.View;

import com.szboanda.android.platform.R;
import com.szboanda.android.platform.util.JsonUtils;
import com.szboanda.android.platform.util.ResourceUtils;
import com.szboanda.android.platform.view.CustomViewBinder.IKeyConvertable;
import com.szboanda.android.platform.view.CustomViewBinder.IKeyConvertor;

import org.json.JSONObject;

public class BindableViewHandler implements IKeyConvertable{
	
	private String field;
	
	private String notEmptyMsg;
	
	private String multiValueSeparator;
	
	private IBindableView mHostView;
	
	private JSONObject mData;
	
	private IKeyConvertor mKeyConvertor;
	
	public BindableViewHandler(IBindableView hostView){
		mHostView = hostView;
	}

	public void initWithTypedArray(TypedArray ta){
		String viewName = mHostView.getClass().getName();
		int index = viewName.lastIndexOf(".");
		viewName = viewName.substring(index + 1);
		String fieldDefineName = viewName + "_dbField";
		String msgDefineName = viewName + "_notEmptyMsg";
		String splitDefineName = viewName + "_multiValueSeparator";
		Context context = ((View)mHostView).getContext();
		field = ta.getString(ResourceUtils.getStyleableInt(context, fieldDefineName));
		int msgIndex = ResourceUtils.getStyleableInt(context, msgDefineName);
		if(msgIndex != -1){
			notEmptyMsg = ta.getString(msgIndex);
		}
		int splitIndex = ResourceUtils.getStyleableInt(context, splitDefineName);
		if(splitIndex != -1){
			multiValueSeparator = ta.getString(splitIndex);
		}
		field = initDefaultString(field);
		notEmptyMsg = initDefaultString(notEmptyMsg);
	}

	public void initWithTypedArray(Resources res, AttributeSet attrs){
		TypedArray ta = res.obtainAttributes(attrs, R.styleable.boanda);
		field = ta.getString(R.styleable.boanda_dbField);
		notEmptyMsg = ta.getString(R.styleable.boanda_notEmptyMsg);
		multiValueSeparator = ta.getString(R.styleable.boanda_multiValueSeparator);
		ta.recycle();
		field = initDefaultString(field);
		notEmptyMsg = initDefaultString(notEmptyMsg);
	}
	
	public String initDefaultString(String value){
		return initDefaultString(value, "");
	}
	
	public String initDefaultString(String value, String emptyValue){
		String result = TextUtils.isEmpty(value) ? emptyValue : value;
		return result;
	}

	public String getField() {
		return mKeyConvertor == null ? field : acceptConvert(mKeyConvertor);
	}

	public void setField(String field) {
		this.field = field;
	}
	
	public void setKeyConvert(IKeyConvertor convertor){
		mKeyConvertor = convertor;
	}

	public void setNotEmptyMsg(String notEmptyMsg) {
		this.notEmptyMsg = notEmptyMsg;
	}

	public String getEmptyMsg() {
		return notEmptyMsg;
	}
	
	public String getMultiValueSeparator() {
		return multiValueSeparator;
	}

	public void setMultiValueSeparator(String multiValueSeparator) {
		this.multiValueSeparator = multiValueSeparator;
	}
	
	public IKeyConvertor getKeyConvertor(){
		return mKeyConvertor;
	}

	/**
	 * 从数据源中取出指定的值(根据数据库字段名称)，对控件进行赋值绑定
	 * @param data 数据源
	 * @param enable 数据绑定后是否可以编辑
	 */
	public void bindValue(JSONObject data, boolean enable){
		mData = data;
		if(data.has(getField())){
			String value = data.optString(getField());
			mHostView.setBindValue(value);
		}
		((View)mHostView).setEnabled(enable);
	}
	
	/**
	 * 对当前控件进行取值，并追加到指定的数据源对象中
	 * @param data 待追加的数据源对象
	 * @return 如果值为空，返回为空提示信息
	 */
	public String appendValue(JSONObject data){
		String value = mHostView.getBindValue().trim();
		if(!TextUtils.isEmpty(value)){
			if(isMultiValue()){
				if(isComplexField()){
					String[] fields = getField().split(multiValueSeparator);
					String[] values = value.split(multiValueSeparator);
					int index = 0;
					for(String f:fields){
						String v = index < values.length ? values[index] : "";
						JsonUtils.put(data, f, v);
						index++;
					}
				}else{
					String existValue = data.optString(getField(), "");
					existValue += multiValueSeparator + value;
					if(existValue.startsWith(multiValueSeparator)){
						existValue = existValue.substring(1);
					}
					JsonUtils.put(data, getField(), existValue);
				}
			}else{
				JsonUtils.put(data, getField(), value);
			}
		}
		return !TextUtils.isEmpty(notEmptyMsg) && TextUtils.isEmpty(value) ? notEmptyMsg : "";
	}
	
	public String optFieldValue(String field){
		if(mData == null){
			return "";
		}else{
			return mData.optString(field);
		}
	}
	
	/**
	 * 是否有多个值
	 * @return
	 */
	public boolean isMultiValue(){
		return !TextUtils.isEmpty(multiValueSeparator);
	}
	
	/**
	 * 是否复合型的字段
	 * @return
	 */
	public boolean isComplexField(){
		return !TextUtils.isEmpty(multiValueSeparator) 
				&& getField().contains(multiValueSeparator);
	}

	@Override
	public String acceptConvert(IKeyConvertor convertor) {
		return convertor.convertKey(this);
	}
	
}
