package com.szboanda.android.platform.view;

import android.content.Context;
import android.content.res.TypedArray;
import android.text.Html;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.widget.TextView;

import com.szboanda.android.platform.R;

public class BindableTextView extends TextView implements IBindableView{
	
	private BindableViewHandler mBindHandler;

	public BindableTextView(Context context, AttributeSet attrs) {
		super(context, attrs);
		mBindHandler = new BindableViewHandler(this);
		mBindHandler.initWithTypedArray(getResources(), attrs);
	}

	public BindableTextView(Context context) {
		super(context);
		mBindHandler = new BindableViewHandler(this);
	}
	
	public void setField(String fieldName){
		mBindHandler.setField(fieldName);
	}
	
	@Override
	public void setEmptyMsg(String notEmptyTipMsg) {
		mBindHandler.setNotEmptyMsg(notEmptyTipMsg);
	}

	@Override
	public void setBindValue(String value) {
		CharSequence v;
		if(!TextUtils.isEmpty(value)){
			if(value.replace("\\t", "").replace("\n", "").matches(".*<.+>.*</[a-zA-Z0-9]+>.*")){
				//如果出现成对的html标签，则转换格式
				v = Html.fromHtml(value);
			}else if(value.matches("^[1-9]{1}[0-9]{3}-[0-9]{1,2}-[0-9]{1,2}\\s00:00$")){
				v = value.split(" ")[0];
			}else{
				v = value;
			}
		}else{
			v = "";
		}
		setText(v);
	}

	@Override
	public String getBindValue() {
		return getText().toString();
	}

	@Override
	public BindableViewHandler getBindHandler() {
		return mBindHandler;
	}
	

}
