package com.szboanda.android.platform.util.tree;

import java.util.ArrayList;
import java.util.List;

public class TreeNodeKeeper {
	
	private ITreeNode mParent;
	
	private List<ITreeNode> mChilds = null;
	
	private TreeNodeKeeper(){}
	
	public static TreeNodeKeeper getInstance(){
		return new TreeNodeKeeper();
	}
	
	public void addNodeChild(ITreeNode parent, ITreeNode child){
		if(mChilds == null){
			mChilds = new ArrayList<ITreeNode>();
		}
		mChilds.add(child);
		child.setParent(parent);
	}
	
	public  List<ITreeNode> getNodeChilds(){
		return mChilds;
	}
	
	public void removeNodeChilds(ITreeNode child){
		if(mChilds != null){
			mChilds.remove(child);
		}
	}
	
	public void setNodeParent(ITreeNode parent) {
		mParent = parent;
	}
	
	public ITreeNode getNodeParent(){
		return mParent;
	}

}
