package com.szboanda.android.platform.util.tree;

import com.szboanda.android.platform.db.SQLiteDao;

import java.util.ArrayList;
import java.util.List;

public abstract class TreeNodeAdapter {
	
	protected boolean autoRecursive;

    protected List<ITreeNode> convert(List<?> codes){
        List<ITreeNode> result = new ArrayList<ITreeNode>();
        if (codes != null ) {
            for (Object code : codes) {
                ITreeNode node = (ITreeNode) code;
                result.add(node);
            }
        }
        return result;
    }
	
	
	public boolean isAutoRecursive() {
		return autoRecursive;
	}

	public void setAutoRecursive(boolean autoRecursive) {
		this.autoRecursive = autoRecursive;
	}

	/**
	 * 获取要节点
	 * @param dao
     * @param idValue
	 * @return
	 */
	public abstract ITreeNode getRootNode(SQLiteDao dao, Object idValue);
	
	/**
	 * 获取节点的子节点
	 * @param dao
	 * @param parentNode
	 * @return
	 */
	public abstract List<ITreeNode> getChildNodes(SQLiteDao dao, ITreeNode parentNode);
	
}
