package com.szboanda.android.platform.util;

import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

import android.text.TextUtils;

public class StringUtils {
	
	/**
	 * 使用指定符号连接List集合中的字符串
	 * @param items
	 * @param joinSign
	 * @return
	 */
	public static <E> String joinStringItem(List<E> items, String joinSign){
		String joinedItems = "";
		if(items != null){
			for(E p:items){
				joinedItems += joinSign + p;
			}
			if(joinedItems.startsWith(joinSign)){
				joinedItems = joinedItems.substring(1);
			}
		}
		return joinedItems;
	}
	/**
     * 根据文件路径解析文件名
     * @param filePath
     * @return
     */
    public static String parseFileName(String filePath){
        String fileName = filePath;
        if (!TextUtils.isEmpty(filePath)) {
            filePath = filePath.replaceAll("\\\\", "/");
            String[] parts = filePath.split("/");
            if(parts!=null && parts.length > 0){
                fileName = parts[parts.length-1];
            }
        }
        return fileName;
    }
    /**
	 * 过滤HTML标签的方法
	 * */
	public static String delHTMLTag(String htmlStr) {
	       if(htmlStr==null||"null".equals(htmlStr)){return "";}
	    	String regEx_script = "<script[^>]*?>[\\s\\S]*?<\\/script>"; // 定义script的正则表达式
	        String regEx_style = "<style[^>]*?>[\\s\\S]*?<\\/style>"; // 定义style的正则表达式
	        String regEx_html = "<[^>]+>"; // 定义HTML标签的正则表达式
	    	Pattern p_script = Pattern.compile(regEx_script, Pattern.CASE_INSENSITIVE); 
			Matcher m_script = p_script.matcher(htmlStr); 
			htmlStr = m_script.replaceAll(""); // 过滤script标签 
			Pattern p_style = Pattern.compile(regEx_style, Pattern.CASE_INSENSITIVE);
			Matcher m_style = p_style.matcher(htmlStr);
			htmlStr = m_style.replaceAll(""); // 过滤style标签 
			Pattern p_html = Pattern.compile(regEx_html, Pattern.CASE_INSENSITIVE); 
			Matcher m_html = p_html.matcher(htmlStr); 
			htmlStr = m_html.replaceAll(""); // 过滤html标签
			return htmlStr.trim(); // 返回文本字符串
	}
	
	public static <E> List<String> distillItemsTitle(List<E> items, DistillStrategy<E> distillStrategy){
		List<String> result = null;
		if(items != null && items.size()>0){
			result = new ArrayList<String>();
			for(E entity:items){
				result.add(distillStrategy.getTitle(entity));
			}
		}
		return result;
	}
	
	public static String processNull(String oldStr){
		if(TextUtils.isEmpty(oldStr)||"null".equals(oldStr)||"NULL".equals(oldStr)){
			oldStr = "";
		}
		return oldStr;
	}
}
