package com.szboanda.android.platform.util;

/**
 *
 * 常用正则表达式
 *
 * Created by zhanggenhua on 16/4/26.
 */
public interface Regex {

    /**
     * 整数
     */
    String INTEGER = "^-?[0-9]+$";

    /**
     * 正负浮点数
     */
    String FLOAT = "^-?[0-9]+\\.[0-9]+$";

    /**
     * 邮件
     */
    String EMAIL = "[\\w!#$%&amp;'*+/=?^_`{|}~-]+(?:\\.[\\w!#$%&amp;'*+/=?^_`{|}~-]+)*@(?:[\\w](?:[\\w-]*[\\w])?\\.)+[\\w](?:[\\w-]*[\\w])?";

    /**
     * 一个或多个汉字
     * 不含标点符号或其他符号
     */
    String CHINESE_CHARACTER = "[\u4e00-\u9fa5]";

}
