package com.szboanda.android.platform.util;

import java.security.MessageDigest;

/**
 * Title: 消息摘要帮助类 
 * fileName: MessageDigestHelper.java
 * Description: 默认使用SHA-1算法 BouncyCastleProvider的算法实现
 * @Copyright: PowerData Software Co.,Ltd. Rights Reserved.
 * @Company:深圳市博安达软件开发有限公司 
 * @author: 康庆
 * @version:1.0 
 * create date:2009-4-25 
 *
 */
public class MessageDigestHelper{
        /**使用的默认摘要算法*/
       private String algorithm = "SHA-1"; 
       /**摘要对象*/
       private MessageDigest messageDigest = null;
        
       public MessageDigestHelper() {     
           init();
       }
       /** 
        * 初始化消息摘要对象  
        * @author: 康庆
        * @version:1.0
        * create date:2009-4-25
        */
       private void init(){
           try{
               this.messageDigest = MessageDigest.getInstance(algorithm); 
           }catch(Exception e){
               throw new RuntimeException(e);
           }
       }
       /**
        * 使用指定的算法初始化消息摘要对象
        * @param algorithm
        */
       public MessageDigestHelper(String algorithm){ 
           this.algorithm = algorithm;
           this.init();
       }

       
    
       /**
        * 以字节数组的方式获得消息的摘要
        * @param message
        * @return
        * @author: 康庆
        * @version:1.0
        * create date:2009-4-25
        */
       public byte[] getBytesDigest(String message){
           if(message == null){
               throw new IllegalArgumentException("无法对空文本提取消息摘要"); 
           }
           messageDigest.update(message.getBytes()); 
           return messageDigest.digest();
       }
       
       /**
        * 获得字节数组的字节形式的摘要信息
        * @param message
        * @return
        * @author: 康庆
        * @version:1.0
        * create date:2009-4-25
        */
       public byte[] getBytesDigest(byte[] message){ 
           if(message == null){  
               throw new IllegalArgumentException("无法对空文本提取消息摘要"); 
           }
           messageDigest.update(message); 
           return messageDigest.digest();
       }    
       /**
        * 以十六进制字符串的形式获得消息摘要
        * @param message
        * @return
        * @author: 康庆
        * @version:1.0
        * create date:2009-4-25
        */
       public String getHexStringDigest(String message){
           return SecurityHelper.toHex(getBytesDigest(message));   
       }
       
       /** 
        * 以十六进制字符串的形式获得消息摘要
        * @param message
        * @return
        * @author: 康庆
        * @version:1.0 
        * create date:2009-4-25
        */
       public String getHexStringDigest(byte[] message){
           return SecurityHelper.toHex(getBytesDigest(message));      
       }
        
      
    
       public static void main(String[] args) throws Exception{    
           MessageDigestHelper helper = new MessageDigestHelper();     
           System.out.println(helper.getHexStringDigest("weblogic"));     
       }
       
}
