package com.szboanda.android.platform.http.impl;

import java.net.HttpURLConnection;
import java.net.URL;

import android.content.Context;

import com.szboanda.android.platform.util.NetworkUtils;

/**
 * <p>Description: Vpn网络连通性验证策略</p>
 * @Company    深圳市博安达信息技术股份有限公司
 * @author    Siyi Lu    Create Date: 2015-7-20
 * @modify  
 */
public class VpnNetValider implements INetConnectValider{
	
	@Override
	public boolean validNetConnect(Context context, String urlStr) {
		boolean isConnected = false;
		if(NetworkUtils.isNetworkOpened(context)){
			HttpURLConnection conn = null;
			try{
				URL url = new URL(urlStr);
				conn = (HttpURLConnection)url.openConnection();
				conn.setConnectTimeout(5*1000);
				if (conn.getResponseCode() == 200) {
					isConnected = true;
				}
			}catch (Exception e) {
				e.printStackTrace();
			}
			conn.disconnect();
			conn = null;
		}
		return isConnected;
	}

}
