package com.szboanda.android.platform.http.impl;

import android.app.Dialog;
import android.content.Context;
import android.content.Intent;
import android.provider.Settings;
import android.view.View;

import com.szboanda.android.platform.dialog.BaseDialog;
import com.szboanda.android.platform.dialog.MessageDialog;
import com.szboanda.android.platform.http.IErroResolver;
import com.szboanda.android.platform.util.NetworkUtils;

import java.net.ConnectException;

/**
 * <p>Description：</p>
 *
 * @author Created by Siyi Lu on 2017/3/6.
 * @Company 深圳市博安达信息技术股份有限公司
 */

public class ConnectErroResolver extends AbsErroResolver<ConnectException> {

    private final String MSG_DISCONNECT = "检测到您的网络未打开";

    private final String MSG_UNAVAILABLE = "服务不可用，请稍后再试";


    public ConnectErroResolver(Context context, Throwable ex) {
        super(context, ex);
    }

    @Override
    public boolean resolve() {
        MessageDialog tipDialog = null;
        if (isForeground()){
            if(NetworkUtils.isNetworkOpened(getContext())){
                tipDialog = new MessageDialog(getContext(), MSG_UNAVAILABLE);
            }else{
                tipDialog = new MessageDialog(getContext(), MSG_DISCONNECT)
                    .setPositiveButton("打开网络", new BaseDialog.OnDialogButtonClickListener() {
                        @Override
                        public void onClick(Dialog dialog, View v) {
                            Intent intent = new Intent(Settings.ACTION_DATA_ROAMING_SETTINGS);
                            getContext().startActivity(intent);
                        }
                    }).setNegativeButton("取消", new BaseDialog.OnDialogButtonClickListener() {
                        @Override
                        public void onClick(Dialog dialog, View v) {
                            dialog.dismiss();
                        }
                    });
            }
            tipDialog.show();
        }
        return true;
    }

}
