package com.szboanda.android.platform.dialog;

import java.util.ArrayList;
import java.util.List;

import com.szboanda.android.platform.R;
import com.szboanda.android.platform.view.UniversalAdapter;

import android.content.Context;
import android.text.TextUtils;
import android.view.View;
import android.widget.CheckBox;
import android.widget.TextView;

/**
 * <p>Description: 选择项适配器</p>
 * @Company    深圳市博安达软件开发有限公司
 * @author    Siyi Lu    Create Date: 2014-12-15
 * @modify  
 * @param <T>
 */
public abstract class SelectItemAdapter<T> extends UniversalAdapter<T>{
	
	/**列表选中状态*/
	private List<Boolean> mCheckStates = new ArrayList<Boolean>();
	/**过滤后的数据*/
	private List<T> mFiltedData = null;
	/**原始数据*/
	private List<T> mOriginalData = new ArrayList<T>();
	/**是否单选*/
	protected boolean isSingleCheck = false;
	
	public SelectItemAdapter(Context context) {
		super(context, null, R.layout.platform_singleline_select_item);
		mData = new ArrayList<T>();
		initData(0);
	}
	public SelectItemAdapter(Context context, boolean isSingleCheck) {
		this(context);
		this.isSingleCheck = isSingleCheck;
	}
	
	/**初始化数据*/
	void initData(int groupIndex){
		//因为数据是可能多组，使用索引0为默认数据
		mData.clear();
		mData.addAll(getDataAtGroupPosition(groupIndex));
		mOriginalData.clear();
		mOriginalData.addAll(mData);
		refreshCheckStates();
	}
	
	public boolean isSingleCheck() {
		return isSingleCheck;
	}

	public void setSingleCheck(boolean isSingleCheck) {
		this.isSingleCheck = isSingleCheck;
	}

	@Override
	public void bindViewsData(int position, View convertView, T itemData) {
		CheckBox cb = (CheckBox)convertView.findViewById(R.id.multi_check_btn);
		cb.setChecked(mCheckStates.get(position));
		//单选时不显示复选框
		cb.setVisibility(isSingleCheck? View.INVISIBLE:View.VISIBLE);
		TextView txtTitle = (TextView)convertView.findViewById(R.id.item_name);
		bindItemTitle(txtTitle, itemData);
	}
	
	public void onSingleItemCheck(int position){
		List<T> singleCheckItem = new ArrayList<T>(); 
		singleCheckItem.add(mData.get(position));
		onItemChecked(position, singleCheckItem);
	}
	
	public void onMultiItemCheck(int position){
		mCheckStates.set(position, !mCheckStates.get(position));
		notifyDataSetChanged();
	}
	
	public void onPositiveBtnClick(){
		List<T> checkItems = new ArrayList<T>(); 
		int index = 0;
		for(boolean isChecked:mCheckStates){
			if(isChecked){
				checkItems.add(mData.get(index));
			}
			index++;	
		}
		onItemChecked(-1, checkItems);
	}
	
	/**根据关键字过滤数据*/
	public void filteWithKeyword(String keyword){
		mData.clear();
		if(!TextUtils.isEmpty(keyword)){
			if(mFiltedData == null){
				mFiltedData = new ArrayList<T>();
			}
			mFiltedData.clear();
			for(T item:mOriginalData){
				if(isItemMatchKeyword(keyword, item)){
					mFiltedData.add(item);
				}
			}
			mData.addAll(mFiltedData);
		}else{
			mData.addAll(mOriginalData);
		}
		refreshCheckStates();
		notifyDataSetChanged();
	}
	
	/**刷新多选时的选中状态*/
	private void refreshCheckStates(){
		mCheckStates.clear();
		for(int i=0; i<mData.size(); i++){
			mCheckStates.add(false);
		}
	}
	
	public void onGroupSelectChange(int groupIndex){
		initData(groupIndex);
		notifyDataSetChanged();
	}
	
	/**使用Item数据设置标题内容*/
	public abstract void bindItemTitle(TextView txtTitle, T itemData);
	
	/**获取到当前选择组的标题*/
	public abstract String[] getGroupTitles();
	
	/**获取到当前选择组的数据*/
	public abstract List<T> getDataAtGroupPosition(int groupIndex);
	
	/**
	 * 确认选择项时的回调方法
	 * @param position 当{@link #isSingleCheck}值为true时,表示选中项的索引，否则值为-1，无意义
	 * @param checkedItems 当{@link #isSingleCheck}值为true时,长度总是为1
	 */
	public abstract void onItemChecked(int position, List<T> checkedItems);
	
	/**Item的数据匹配关键字的抽象方法*/
	public boolean isItemMatchKeyword(String keyword, T itemData){;
		return false;
	}

}
