package com.szboanda.android.platform.db;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

import org.json.JSONArray;
import org.json.JSONObject;

import android.text.TextUtils;

/**
 * <p>Description:表操作类 </p>
 * @Company    深圳市博安达信息技术股份有限公司
 * @author    Siyi Lu    Create Date: 2015-7-9
 * @modify  
 */
public class TableDao{
	
	private String mTableName;
	
	private List<String> mPrimaryKeys = null;
	
	private JSONArray mFields = null;
	
	private List<String> mFieldNames = null;

    private SQLiteDao mSQLiteDao = null;
	
	public TableDao(String tableName){
		this(null, tableName);
	}
	
	public TableDao(String dbName, String tableName){
        mSQLiteDao = DbHelper.getDao(dbName);
		mTableName = tableName;
		if(!TextUtils.isEmpty(tableName)){
			initTableField();
			initPrimaryKey();
		}
	}
	
	/**
	 * 初始化表主键
	 */
	private void initPrimaryKey(){
		try{
			if(mFields != null && mFields.length()>0){
				mPrimaryKeys = new ArrayList<String>();
				for(int i = 0; i<mFields.length(); i++){
					JSONObject jsonItem = mFields.getJSONObject(i);
					//字段名
					String fieldName = jsonItem.optString("NAME");
					//主键标志
					String pkValue = jsonItem.optString("PK");
					if("1".equals(pkValue)){
						mPrimaryKeys.add(fieldName);
					}
				}
			}
		}catch (Exception e) {
			e.printStackTrace();
		}
	}
	
	/**初始化表信息*/
	private void initTableField(){
		String sql = "PRAGMA TABLE_INFO('" + mTableName + "')";
		mFields = mSQLiteDao.getListValue(sql);
		if(mFields != null && mFields.length()>0){
			mFieldNames = new ArrayList<String>();
			for(int i=0; i<mFields.length(); i++){
				JSONObject curJson = mFields.optJSONObject(i);
				String field = curJson.optString("NAME");
				mFieldNames.add(field);
			}
		}
	}
	
	/**
	 * 开启事务
	 */
	public void beginTransaction(){
		mSQLiteDao.getDaoConfig().setAllowTransaction(true);
        mSQLiteDao.getDatabase().beginTransaction();
	}
	
	/**
	 * 关闭事务
	 */
	public void endTransaction(){
        mSQLiteDao.getDatabase().setTransactionSuccessful();
        mSQLiteDao.getDatabase().endTransaction();
	}
	
	public SQLiteDao getDao(){
		return mSQLiteDao;
	}
	
	public List<String> getPrimaryKeys(){
		return mPrimaryKeys;
	}
	
	public List<String> getTableFields(){
		return mFieldNames;
	}
	
	public void replaceData(JSONObject data){
		String replaceSql = convertJsonToReplaceSql(data);
		mSQLiteDao.exeSql(replaceSql);
	}
	public void insertData(JSONObject data){
		String insertSql = convertJsonToInsertSql(data);
        mSQLiteDao.exeSql(insertSql);
	}
	public void updateData(JSONObject data){
		String updateSql = convertJsonToUpdateSql(data);
        mSQLiteDao.exeSql(updateSql);
	}
	public void deleteData(JSONObject data){
		String deleteSql = convertJsonToDeleteSql(data);
        mSQLiteDao.exeSql(deleteSql);
	}
	
	public void saveListData(List<JSONObject> items){
		beginTransaction();
		for(JSONObject item:items){
			String sql = convertJsonToReplaceSql(item);
            mSQLiteDao.exeSql(sql);
		}
		endTransaction();
	}
	
	/**
	 * 转换JSON为插入语句
	 * @param item
	 * @return
	 */
	private String convertJsonToReplaceSql(JSONObject item){
		String replaceSql = "REPLACE INTO " + mTableName + convertJsonToColVal(item);
		return replaceSql;
	}
	
	/**
	 * 转换JSON为插入语句
	 * @param item
	 * @return
	 */
	private String convertJsonToInsertSql(JSONObject item){
		String insertSql = "INSERT INTO " + mTableName + convertJsonToColVal(item);
		return insertSql;
	}
	
	/**
	 * 将json转为insert或replace语句所需要的字段、字段值拼接字符串
	 * @param item
	 * @return 
	 */
	private String convertJsonToColVal(JSONObject item){
		String columns = "";
		String values = "";
		@SuppressWarnings("unchecked")
		Iterator<String> iterator = item.keys();
		while (iterator.hasNext()) {
			String key = iterator.next();
			if(mFieldNames.contains(key)){
				String value = item.optString(key);
				columns += "," + key;
				values += ",'" + value + "'";
			}
		}
		columns = "".equals(columns) ? columns : columns.substring(1);
		values = "".equals(values) ? values : values.substring(1);
		return " (" + columns + ") VALUES (" + values + ")";
	}
	
	/**
	 * 转换JSON为更新语句
	 * @param item
	 * @return
	 */
	private String convertJsonToUpdateSql(JSONObject item){
		String columns = "";
		String where = " WHERE 1=1 ";
		@SuppressWarnings("unchecked")
		Iterator<String> iterator = item.keys();
		while (iterator.hasNext()) {
			String key = iterator.next();
				if(mFieldNames.contains(key)){
					String value = item.optString(key);
					columns += "," + key + "='" + value + "'";
				if(mPrimaryKeys.contains(key)){
					where += " AND "+ key +"='" + value + "'";
				}
			}
		}
		columns = columns.substring(1);
		String updateSql = "UPDATE "+ mTableName +" SET " + columns + where;
		return updateSql;
	}
	
	/**
	 * 将JSON转换为删除语句
	 * @param data
	 * @return
	 */
	private String convertJsonToDeleteSql(JSONObject data){
		String where = " WHERE 1=1";
		for(String key:mPrimaryKeys){
			String value = data.optString(key);
			where += " AND "+ key +"='" + value + "'";
		}
		String deleteSql = "DELETE FROM " + mTableName + where;
		return deleteSql;
	}

}
