package com.szboanda.android.platform.db;

import org.xutils.db.Selector;
import org.xutils.db.sqlite.WhereBuilder;
import org.xutils.db.table.TableEntity;
import org.xutils.ex.DbException;

import java.util.List;

/**
 * <p>Description：</p>
 *
 * @author Created by Siyi Lu on 2017/2/27.
 * @Company 深圳市博安达信息技术股份有限公司
 */

public class SelectAdapter <T>{

    private Selector mXSelector;

    private SelectAdapter(Class<T> entityType){
        try{
            mXSelector = DbHelper.getDao().selector(entityType);
        }catch(Exception e){
            e.printStackTrace();
        }
    };

    public static <T> SelectAdapter from(Class<T> entityType){
        return new SelectAdapter(entityType);
    }

    public SelectAdapter<T> where(WhereBuilder whereBuilder) {
        mXSelector.where(whereBuilder);
        return this;
    }

    public SelectAdapter<T> where(String columnName, String op, Object value) {
        mXSelector.where(columnName, op, value);
        return this;
    }

    public SelectAdapter<T> and(String columnName, String op, Object value) {
        mXSelector.and(columnName, op, value);
        return this;
    }

    public SelectAdapter<T> and(WhereBuilder where) {
        mXSelector.and(where);
        return this;
    }

    public SelectAdapter<T> or(String columnName, String op, Object value) {
        mXSelector.or(columnName, op, value);
        return this;
    }

    public SelectAdapter or(WhereBuilder where) {
        mXSelector.or(where);
        return this;
    }

    public SelectAdapter<T> expr(String expr) {
        mXSelector.expr(expr);
        return this;
    }

    public SelectAdapter<T> orderBy(String columnName) {
        mXSelector.orderBy(columnName);
        return this;
    }

    public SelectAdapter<T> orderBy(String columnName, boolean desc) {
        mXSelector.orderBy(columnName, desc);
        return this;
    }

    public SelectAdapter<T> limit(int limit) {
        mXSelector.limit(limit);
        return this;
    }

    public SelectAdapter<T> offset(int offset) {
        mXSelector.offset(offset);
        return this;
    }

    public TableEntity<T> getTable() {
        return mXSelector.getTable();
    }

    public WhereBuilder getWhereBuilder() {
        return mXSelector.getWhereBuilder();
    }

    public List<Selector.OrderBy> getOrderByList() {
        return mXSelector.getOrderByList();
    }

    public int getLimit() {
        return mXSelector.getLimit();
    }

    public int getOffset() {
        return mXSelector.getOffset();
    }

    public T findFirst() throws DbException {
        Object result = mXSelector.findFirst();
        return result != null ? (T)result : null;
    }

    public List<T> findAll() throws DbException {
        return mXSelector.findAll();
    }

    public long count() throws DbException {
        return mXSelector.count();
    }

    @Override
    public String toString() {
        return mXSelector.toString();
    }

}
