package com.szboanda.android.platform.activity;

import java.util.Locale;

import com.artifex.mupdfdemo.MuPDFCore;
import com.artifex.mupdfdemo.MuPDFPageAdapter;
import com.artifex.mupdfdemo.MuPDFReaderView;
import com.artifex.mupdfdemo.OutlineActivityData;
import com.szboanda.android.platform.R;
import com.szboanda.android.platform.dialog.MessageDialog;

import android.app.ActionBar;
import android.app.Activity;
import android.net.Uri;
import android.os.Bundle;
import android.view.Gravity;
import android.view.MenuItem;
import android.widget.RelativeLayout;
import android.widget.Toast;

/**
 * @FileName : PdfViewActivity.java
 * @Description : 预览PDF的界面
 * @Copyright : PowerData Share Co.,Ltd.Rights Reserved
 * @Company : 深圳市博安达股份有限公司
 * @author : 罗世平
 * @date : 2015-1-16
 * @version : 1.0
 */
public class PdfViewActivity extends Activity {

	public static final String ACTION_VIEW_PDF = "szboanda.action.view.pdf";
	private MuPDFCore core;
	private String mFileName;
	private MuPDFReaderView mDocView;
	private Toast pageNumberToast;

	@Override
	protected void onCreate(Bundle savedInstanceState) {
		super.onCreate(savedInstanceState);
		ActionBar actionBar = getActionBar();
		if(actionBar != null){
			actionBar.setDisplayHomeAsUpEnabled(true);
			actionBar.setHomeButtonEnabled(true);
			actionBar.setIcon(R.drawable.ic_back_home_white);
		}
		Uri uri = getIntent().getData();
		if (uri == null) {
			new MessageDialog(this, "文件打开失败！").show();
			return;
		}
		core = openFile(Uri.decode(uri.getEncodedPath()));
		if (core == null) {
			new MessageDialog(this, "文件打开失败！").show();
			return;
		}
		createUI(savedInstanceState);
	}

	public void createUI(Bundle savedInstanceState) {
		// Now create the UI.
		// First create the document view
		mDocView = new MuPDFReaderView(this) {

			@Override
			protected void onMoveToChild(int i) {
				if (core == null)
					return;
				final String pageText = String.format(Locale.getDefault(), "%d / %d", i + 1, core.countPages());
				if (pageNumberToast != null) {
					pageNumberToast.setText(pageText);
				} else {
					pageNumberToast = Toast.makeText(PdfViewActivity.this, pageText, Toast.LENGTH_SHORT);
				}
				pageNumberToast.setGravity(Gravity.TOP | Gravity.RIGHT, 0, 0);
				pageNumberToast.show();
				super.onMoveToChild(i);
			}

		};
		mDocView.setAdapter(new MuPDFPageAdapter(this, core));

		mDocView.setDisplayedViewIndex(0);

		// Stick the document view and the buttons overlay into a parent view
		RelativeLayout layout = new RelativeLayout(this);
		layout.addView(mDocView);
		setContentView(layout);
		getActionBar().setTitle(mFileName);
	}
	/**
	 * 打开PDF文档
	 * @param path
	 * @return
	 */
	private MuPDFCore openFile(String path) {
		int lastSlashPos = path.lastIndexOf('/');
		mFileName = new String(lastSlashPos == -1 ? path
				: path.substring(lastSlashPos + 1));
		System.out.println("Trying to open " + path);
		try {
			core = new MuPDFCore(this, path);
			// New file: drop the old outline data
			OutlineActivityData.set(null);
		} catch (Exception e) {
			e.printStackTrace();
			return null;
		}
		return core;
	}

	public void onDestroy() {
		if (core != null)
			core.onDestroy();
		core = null;
		super.onDestroy();
	}
	
	@Override
	public boolean onOptionsItemSelected(MenuItem item) {
		if(item.getItemId() == android.R.id.home){
			finish();
			return true;
		}
		return super.onOptionsItemSelected(item);
	}
}
