/*
 * Decompiled with CFR 0.152.
 */
package com.bmuschko.gradle.docker.shaded.org.bouncycastle.pqc.crypto.xmss;

import com.bmuschko.gradle.docker.shaded.org.bouncycastle.crypto.Digest;
import com.bmuschko.gradle.docker.shaded.org.bouncycastle.pqc.crypto.xmss.DefaultXMSSMTOid;
import com.bmuschko.gradle.docker.shaded.org.bouncycastle.pqc.crypto.xmss.WOTSPlus;
import com.bmuschko.gradle.docker.shaded.org.bouncycastle.pqc.crypto.xmss.XMSSOid;
import com.bmuschko.gradle.docker.shaded.org.bouncycastle.pqc.crypto.xmss.XMSSParameters;

public final class XMSSMTParameters {
    private final XMSSOid oid;
    private final XMSSParameters xmssParams;
    private final int height;
    private final int layers;

    public XMSSMTParameters(int n, int n2, Digest digest) {
        this.height = n;
        this.layers = n2;
        this.xmssParams = new XMSSParameters(XMSSMTParameters.xmssTreeHeight(n, n2), digest);
        this.oid = DefaultXMSSMTOid.lookup(this.getTreeDigest(), this.getTreeDigestSize(), this.getWinternitzParameter(), this.getLen(), this.getHeight(), n2);
    }

    private static int xmssTreeHeight(int n, int n2) throws IllegalArgumentException {
        if (n < 2) {
            throw new IllegalArgumentException("totalHeight must be > 1");
        }
        if (n % n2 != 0) {
            throw new IllegalArgumentException("layers must divide totalHeight without remainder");
        }
        if (n / n2 == 1) {
            throw new IllegalArgumentException("height / layers must be greater than 1");
        }
        return n / n2;
    }

    public int getHeight() {
        return this.height;
    }

    public int getLayers() {
        return this.layers;
    }

    protected XMSSParameters getXMSSParameters() {
        return this.xmssParams;
    }

    protected WOTSPlus getWOTSPlus() {
        return this.xmssParams.getWOTSPlus();
    }

    protected String getTreeDigest() {
        return this.xmssParams.getTreeDigest();
    }

    public int getTreeDigestSize() {
        return this.xmssParams.getTreeDigestSize();
    }

    int getWinternitzParameter() {
        return this.xmssParams.getWinternitzParameter();
    }

    protected int getLen() {
        return this.xmssParams.getLen();
    }

    protected XMSSOid getOid() {
        return this.oid;
    }
}

