/*
 * Decompiled with CFR 0.152.
 */
package com.github.dockerjava.jaxrs;

import com.bmuschko.gradle.docker.shaded.com.google.common.net.UrlEscapers;
import com.bmuschko.gradle.docker.shaded.javax.ws.rs.client.WebTarget;
import com.bmuschko.gradle.docker.shaded.javax.ws.rs.core.GenericType;
import com.github.dockerjava.api.command.ListContainersCmd;
import com.github.dockerjava.api.model.Container;
import com.github.dockerjava.core.DockerClientConfig;
import com.github.dockerjava.core.util.FiltersEncoder;
import com.github.dockerjava.jaxrs.AbstrSyncDockerCmdExec;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ListContainersCmdExec
extends AbstrSyncDockerCmdExec<ListContainersCmd, List<Container>>
implements ListContainersCmd.Exec {
    private static final Logger LOGGER = LoggerFactory.getLogger(ListContainersCmdExec.class);

    public ListContainersCmdExec(WebTarget baseResource, DockerClientConfig dockerClientConfig) {
        super(baseResource, dockerClientConfig);
    }

    @Override
    protected List<Container> execute(ListContainersCmd command) {
        WebTarget webTarget = this.getBaseResource().path("/containers/json").queryParam("since", command.getSinceId()).queryParam("before", command.getBeforeId());
        webTarget = this.booleanQueryParam(webTarget, "all", command.hasShowAllEnabled());
        webTarget = this.booleanQueryParam(webTarget, "size", command.hasShowSizeEnabled());
        if (command.getLimit() != null && command.getLimit() >= 0) {
            webTarget = webTarget.queryParam("limit", String.valueOf(command.getLimit()));
        }
        if (command.getFilters() != null && !command.getFilters().isEmpty()) {
            webTarget = webTarget.queryParam("filters", UrlEscapers.urlPathSegmentEscaper().escape(FiltersEncoder.jsonEncode(command.getFilters())));
        }
        LOGGER.trace("GET: {}", (Object)webTarget);
        List<Container> containers = webTarget.request().accept("application/json").get(new GenericType<List<Container>>(){});
        LOGGER.trace("Response: {}", (Object)containers);
        return containers;
    }
}

