/*
 * Decompiled with CFR 0.152.
 */
package com.bmuschko.gradle.docker.shaded.org.glassfish.jersey.model.internal;

import com.bmuschko.gradle.docker.shaded.javax.annotation.PreDestroy;
import com.bmuschko.gradle.docker.shaded.javax.inject.Singleton;
import com.bmuschko.gradle.docker.shaded.org.glassfish.jersey.internal.inject.InjectionManager;
import java.util.HashSet;
import java.util.Set;

@Singleton
public class ManagedObjectsFinalizer {
    private final InjectionManager injectionManager;
    private final Set<Object> managedObjects = new HashSet<Object>();

    public ManagedObjectsFinalizer(InjectionManager injectionManager) {
        this.injectionManager = injectionManager;
    }

    public void registerForPreDestroyCall(Object object) {
        this.managedObjects.add(object);
    }

    @PreDestroy
    public void preDestroy() {
        try {
            for (Object o : this.managedObjects) {
                this.injectionManager.preDestroy(o);
            }
        }
        finally {
            this.managedObjects.clear();
        }
    }
}

