/*
 * Decompiled with CFR 0.152.
 */
package com.blibli.oss.command.scheduler.impl;

import com.blibli.oss.command.properties.SchedulerProperties;
import com.blibli.oss.command.scheduler.SchedulerHelper;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.springframework.beans.factory.InitializingBean;
import reactor.core.scheduler.Scheduler;
import reactor.core.scheduler.Schedulers;

public class SchedulerHelperImpl
implements SchedulerHelper,
InitializingBean {
    private Map<String, Scheduler> schedulers = new HashMap<String, Scheduler>();
    private SchedulerProperties schedulerProperties;

    public SchedulerHelperImpl(SchedulerProperties schedulerProperties) {
        this.schedulerProperties = schedulerProperties;
    }

    public void afterPropertiesSet() throws Exception {
        this.schedulerProperties.getConfigs().forEach((name, properties) -> this.schedulers.put((String)name, this.createScheduler((SchedulerProperties.SchedulerItemProperties)properties)));
    }

    private Scheduler createScheduler(SchedulerProperties.SchedulerItemProperties properties) {
        switch (properties.getType()) {
            case ELASTIC: {
                return Schedulers.elastic();
            }
            case SINGLE: {
                return Schedulers.single();
            }
            case PARALLEL: {
                return Schedulers.parallel();
            }
            case NEW_ELASTIC: {
                return this.newElasticScheduler(properties.getNewElastic());
            }
            case NEW_PARALLEL: {
                return this.newParallelScheduler(properties.getNewParallel());
            }
            case NEW_SINGLE: {
                return this.newSingleScheduler(properties.getNewSingle());
            }
            case EXECUTOR: {
                return this.newExecutorScheduler(properties.getExecutor());
            }
            case THREAD_POOL: {
                return this.newThreadPollScheduler(properties.getThreadPool());
            }
        }
        return Schedulers.immediate();
    }

    private Scheduler newThreadPollScheduler(SchedulerProperties.SchedulerThreadPoolProperties properties) {
        ThreadPoolExecutor executor = new ThreadPoolExecutor(properties.getCorePoolSize(), properties.getMaximumPoolSize(), properties.getTtlSeconds().longValue(), TimeUnit.SECONDS, this.createBlockingQueue(properties));
        executor.allowCoreThreadTimeOut(properties.getAllowCoreThreadTimeOut());
        return Schedulers.fromExecutor((Executor)executor);
    }

    private BlockingQueue<Runnable> createBlockingQueue(SchedulerProperties.SchedulerThreadPoolProperties properties) {
        switch (properties.getQueueType()) {
            case ARRAY: {
                return new ArrayBlockingQueue<Runnable>(properties.getQueueSize());
            }
        }
        return new LinkedBlockingQueue<Runnable>(properties.getQueueSize());
    }

    private Scheduler newExecutorScheduler(SchedulerProperties.SchedulerExecutorProperties properties) {
        switch (properties.getType()) {
            case WORK_STEALING_POOL: {
                return Schedulers.fromExecutorService((ExecutorService)Executors.newWorkStealingPool(properties.getParallelism()));
            }
            case CACHED_THREAD_POOL: {
                return Schedulers.fromExecutorService((ExecutorService)Executors.newCachedThreadPool());
            }
            case FIXED_THREAD_POOL: {
                return Schedulers.fromExecutorService((ExecutorService)Executors.newFixedThreadPool(properties.getNumberOfThread()));
            }
        }
        return Schedulers.fromExecutorService((ExecutorService)Executors.newSingleThreadExecutor());
    }

    private Scheduler newSingleScheduler(SchedulerProperties.SchedulerNewSingleProperties properties) {
        return Schedulers.newSingle((String)properties.getName(), (boolean)properties.getDaemon());
    }

    private Scheduler newParallelScheduler(SchedulerProperties.SchedulerNewParallelProperties properties) {
        return Schedulers.newParallel((String)properties.getName(), (int)properties.getParallelism(), (boolean)properties.getDaemon());
    }

    private Scheduler newElasticScheduler(SchedulerProperties.SchedulerNewElasticProperties properties) {
        return Schedulers.newElastic((String)properties.getName(), (int)properties.getTtlSeconds(), (boolean)properties.getDaemon());
    }

    @Override
    public Scheduler of(String name) {
        Scheduler scheduler = this.schedulers.get(name);
        if (scheduler == null) {
            return Schedulers.immediate();
        }
        return scheduler;
    }
}

