/*
 * Decompiled with CFR 0.152.
 */
package com.blibli.oss.command.impl;

import com.blibli.oss.command.Command;
import com.blibli.oss.command.CommandProcessor;
import com.blibli.oss.command.hystrix.CommandHystrix;
import com.blibli.oss.command.plugin.CommandGroupStrategy;
import com.blibli.oss.command.plugin.CommandInterceptor;
import com.blibli.oss.command.plugin.CommandKeyStrategy;
import com.blibli.oss.command.plugin.InterceptorUtil;
import com.blibli.oss.command.properties.CommandProperties;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import rx.Single;

public class CommandProcessorImpl
implements CommandProcessor,
ApplicationContextAware,
InitializingBean {
    private CommandProperties commandProperties;
    private CommandKeyStrategy commandKeyStrategy;
    private CommandGroupStrategy commandGroupStrategy;
    private ApplicationContext applicationContext;
    private Collection<CommandInterceptor> commandInterceptors = Collections.emptyList();

    public CommandProcessorImpl(CommandProperties commandProperties, CommandKeyStrategy commandKeyStrategy, CommandGroupStrategy commandGroupStrategy) {
        this.commandProperties = commandProperties;
        this.commandKeyStrategy = commandKeyStrategy;
        this.commandGroupStrategy = commandGroupStrategy;
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }

    public void afterPropertiesSet() throws Exception {
        this.loadCommandInterceptors();
    }

    private void loadCommandInterceptors() {
        Map interceptorMap = this.applicationContext.getBeansOfType(CommandInterceptor.class);
        if (interceptorMap != null && !interceptorMap.isEmpty()) {
            this.commandInterceptors = interceptorMap.values();
        }
    }

    @Override
    public <R, T> Single<T> doExecute(Class<? extends Command<R, T>> commandClass, R request) {
        Command command = (Command)this.applicationContext.getBean(commandClass);
        return Single.create(singleSubscriber -> {
            Object result = InterceptorUtil.beforeExecute(this.commandInterceptors, command, request);
            singleSubscriber.onSuccess(result);
        }).flatMap(result -> {
            if (result != null) {
                return Single.just((Object)result);
            }
            return this.doExecuteCommand(request, command);
        });
    }

    private <R, T> Single<T> doExecuteCommand(R request, Command<R, T> command) {
        if (this.commandProperties.getHystrix().isEnabled()) {
            return this.doExecuteWithHystrix(request, command);
        }
        return this.doExecuteWithoutHystrix(request, command);
    }

    private <R, T> Single<T> doExecuteWithoutHystrix(R request, Command<R, T> command) {
        return command.execute(request).doOnSuccess(response -> InterceptorUtil.afterSuccessExecute(this.commandInterceptors, command, request, response)).doOnError(throwable -> InterceptorUtil.afterFailedExecute(this.commandInterceptors, command, request, throwable)).onErrorResumeNext(throwable -> command.fallback((Throwable)throwable, request));
    }

    private <R, T> Single<T> doExecuteWithHystrix(R request, Command<R, T> command) {
        String commandKey = this.commandKeyStrategy.getCommandKey(command);
        String commandGroup = this.commandGroupStrategy.getCommandGroup(command);
        return new CommandHystrix<R, T>(command, request, commandKey, commandGroup, this.commandInterceptors).toObservable().toSingle();
    }
}

