/*
 * Decompiled with CFR 0.152.
 */
package com.blazebit.persistence.spring.data.base.query;

import com.blazebit.persistence.spring.data.annotation.OptionalParam;
import com.blazebit.persistence.spring.data.repository.BlazeSpecification;
import com.blazebit.persistence.spring.data.repository.EntityViewSettingProcessor;
import com.blazebit.persistence.spring.data.repository.KeysetPageable;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import javax.persistence.TemporalType;
import org.springframework.core.MethodParameter;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.data.jpa.repository.Temporal;
import org.springframework.data.repository.query.Param;
import org.springframework.data.repository.query.Parameter;
import org.springframework.data.repository.query.Parameters;

public class JpaParameters
extends Parameters<JpaParameters, JpaParameter> {
    private final int keysetPageableIndex;

    public JpaParameters(Method method) {
        super(method);
        if (super.hasPageableParameter()) {
            this.keysetPageableIndex = -1;
        } else {
            int i;
            Class<?>[] types = method.getParameterTypes();
            for (i = 0; i < types.length && types[i] != KeysetPageable.class; ++i) {
            }
            this.keysetPageableIndex = i == types.length ? -1 : i;
        }
    }

    private JpaParameters(List<JpaParameter> parameters) {
        super(parameters);
        if (super.hasPageableParameter()) {
            this.keysetPageableIndex = -1;
        } else {
            JpaParameter jpaParameter;
            int i;
            for (i = 0; i < parameters.size() && (jpaParameter = parameters.get(i)).getType() != KeysetPageable.class; ++i) {
            }
            this.keysetPageableIndex = i == parameters.size() ? -1 : i;
        }
    }

    public boolean hasPageableParameter() {
        return this.keysetPageableIndex != -1 || super.hasPageableParameter();
    }

    public int getPageableIndex() {
        return this.keysetPageableIndex == -1 ? super.getPageableIndex() : this.keysetPageableIndex;
    }

    public JpaParameters getOptionalParameters() {
        ArrayList<JpaParameter> parameters = new ArrayList<JpaParameter>();
        Iterator iterator = this.iterator();
        while (iterator.hasNext()) {
            JpaParameter candidate = (JpaParameter)((Object)iterator.next());
            if (!candidate.isOptionalParameter()) continue;
            parameters.add(candidate);
        }
        return this.createFrom(parameters);
    }

    public int getSpecificationIndex() {
        int index = 0;
        Iterator iterator = this.iterator();
        while (iterator.hasNext()) {
            JpaParameter candidate = (JpaParameter)((Object)iterator.next());
            if (candidate.isSpecificationParameter()) {
                return index;
            }
            ++index;
        }
        return -1;
    }

    public boolean hasSpecificationParameter() {
        return this.getSpecificationIndex() >= 0;
    }

    public int getEntityViewSettingProcessorIndex() {
        int index = 0;
        Iterator iterator = this.iterator();
        while (iterator.hasNext()) {
            JpaParameter candidate = (JpaParameter)((Object)iterator.next());
            if (candidate.isEntityViewSettingProcessorParameter()) {
                return index;
            }
            ++index;
        }
        return -1;
    }

    public boolean hasEntityViewSettingProcessorParameter() {
        return this.getEntityViewSettingProcessorIndex() >= 0;
    }

    public int getBlazeSpecificationIndex() {
        int index = 0;
        Iterator iterator = this.iterator();
        while (iterator.hasNext()) {
            JpaParameter candidate = (JpaParameter)((Object)iterator.next());
            if (candidate.isBlazeSpecificationParameter()) {
                return index;
            }
            ++index;
        }
        return -1;
    }

    public boolean hasBlazeSpecificationParameter() {
        return this.getBlazeSpecificationIndex() >= 0;
    }

    protected JpaParameter createParameter(MethodParameter parameter) {
        return new JpaParameter(parameter);
    }

    protected JpaParameters createFrom(List<JpaParameter> parameters) {
        return new JpaParameters(parameters);
    }

    public static class JpaParameter
    extends Parameter {
        private final MethodParameter parameter;
        private final OptionalParam optional;
        private final Temporal annotation;
        private TemporalType temporalType;

        JpaParameter(MethodParameter parameter) {
            super(parameter);
            this.parameter = parameter;
            this.optional = (OptionalParam)parameter.getParameterAnnotation(OptionalParam.class);
            this.annotation = (Temporal)parameter.getParameterAnnotation(Temporal.class);
            this.temporalType = null;
            if (!this.isDateParameter() && this.hasTemporalParamAnnotation()) {
                throw new IllegalArgumentException(Temporal.class.getSimpleName() + " annotation is only allowed on Date parameter!");
            }
        }

        public String getParameterName() {
            Param annotation = (Param)this.parameter.getParameterAnnotation(Param.class);
            if (annotation != null) {
                return annotation.value();
            }
            return this.optional == null ? this.parameter.getParameterName() : this.optional.value();
        }

        public boolean isBindable() {
            return super.isBindable() || this.isTemporalParameter();
        }

        public boolean isSpecialParameter() {
            return super.isSpecialParameter() || this.isOptionalParameter() || this.isSpecificationParameter() || this.isEntityViewSettingProcessorParameter() || this.isBlazeSpecificationParameter();
        }

        boolean isOptionalParameter() {
            return this.optional != null;
        }

        boolean isSpecificationParameter() {
            return Specification.class.isAssignableFrom(this.parameter.getParameterType());
        }

        boolean isEntityViewSettingProcessorParameter() {
            return EntityViewSettingProcessor.class.isAssignableFrom(this.parameter.getParameterType());
        }

        boolean isBlazeSpecificationParameter() {
            return BlazeSpecification.class.isAssignableFrom(this.parameter.getParameterType());
        }

        boolean isTemporalParameter() {
            return this.isDateParameter() && this.hasTemporalParamAnnotation();
        }

        TemporalType getTemporalType() {
            if (this.temporalType == null) {
                this.temporalType = this.annotation == null ? null : this.annotation.value();
            }
            return this.temporalType;
        }

        TemporalType getRequiredTemporalType() throws IllegalStateException {
            TemporalType temporalType = this.getTemporalType();
            if (temporalType != null) {
                return temporalType;
            }
            throw new IllegalStateException(String.format("Required temporal type not found for %s!", this.getType()));
        }

        private boolean hasTemporalParamAnnotation() {
            return this.annotation != null;
        }

        private boolean isDateParameter() {
            return this.getType().equals(Date.class);
        }
    }
}

