/*
 * Decompiled with CFR 0.152.
 */
package com.blazebit.persistence.integration.hibernate.base;

import com.blazebit.persistence.ReturningResult;
import com.blazebit.persistence.integration.hibernate.base.HibernateAccess;
import com.blazebit.persistence.integration.hibernate.base.HibernateAccessUtils;
import com.blazebit.persistence.integration.hibernate.base.HibernateReturningResult;
import com.blazebit.persistence.spi.ConfigurationSource;
import com.blazebit.persistence.spi.DbmsDialect;
import com.blazebit.persistence.spi.ExtendedQuerySupport;
import com.blazebit.persistence.spi.ServiceProvider;
import com.blazebit.reflection.ReflectionUtils;
import jakarta.persistence.EntityManager;
import jakarta.persistence.NoResultException;
import jakarta.persistence.PersistenceException;
import jakarta.persistence.Query;
import jakarta.persistence.Tuple;
import jakarta.persistence.TupleElement;
import jakarta.persistence.criteria.CompoundSelection;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.sql.PreparedStatement;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.Spliterator;
import java.util.Spliterators;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.logging.Logger;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.hibernate.HibernateException;
import org.hibernate.NonUniqueResultException;
import org.hibernate.ScrollMode;
import org.hibernate.engine.jdbc.env.spi.JdbcEnvironment;
import org.hibernate.engine.jdbc.spi.JdbcServices;
import org.hibernate.engine.spi.BatchFetchQueue;
import org.hibernate.engine.spi.Mapping;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.engine.spi.SessionImplementor;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.engine.spi.SubselectFetch;
import org.hibernate.internal.util.collections.ArrayHelper;
import org.hibernate.internal.util.collections.BoundedConcurrentHashMap;
import org.hibernate.metamodel.MappingMetamodel;
import org.hibernate.metamodel.mapping.MappingModelExpressible;
import org.hibernate.persister.entity.EntityPersister;
import org.hibernate.query.IllegalQueryOperationException;
import org.hibernate.query.TupleTransformer;
import org.hibernate.query.criteria.JpaSelection;
import org.hibernate.query.internal.ScrollableResultsIterator;
import org.hibernate.query.spi.DomainQueryExecutionContext;
import org.hibernate.query.spi.Limit;
import org.hibernate.query.spi.NonSelectQueryPlan;
import org.hibernate.query.spi.QueryInterpretationCache;
import org.hibernate.query.spi.QueryOptions;
import org.hibernate.query.spi.QueryParameterBindings;
import org.hibernate.query.spi.QueryPlan;
import org.hibernate.query.spi.ScrollableResultsImplementor;
import org.hibernate.query.sqm.internal.DomainParameterXref;
import org.hibernate.query.sqm.internal.MultiTableDeleteQueryPlan;
import org.hibernate.query.sqm.internal.MultiTableUpdateQueryPlan;
import org.hibernate.query.sqm.internal.QuerySqmImpl;
import org.hibernate.query.sqm.internal.SimpleDeleteQueryPlan;
import org.hibernate.query.sqm.internal.SimpleUpdateQueryPlan;
import org.hibernate.query.sqm.internal.SqmInterpretationsKey;
import org.hibernate.query.sqm.internal.SqmJdbcExecutionContextAdapter;
import org.hibernate.query.sqm.internal.SqmUtil;
import org.hibernate.query.sqm.spi.SqmParameterMappingModelResolutionAccess;
import org.hibernate.query.sqm.sql.SqmTranslation;
import org.hibernate.query.sqm.sql.SqmTranslator;
import org.hibernate.query.sqm.sql.SqmTranslatorFactory;
import org.hibernate.query.sqm.tree.SqmStatement;
import org.hibernate.query.sqm.tree.delete.SqmDeleteStatement;
import org.hibernate.query.sqm.tree.expression.SqmParameter;
import org.hibernate.query.sqm.tree.from.SqmFrom;
import org.hibernate.query.sqm.tree.from.SqmJoin;
import org.hibernate.query.sqm.tree.from.SqmRoot;
import org.hibernate.query.sqm.tree.insert.SqmInsertSelectStatement;
import org.hibernate.query.sqm.tree.insert.SqmInsertStatement;
import org.hibernate.query.sqm.tree.select.SqmDynamicInstantiation;
import org.hibernate.query.sqm.tree.select.SqmQueryGroup;
import org.hibernate.query.sqm.tree.select.SqmQueryPart;
import org.hibernate.query.sqm.tree.select.SqmQuerySpec;
import org.hibernate.query.sqm.tree.select.SqmSelectStatement;
import org.hibernate.query.sqm.tree.select.SqmSelectableNode;
import org.hibernate.query.sqm.tree.select.SqmSelection;
import org.hibernate.query.sqm.tree.update.SqmUpdateStatement;
import org.hibernate.spi.NavigablePath;
import org.hibernate.sql.ast.SqlAstTranslator;
import org.hibernate.sql.ast.SqlAstTranslatorFactory;
import org.hibernate.sql.ast.spi.FromClauseAccess;
import org.hibernate.sql.ast.spi.SqlAstCreationContext;
import org.hibernate.sql.ast.spi.SqlSelection;
import org.hibernate.sql.ast.tree.Statement;
import org.hibernate.sql.ast.tree.delete.DeleteStatement;
import org.hibernate.sql.ast.tree.from.CollectionTableGroup;
import org.hibernate.sql.ast.tree.from.LazyTableGroup;
import org.hibernate.sql.ast.tree.from.NamedTableReference;
import org.hibernate.sql.ast.tree.from.TableGroup;
import org.hibernate.sql.ast.tree.insert.InsertSelectStatement;
import org.hibernate.sql.ast.tree.insert.InsertStatement;
import org.hibernate.sql.ast.tree.select.QueryGroup;
import org.hibernate.sql.ast.tree.select.QueryPart;
import org.hibernate.sql.ast.tree.select.QuerySpec;
import org.hibernate.sql.ast.tree.select.SelectStatement;
import org.hibernate.sql.ast.tree.update.UpdateStatement;
import org.hibernate.sql.exec.internal.JdbcParameterBindingsImpl;
import org.hibernate.sql.exec.spi.ExecutionContext;
import org.hibernate.sql.exec.spi.JdbcOperationQuery;
import org.hibernate.sql.exec.spi.JdbcOperationQueryMutation;
import org.hibernate.sql.exec.spi.JdbcOperationQuerySelect;
import org.hibernate.sql.exec.spi.JdbcOperationQueryUpdate;
import org.hibernate.sql.exec.spi.JdbcParameterBinder;
import org.hibernate.sql.exec.spi.JdbcParameterBindings;
import org.hibernate.sql.exec.spi.JdbcParametersList;
import org.hibernate.sql.results.internal.RowTransformerJpaTupleImpl;
import org.hibernate.sql.results.internal.RowTransformerSingularReturnImpl;
import org.hibernate.sql.results.internal.RowTransformerStandardImpl;
import org.hibernate.sql.results.internal.RowTransformerTupleTransformerAdapter;
import org.hibernate.sql.results.internal.TupleMetadata;
import org.hibernate.sql.results.jdbc.spi.JdbcValuesMapping;
import org.hibernate.sql.results.spi.ListResultsConsumer;
import org.hibernate.sql.results.spi.RowTransformer;
import org.hibernate.type.Type;

public class HibernateExtendedQuerySupport
implements ExtendedQuerySupport {
    private static final Logger LOG = Logger.getLogger(HibernateExtendedQuerySupport.class.getName());
    private static final Constructor<TupleMetadata> TUPLE_METADATA_CONSTRUCTOR_62;
    private static final Constructor<TupleMetadata> TUPLE_METADATA_CONSTRUCTOR_63;
    private static final RowTransformer ROW_TRANSFORMER_SINGULAR_RETURN;
    private static final RowTransformer ROW_TRANSFORMER_STANDARD;
    private final HibernateAccess hibernateAccess;
    private final BoundedConcurrentHashMap<QueryInterpretationCache.Key, QueryPlan> participatingInterpretationCache;
    private final BoundedConcurrentHashMap<QueryInterpretationCache.Key, QueryPlan> queryPlanCache;

    public HibernateExtendedQuerySupport() {
        Iterator<HibernateAccess> serviceIter = ServiceLoader.load(HibernateAccess.class).iterator();
        if (!serviceIter.hasNext()) {
            throw new IllegalStateException("Hibernate integration was not found on the class path!");
        }
        this.hibernateAccess = serviceIter.next();
        this.participatingInterpretationCache = new BoundedConcurrentHashMap(2048, 20, BoundedConcurrentHashMap.Eviction.LIRS);
        this.queryPlanCache = new BoundedConcurrentHashMap(2048, 20, BoundedConcurrentHashMap.Eviction.LIRS);
    }

    public boolean supportsAdvancedSql() {
        return true;
    }

    public boolean needsExampleQueryForAdvancedDml() {
        return true;
    }

    public boolean applyFirstResultMaxResults(Query query, int firstResult, int maxResults) {
        Limit limit = ((QuerySqmImpl)query.unwrap(QuerySqmImpl.class)).getQueryOptions().getLimit();
        Integer firstRow = firstResult == 0 ? null : Integer.valueOf(firstResult);
        Integer maxRows = maxResults == Integer.MAX_VALUE ? null : Integer.valueOf(maxResults);
        boolean changed = firstRow == null && limit.getFirstRow() != null || firstRow != null && limit.getFirstRow() == null || maxRows == null && limit.getMaxRows() != null || maxRows != null && limit.getMaxRows() == null;
        limit.setFirstRow(firstRow);
        limit.setMaxRows(maxRows);
        return changed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getSql(EntityManager em, Query query) {
        QuerySqmImpl hqlQuery = (QuerySqmImpl)query.unwrap(QuerySqmImpl.class);
        SessionFactoryImplementor factory = hqlQuery.getSessionFactory();
        CacheableSqmInterpretation interpretation = HibernateExtendedQuerySupport.buildQueryPlan(query);
        try {
            String string = this.getJdbcOperation(factory, interpretation, hqlQuery).getSqlString();
            return string;
        }
        finally {
            interpretation.domainParameterXref.clearExpansions();
        }
    }

    public boolean getSqlContainsLimit() {
        return true;
    }

    public List<String> getCascadingDeleteSql(EntityManager em, Query query) {
        SessionFactoryImplementor sfi = ((SessionImplementor)em.unwrap(SessionImplementor.class)).getSessionFactory();
        QuerySqmImpl hqlQuery = (QuerySqmImpl)query.unwrap(QuerySqmImpl.class);
        if (hqlQuery.getSqmStatement() instanceof SqmDeleteStatement) {
            SqmDeleteStatement deleteStatement = (SqmDeleteStatement)hqlQuery.getSqmStatement();
            String mutatingEntityName = deleteStatement.getTarget().getModel().getHibernateEntityName();
            EntityPersister entityDescriptor = sfi.getMappingMetamodel().getEntityDescriptor(mutatingEntityName);
            SqlAstTranslatorFactory sqlAstTranslatorFactory = sfi.getJdbcServices().getJdbcEnvironment().getSqlAstTranslatorFactory();
            ArrayList<String> deleteSqls = new ArrayList<String>();
            entityDescriptor.visitConstraintOrderedTables((tableExpression, tableKeyColumnsVisitationSupplier) -> {
                Object matchingIdsPredicate = null;
            });
            return deleteSqls;
        }
        return Collections.EMPTY_LIST;
    }

    public String getSqlAlias(EntityManager em, Query query, String alias, int queryPartNumber) {
        SqmQuerySpec<?> querySpec;
        QuerySqmImpl hqlQuery = (QuerySqmImpl)query.unwrap(QuerySqmImpl.class);
        if (hqlQuery.getSqmStatement() instanceof SqmSelectStatement) {
            querySpec = this.getQuerySpec(((SqmSelectStatement)hqlQuery.getSqmStatement()).getQueryPart(), queryPartNumber);
        } else if (hqlQuery.getSqmStatement() instanceof SqmInsertSelectStatement) {
            querySpec = this.getQuerySpec(((SqmInsertSelectStatement)hqlQuery.getSqmStatement()).getSelectQueryPart(), queryPartNumber);
        } else {
            throw new IllegalArgumentException("The alias " + alias + " could not be found in the query: " + query);
        }
        NavigablePath navigablePath = this.findNavigablePath(alias, querySpec);
        CacheableSqmInterpretation interpretation = HibernateExtendedQuerySupport.buildQuerySpecPlan(query);
        TableGroup tableGroup = this.getTableGroup(interpretation, navigablePath);
        return tableGroup.getPrimaryTableReference().getIdentificationVariable();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ExtendedQuerySupport.SqlFromInfo getSqlFromInfo(EntityManager em, Query query, String alias, int queryPartNumber) {
        String sql;
        SqmQuerySpec<?> querySpec;
        QuerySqmImpl hqlQuery = (QuerySqmImpl)query.unwrap(QuerySqmImpl.class);
        if (hqlQuery.getSqmStatement() instanceof SqmSelectStatement) {
            querySpec = this.getQuerySpec(((SqmSelectStatement)hqlQuery.getSqmStatement()).getQueryPart(), queryPartNumber);
        } else if (hqlQuery.getSqmStatement() instanceof SqmInsertSelectStatement) {
            querySpec = this.getQuerySpec(((SqmInsertSelectStatement)hqlQuery.getSqmStatement()).getSelectQueryPart(), queryPartNumber);
        } else {
            throw new IllegalArgumentException("The alias " + alias + " could not be found in the query: " + query);
        }
        NavigablePath navigablePath = this.findNavigablePath(alias, querySpec);
        CacheableSqmInterpretation interpretation = HibernateExtendedQuerySupport.buildQuerySpecPlan(query);
        TableGroup tableGroup = this.getTableGroup(interpretation, navigablePath);
        NamedTableReference primaryTableReference = (NamedTableReference)tableGroup.getPrimaryTableReference();
        final String tableAlias = primaryTableReference.getIdentificationVariable();
        SessionFactoryImplementor sfi = ((SessionImplementor)em.unwrap(SessionImplementor.class)).getSessionFactory();
        String fromText = primaryTableReference.getTableId() + " " + tableAlias;
        String fakeFromText = primaryTableReference.getTableId() + "/**/ " + tableAlias;
        primaryTableReference.setPrunedTableExpression(primaryTableReference.getTableId() + "/**/");
        try {
            sql = this.getJdbcOperation(sfi, interpretation, hqlQuery).getSqlString();
        }
        finally {
            interpretation.domainParameterXref.clearExpansions();
        }
        final int startIndex = sql.indexOf(fakeFromText);
        final int endIndex = startIndex + fromText.length();
        return new ExtendedQuerySupport.SqlFromInfo(){

            public String getAlias() {
                return tableAlias;
            }

            public int getFromStartIndex() {
                return startIndex;
            }

            public int getFromEndIndex() {
                return endIndex;
            }
        };
    }

    private NavigablePath findNavigablePath(String alias, SqmQuerySpec<?> querySpec) {
        for (SqmRoot root : querySpec.getFromClause().getRoots()) {
            NavigablePath path = this.findNavigablePath(alias, (SqmFrom<?, ?>)root);
            if (path == null) continue;
            return path;
        }
        return null;
    }

    private NavigablePath findNavigablePath(String alias, SqmFrom<?, ?> sqmFrom) {
        if (alias.equals(sqmFrom.getExplicitAlias())) {
            return sqmFrom.getNavigablePath();
        }
        for (SqmJoin sqmJoin : sqmFrom.getSqmJoins()) {
            NavigablePath path = this.findNavigablePath(alias, (SqmFrom<?, ?>)sqmJoin);
            if (path == null) continue;
            return path;
        }
        return null;
    }

    private SqmQuerySpec<?> getQuerySpec(SqmQueryPart<?> queryPart, int queryPartNumber) {
        Object querySpec = this.getQuerySpec(queryPart, 0, queryPartNumber);
        if (querySpec instanceof SqmQuerySpec) {
            return (SqmQuerySpec)querySpec;
        }
        throw new IllegalArgumentException("Couldn't find query part number " + queryPartNumber + " in query part: " + queryPart);
    }

    private Object getQuerySpec(SqmQueryPart<?> queryPart, int currentNumber, int queryPartNumber) {
        if (currentNumber == queryPartNumber) {
            return queryPart.getFirstQuerySpec();
        }
        if (queryPart instanceof SqmQueryGroup) {
            List queryParts = ((SqmQueryGroup)queryPart).getQueryParts();
            int offset = 0;
            for (int i = 0; i < queryParts.size(); ++i) {
                Object result = this.getQuerySpec((SqmQueryPart)queryParts.get(i), currentNumber + offset, queryPartNumber);
                if (result instanceof SqmQuerySpec) {
                    return result;
                }
                offset += ((Integer)result).intValue();
            }
            return offset;
        }
        return 1;
    }

    private TableGroup getTableGroup(CacheableSqmInterpretation interpretation, NavigablePath navigablePath) {
        Object tableGroup = interpretation.tableGroupAccess.findTableGroup(navigablePath);
        if (tableGroup == null) {
            Statement sqlAst = interpretation.sqmTranslation.getSqlAst();
            tableGroup = sqlAst instanceof SelectStatement ? this.findTableGroup(((SelectStatement)sqlAst).getQueryPart(), navigablePath) : (sqlAst instanceof InsertSelectStatement ? this.findTableGroup(((InsertSelectStatement)sqlAst).getSourceSelectStatement(), navigablePath) : null);
        }
        if (tableGroup != null) {
            if (tableGroup instanceof CollectionTableGroup) {
                TableGroup elementTableGroup = ((CollectionTableGroup)tableGroup).getElementTableGroup();
                return elementTableGroup == null || elementTableGroup instanceof LazyTableGroup && ((LazyTableGroup)elementTableGroup).getUnderlyingTableGroup() == null ? tableGroup : elementTableGroup;
            }
            return tableGroup;
        }
        throw new IllegalArgumentException("Couldn't find the table group for the navigable path: " + navigablePath);
    }

    private TableGroup findTableGroup(QueryPart queryPart, NavigablePath navigablePath) {
        if (queryPart instanceof QueryGroup) {
            for (QueryPart part : ((QueryGroup)queryPart).getQueryParts()) {
                TableGroup tableGroup2 = this.findTableGroup(part, navigablePath);
                if (tableGroup2 == null) continue;
                return tableGroup2;
            }
        } else {
            QuerySpec querySpec = (QuerySpec)queryPart;
            return (TableGroup)querySpec.getFromClause().queryTableGroups(tableGroup -> tableGroup.getNavigablePath() == navigablePath ? tableGroup : null);
        }
        return null;
    }

    public int getSqlSelectAliasPosition(EntityManager em, Query query, String alias) {
        SqmQuerySpec querySpec;
        QuerySqmImpl hqlQuery = (QuerySqmImpl)query.unwrap(QuerySqmImpl.class);
        if (hqlQuery.getSqmStatement() instanceof SqmSelectStatement) {
            querySpec = ((SqmSelectStatement)hqlQuery.getSqmStatement()).getQuerySpec();
        } else if (hqlQuery.getSqmStatement() instanceof SqmInsertSelectStatement) {
            querySpec = ((SqmInsertSelectStatement)hqlQuery.getSqmStatement()).getSelectQueryPart().getFirstQuerySpec();
        } else {
            throw new IllegalArgumentException("The alias " + alias + " could not be found in the query: " + query);
        }
        boolean found = false;
        int position = 1;
        for (SqmSelectableNode selectionItem : querySpec.getSelectClause().getSelectionItems()) {
            if (alias.equals(selectionItem.getAlias())) {
                found = true;
                break;
            }
            ++position;
        }
        return found ? position : -1;
    }

    public int getSqlSelectAttributePosition(EntityManager em, Query query, String expression) {
        SqmQuerySpec querySpec;
        if (expression.contains(".")) {
            throw new UnsupportedOperationException("Embeddables are not yet supported!");
        }
        QuerySqmImpl hqlQuery = (QuerySqmImpl)query.unwrap(QuerySqmImpl.class);
        if (hqlQuery.getSqmStatement() instanceof SqmSelectStatement) {
            querySpec = ((SqmSelectStatement)hqlQuery.getSqmStatement()).getQuerySpec();
        } else if (hqlQuery.getSqmStatement() instanceof SqmInsertSelectStatement) {
            querySpec = ((SqmInsertSelectStatement)hqlQuery.getSqmStatement()).getSelectQueryPart().getFirstQuerySpec();
        } else {
            throw new IllegalArgumentException("The expression " + expression + " could not be found in the query: " + query);
        }
        boolean found = false;
        int position = 1;
        if (querySpec.getSelectClause().getSelectionItems().size() == 1 && querySpec.getSelectClause().getSelectionItems().get(0) instanceof SqmRoot) {
            SqmRoot root = (SqmRoot)querySpec.getSelectClause().getSelectionItems().get(0);
            EntityPersister entityPersister = hqlQuery.getSessionFactory().getMetamodel().getEntityDescriptor(root.getEntityName());
            int propertyIndex = entityPersister.getEntityMetamodel().getPropertyIndex(expression);
            Type[] propertyTypes = entityPersister.getPropertyTypes();
            for (int j = 0; j < propertyIndex; ++j) {
                position += propertyTypes[j].getColumnSpan((Mapping)hqlQuery.getSessionFactory());
            }
            return position;
        }
        for (SqmSelectableNode selectionItem : querySpec.getSelectClause().getSelectionItems()) {
            if (expression.equals(selectionItem.asLoggableText())) {
                found = true;
                break;
            }
            ++position;
        }
        return found ? position : -1;
    }

    public List getResultList(ServiceProvider serviceProvider, List<Query> participatingQueries, Query query, String sqlOverride, boolean queryPlanCacheEnabled) {
        return this.getResultList(serviceProvider, participatingQueries, query, sqlOverride, queryPlanCacheEnabled, (DomainQueryExecutionContext)query.unwrap(DomainQueryExecutionContext.class));
    }

    private List getResultList(ServiceProvider serviceProvider, List<Query> participatingQueries, Query query, String sqlOverride, boolean queryPlanCacheEnabled, DomainQueryExecutionContext executionContext) {
        Object jdbcOperation;
        QuerySqmImpl hqlQuery = (QuerySqmImpl)query.unwrap(QuerySqmImpl.class);
        SessionFactoryImplementor sessionFactory = hqlQuery.getSessionFactory();
        RowTransformer rowTransformer = this.determineRowTransformer((SqmSelectStatement)hqlQuery.getSqmStatement(), hqlQuery.getResultType(), (QueryOptions)hqlQuery.getQueryOptions());
        SharedSessionContractImplementor session = hqlQuery.getSession();
        JdbcServices jdbcServices = sessionFactory.getJdbcServices();
        JdbcEnvironment jdbcEnvironment = jdbcServices.getJdbcEnvironment();
        SqlAstTranslatorFactory sqlAstTranslatorFactory = jdbcEnvironment.getSqlAstTranslatorFactory();
        ArrayList<JdbcParameterBinder> parameterBinders = new ArrayList<JdbcParameterBinder>();
        HashSet affectedTableNames = new HashSet();
        HashSet filterJdbcParameters = new HashSet();
        JdbcParameterBindingsImpl jdbcParameterBindings = new JdbcParameterBindingsImpl(0);
        for (Query participatingQuery : participatingQueries) {
            final CacheableSqmInterpretation interpretation = HibernateExtendedQuerySupport.buildQueryPlan(participatingQuery);
            jdbcOperation = this.getJdbcOperation(sessionFactory, interpretation, (QuerySqmImpl)participatingQuery.unwrap(QuerySqmImpl.class));
            if (query == participatingQuery) {
                JdbcOperationQuerySelect select = (JdbcOperationQuerySelect)jdbcOperation;
                for (JdbcParameterBinder parameterBinder : jdbcOperation.getParameterBinders()) {
                    if (parameterBinder == select.getLimitParameter() || parameterBinder == select.getOffsetParameter()) continue;
                    parameterBinders.add(parameterBinder);
                }
            } else {
                parameterBinders.addAll(jdbcOperation.getParameterBinders());
            }
            affectedTableNames.addAll(jdbcOperation.getAffectedTableNames());
            filterJdbcParameters.addAll(jdbcOperation.getFilterJdbcParameters());
            Map jdbcParamsXref = SqmUtil.generateJdbcParamsXref((DomainParameterXref)interpretation.domainParameterXref, () -> interpretation.getSqmTranslation().getJdbcParamsBySqmParam());
            JdbcParameterBindings tempJdbcParameterBindings = SqmUtil.createJdbcParameterBindings((QueryParameterBindings)((QuerySqmImpl)participatingQuery.unwrap(QuerySqmImpl.class)).getQueryParameterBindings(), (DomainParameterXref)interpretation.domainParameterXref, (Map)jdbcParamsXref, (MappingMetamodel)session.getFactory().getRuntimeMetamodels().getMappingMetamodel(), arg_0 -> ((FromClauseAccess)interpretation.tableGroupAccess).findTableGroup(arg_0), (SqmParameterMappingModelResolutionAccess)new SqmParameterMappingModelResolutionAccess(){

                public <T> MappingModelExpressible<T> getResolvedMappingModelType(SqmParameter<T> parameter) {
                    return (MappingModelExpressible)interpretation.sqmTranslation.getSqmParameterMappingModelTypeResolutions().get(parameter);
                }
            }, (SharedSessionContractImplementor)session);
            if (tempJdbcParameterBindings.getBindings().isEmpty()) continue;
            tempJdbcParameterBindings.visitBindings((arg_0, arg_1) -> ((JdbcParameterBindings)jdbcParameterBindings).addBinding(arg_0, arg_1));
        }
        CacheableSqmInterpretation interpretation = HibernateExtendedQuerySupport.buildQueryPlan(query);
        JdbcOperationQuerySelect jdbcSelect = (JdbcOperationQuerySelect)sqlAstTranslatorFactory.buildSelectTranslator(sessionFactory, (SelectStatement)interpretation.getSqmTranslation().getSqlAst()).translate((JdbcParameterBindings)jdbcParameterBindings, executionContext.getQueryOptions());
        JdbcOperationQuerySelect realJdbcSelect = new JdbcOperationQuerySelect(sqlOverride, parameterBinders, jdbcSelect.getJdbcValuesMappingProducer(), affectedTableNames, filterJdbcParameters);
        session.autoFlushIfRequired(realJdbcSelect.getAffectedTableNames());
        try {
            jdbcOperation = session.getFactory().getJdbcServices().getJdbcSelectExecutor().list(realJdbcSelect, (JdbcParameterBindings)jdbcParameterBindings, (ExecutionContext)new SqmJdbcExecutionContextAdapter(executionContext, jdbcSelect){

                public String getQueryIdentifier(String sql) {
                    return sql;
                }

                public boolean hasQueryExecutionToBeAddedToStatistics() {
                    return true;
                }
            }, rowTransformer, ListResultsConsumer.UniqueSemantic.FILTER);
            return jdbcOperation;
        }
        catch (HibernateException e) {
            LOG.severe("Could not execute the following SQL query: " + sqlOverride);
            if (session.getFactory().getSessionFactoryOptions().isJpaBootstrap()) {
                throw session.getExceptionConverter().convert(e);
            }
            throw e;
        }
        finally {
            interpretation.domainParameterXref.clearExpansions();
        }
    }

    public Object getResultStream(ServiceProvider serviceProvider, List<Query> participatingQueries, Query query, String sqlOverride, boolean queryPlanCacheEnabled) {
        return this.getResultStream(serviceProvider, participatingQueries, query, sqlOverride, queryPlanCacheEnabled, (DomainQueryExecutionContext)query.unwrap(DomainQueryExecutionContext.class));
    }

    private Object getResultStream(ServiceProvider serviceProvider, List<Query> participatingQueries, Query query, String sqlOverride, boolean queryPlanCacheEnabled, DomainQueryExecutionContext executionContext) {
        QuerySqmImpl hqlQuery = (QuerySqmImpl)query.unwrap(QuerySqmImpl.class);
        SessionFactoryImplementor sessionFactory = hqlQuery.getSessionFactory();
        RowTransformer rowTransformer = this.determineRowTransformer((SqmSelectStatement)hqlQuery.getSqmStatement(), hqlQuery.getResultType(), (QueryOptions)hqlQuery.getQueryOptions());
        SharedSessionContractImplementor session = hqlQuery.getSession();
        JdbcServices jdbcServices = sessionFactory.getJdbcServices();
        JdbcEnvironment jdbcEnvironment = jdbcServices.getJdbcEnvironment();
        SqlAstTranslatorFactory sqlAstTranslatorFactory = jdbcEnvironment.getSqlAstTranslatorFactory();
        ArrayList parameterBinders = new ArrayList();
        HashSet affectedTableNames = new HashSet();
        HashSet filterJdbcParameters = new HashSet();
        JdbcParameterBindingsImpl jdbcParameterBindings = new JdbcParameterBindingsImpl(0);
        for (Query participatingQuery : participatingQueries) {
            final CacheableSqmInterpretation interpretation = HibernateExtendedQuerySupport.buildQueryPlan(participatingQuery);
            JdbcOperationQuery jdbcOperation = this.getJdbcOperation(sessionFactory, interpretation, (QuerySqmImpl)participatingQuery.unwrap(QuerySqmImpl.class));
            parameterBinders.addAll(jdbcOperation.getParameterBinders());
            affectedTableNames.addAll(jdbcOperation.getAffectedTableNames());
            filterJdbcParameters.addAll(jdbcOperation.getFilterJdbcParameters());
            Map jdbcParamsXref = SqmUtil.generateJdbcParamsXref((DomainParameterXref)interpretation.domainParameterXref, () -> interpretation.getSqmTranslation().getJdbcParamsBySqmParam());
            JdbcParameterBindings tempJdbcParameterBindings = SqmUtil.createJdbcParameterBindings((QueryParameterBindings)executionContext.getQueryParameterBindings(), (DomainParameterXref)interpretation.domainParameterXref, (Map)jdbcParamsXref, (MappingMetamodel)session.getFactory().getRuntimeMetamodels().getMappingMetamodel(), arg_0 -> ((FromClauseAccess)interpretation.tableGroupAccess).findTableGroup(arg_0), (SqmParameterMappingModelResolutionAccess)new SqmParameterMappingModelResolutionAccess(){

                public <T> MappingModelExpressible<T> getResolvedMappingModelType(SqmParameter<T> parameter) {
                    return (MappingModelExpressible)interpretation.sqmTranslation.getSqmParameterMappingModelTypeResolutions().get(parameter);
                }
            }, (SharedSessionContractImplementor)session);
            if (tempJdbcParameterBindings.getBindings().isEmpty()) continue;
            tempJdbcParameterBindings.visitBindings((arg_0, arg_1) -> ((JdbcParameterBindings)jdbcParameterBindings).addBinding(arg_0, arg_1));
        }
        CacheableSqmInterpretation interpretation = HibernateExtendedQuerySupport.buildQueryPlan(query);
        JdbcOperationQuerySelect jdbcSelect = (JdbcOperationQuerySelect)sqlAstTranslatorFactory.buildSelectTranslator(sessionFactory, (SelectStatement)interpretation.getSqmTranslation().getSqlAst()).translate((JdbcParameterBindings)jdbcParameterBindings, executionContext.getQueryOptions());
        JdbcOperationQuerySelect realJdbcSelect = new JdbcOperationQuerySelect(sqlOverride, parameterBinders, jdbcSelect.getJdbcValuesMappingProducer(), affectedTableNames, filterJdbcParameters);
        session.autoFlushIfRequired(realJdbcSelect.getAffectedTableNames());
        try {
            ScrollableResultsImplementor scrollableResults = session.getFactory().getJdbcServices().getJdbcSelectExecutor().scroll(realJdbcSelect, ScrollMode.FORWARD_ONLY, (JdbcParameterBindings)jdbcParameterBindings, (ExecutionContext)new SqmJdbcExecutionContextAdapter(executionContext, realJdbcSelect), rowTransformer);
            ScrollableResultsIterator iterator = new ScrollableResultsIterator(scrollableResults);
            Spliterator spliterator = Spliterators.spliteratorUnknownSize(iterator, 256);
            Stream stream = StreamSupport.stream(spliterator, false);
            Object s = stream.onClose(() -> ((ScrollableResultsImplementor)scrollableResults).close());
            return s;
        }
        catch (HibernateException e) {
            LOG.severe("Could not execute the following SQL query: " + sqlOverride);
            if (session.getFactory().getSessionFactoryOptions().isJpaBootstrap()) {
                throw session.getExceptionConverter().convert(e);
            }
            throw e;
        }
        finally {
            interpretation.domainParameterXref.clearExpansions();
        }
    }

    public Object getSingleResult(ServiceProvider serviceProvider, List<Query> participatingQueries, Query query, String sqlOverride, boolean queryPlanCacheEnabled) {
        List list = this.getResultList(serviceProvider, participatingQueries, query, sqlOverride, queryPlanCacheEnabled);
        if (list.size() == 0) {
            throw new NoResultException("No entity found for query");
        }
        return HibernateExtendedQuerySupport.uniqueElement(list);
    }

    private static <R> R uniqueElement(List<R> list) throws NonUniqueResultException {
        int size = list.size();
        if (size == 0) {
            return null;
        }
        R first = list.get(0);
        for (int i = 1; i < size; ++i) {
            if (list.get(i) == first) continue;
            throw new NonUniqueResultException(list.size());
        }
        return first;
    }

    private <R> RowTransformer<R> determineRowTransformer(SqmSelectStatement<?> sqm, Class<R> resultType, QueryOptions queryOptions) {
        if (resultType == null || resultType.isArray()) {
            if (queryOptions.getTupleTransformer() != null) {
                return this.makeRowTransformerTupleTransformerAdapter(sqm, queryOptions);
            }
            return ROW_TRANSFORMER_STANDARD;
        }
        List selections = sqm.getQueryPart().getFirstQuerySpec().getSelectClause().getSelections();
        if (Tuple.class.isAssignableFrom(resultType)) {
            if (queryOptions.getTupleTransformer() == null) {
                return new RowTransformerJpaTupleImpl(this.buildTupleMetadata(selections));
            }
            throw new IllegalArgumentException("Illegal combination of Tuple resultType and (non-JpaTupleBuilder) TupleTransformer : " + queryOptions.getTupleTransformer());
        }
        if (queryOptions.getTupleTransformer() != null) {
            return this.makeRowTransformerTupleTransformerAdapter(sqm, queryOptions);
        }
        if (selections.size() > 1) {
            throw new IllegalQueryOperationException("Query defined multiple selections, return cannot be typed (other that Object[] or Tuple)");
        }
        return ROW_TRANSFORMER_SINGULAR_RETURN;
    }

    private TupleMetadata buildTupleMetadata(List<SqmSelection<?>> selections) {
        try {
            IdentityHashMap<Object, Integer> tupleElementMap;
            if (TUPLE_METADATA_CONSTRUCTOR_63 != null) {
                return TUPLE_METADATA_CONSTRUCTOR_63.newInstance(HibernateExtendedQuerySupport.buildTupleElementArray(selections), HibernateExtendedQuerySupport.buildTupleAliasArray(selections));
            }
            if (selections.size() == 1 && selections.get(0).getSelectableNode() instanceof CompoundSelection) {
                List selectionItems = selections.get(0).getSelectableNode().getSelectionItems();
                tupleElementMap = new IdentityHashMap(selectionItems.size());
                for (int i = 0; i < selectionItems.size(); ++i) {
                    tupleElementMap.put((TupleElement)selectionItems.get(i), i);
                }
            } else {
                tupleElementMap = new IdentityHashMap<Object, Integer>(selections.size());
                for (int i = 0; i < selections.size(); ++i) {
                    SqmSelection<?> selection = selections.get(i);
                    tupleElementMap.put(selection.getSelectableNode(), i);
                }
            }
            return TUPLE_METADATA_CONSTRUCTOR_62.newInstance(tupleElementMap);
        }
        catch (IllegalAccessException | InstantiationException e) {
            throw new RuntimeException("Could not construct TupleMetadata. Please report your version of hibernate so we can provide support for it!", e);
        }
        catch (InvocationTargetException e) {
            if (e.getTargetException() instanceof RuntimeException) {
                throw (RuntimeException)e.getTargetException();
            }
            throw new RuntimeException("Could not construct TupleMetadata.", e);
        }
    }

    private static TupleElement<?>[] buildTupleElementArray(List<SqmSelection<?>> selections) {
        if (selections.size() == 1) {
            SqmSelectableNode selectableNode = selections.get(0).getSelectableNode();
            if (selectableNode instanceof CompoundSelection) {
                List selectionItems = selectableNode.getSelectionItems();
                TupleElement[] elements = new TupleElement[selectionItems.size()];
                for (int i = 0; i < selectionItems.size(); ++i) {
                    elements[i] = (TupleElement)selectionItems.get(i);
                }
                return elements;
            }
            return new TupleElement[]{selectableNode};
        }
        TupleElement[] elements = new TupleElement[selections.size()];
        for (int i = 0; i < selections.size(); ++i) {
            elements[i] = selections.get(i).getSelectableNode();
        }
        return elements;
    }

    private static String[] buildTupleAliasArray(List<SqmSelection<?>> selections) {
        if (selections.size() == 1) {
            SqmSelectableNode selectableNode = selections.get(0).getSelectableNode();
            if (selectableNode instanceof CompoundSelection) {
                List selectionItems = selectableNode.getSelectionItems();
                String[] elements = new String[selectionItems.size()];
                for (int i = 0; i < selectionItems.size(); ++i) {
                    elements[i] = ((JpaSelection)selectionItems.get(i)).getAlias();
                }
                return elements;
            }
            return new String[]{selectableNode.getAlias()};
        }
        String[] elements = new String[selections.size()];
        for (int i = 0; i < selections.size(); ++i) {
            elements[i] = selections.get(i).getAlias();
        }
        return elements;
    }

    private <R> RowTransformer<R> makeRowTransformerTupleTransformerAdapter(SqmSelectStatement<?> sqm, QueryOptions queryOptions) {
        ArrayList<String> aliases = new ArrayList<String>();
        for (SqmSelection sqmSelection : sqm.getQuerySpec().getSelectClause().getSelections()) {
            if (sqmSelection.getSelectableNode() instanceof SqmDynamicInstantiation) {
                aliases.add(sqmSelection.getAlias());
                continue;
            }
            sqmSelection.getSelectableNode().visitSubSelectableNodes(subSelection -> aliases.add(subSelection.getAlias()));
        }
        TupleTransformer tupleTransformer = queryOptions.getTupleTransformer();
        return new RowTransformerTupleTransformerAdapter(ArrayHelper.toStringArray(aliases), tupleTransformer);
    }

    public int executeUpdate(ServiceProvider serviceProvider, List<Query> participatingQueries, Query baseQuery, Query query, String finalSql, boolean queryPlanCacheEnabled) {
        JdbcOperationQueryUpdate realJdbcStatement;
        CacheableSqmInterpretation interpretation;
        EntityManager em = (EntityManager)serviceProvider.getService(EntityManager.class);
        SessionImplementor session = (SessionImplementor)em.unwrap(SessionImplementor.class);
        if (session.isClosed()) {
            throw new PersistenceException("Entity manager is closed!");
        }
        SessionFactoryImplementor sessionFactory = session.getSessionFactory();
        ArrayList parameterBinders = new ArrayList();
        HashSet affectedTableNames = new HashSet();
        HashSet filterJdbcParameters = new HashSet();
        JdbcParameterBindingsImpl jdbcParameterBindings = new JdbcParameterBindingsImpl(0);
        for (Query participatingQuery : participatingQueries) {
            interpretation = HibernateExtendedQuerySupport.buildQueryPlan(participatingQuery);
            JdbcOperationQuery jdbcOperation = this.getJdbcOperation(sessionFactory, interpretation, (QuerySqmImpl)participatingQuery.unwrap(QuerySqmImpl.class));
            parameterBinders.addAll(jdbcOperation.getParameterBinders());
            affectedTableNames.addAll(jdbcOperation.getAffectedTableNames());
            filterJdbcParameters.addAll(jdbcOperation.getFilterJdbcParameters());
            Map jdbcParamsXref = SqmUtil.generateJdbcParamsXref((DomainParameterXref)interpretation.domainParameterXref, () -> interpretation.getSqmTranslation().getJdbcParamsBySqmParam());
            JdbcParameterBindings tempJdbcParameterBindings = SqmUtil.createJdbcParameterBindings((QueryParameterBindings)((DomainQueryExecutionContext)participatingQuery.unwrap(DomainQueryExecutionContext.class)).getQueryParameterBindings(), (DomainParameterXref)interpretation.domainParameterXref, (Map)jdbcParamsXref, (MappingMetamodel)session.getFactory().getRuntimeMetamodels().getMappingMetamodel(), arg_0 -> ((FromClauseAccess)interpretation.tableGroupAccess).findTableGroup(arg_0), (SqmParameterMappingModelResolutionAccess)new SqmParameterMappingModelResolutionAccess(){

                public <T> MappingModelExpressible<T> getResolvedMappingModelType(SqmParameter<T> parameter) {
                    return (MappingModelExpressible)interpretation.sqmTranslation.getSqmParameterMappingModelTypeResolutions().get(parameter);
                }
            }, (SharedSessionContractImplementor)session);
            if (tempJdbcParameterBindings.getBindings().isEmpty()) continue;
            tempJdbcParameterBindings.visitBindings((arg_0, arg_1) -> ((JdbcParameterBindings)jdbcParameterBindings).addBinding(arg_0, arg_1));
        }
        QuerySqmImpl hqlQuery = (QuerySqmImpl)query.unwrap(QuerySqmImpl.class);
        SqmStatement sqmStatement = hqlQuery.getSqmStatement();
        interpretation = HibernateExtendedQuerySupport.buildQueryPlan(query);
        if (sqmStatement instanceof SqmUpdateStatement) {
            realJdbcStatement = new JdbcOperationQueryUpdate(finalSql, parameterBinders, affectedTableNames, filterJdbcParameters, Collections.emptyMap());
        } else if (sqmStatement instanceof SqmDeleteStatement) {
            realJdbcStatement = new JdbcOperationQueryUpdate(finalSql, parameterBinders, affectedTableNames, filterJdbcParameters, Collections.emptyMap());
        } else if (sqmStatement instanceof SqmInsertSelectStatement) {
            realJdbcStatement = new JdbcOperationQueryUpdate(finalSql, parameterBinders, affectedTableNames, filterJdbcParameters, Collections.emptyMap());
        } else {
            throw new IllegalArgumentException("Unsupported sqm statement: " + sqmStatement);
        }
        session.autoFlushIfRequired(realJdbcStatement.getAffectedTableNames());
        Function<String, PreparedStatement> statementCreator = sql -> session.getJdbcCoordinator().getStatementPreparer().prepareStatement(sql);
        BiConsumer<Integer, PreparedStatement> expectationCheck = (integer, preparedStatement) -> {};
        try {
            int n = session.getFactory().getJdbcServices().getJdbcMutationExecutor().execute((JdbcOperationQueryMutation)realJdbcStatement, (JdbcParameterBindings)jdbcParameterBindings, statementCreator, expectationCheck, (ExecutionContext)SqmJdbcExecutionContextAdapter.usingLockingAndPaging((DomainQueryExecutionContext)((DomainQueryExecutionContext)query.unwrap(DomainQueryExecutionContext.class))));
            return n;
        }
        catch (HibernateException e) {
            LOG.severe("Could not execute the following SQL query: " + finalSql);
            if (session.getFactory().getSessionFactoryOptions().isJpaBootstrap()) {
                throw session.getExceptionConverter().convert(e);
            }
            throw e;
        }
        finally {
            interpretation.domainParameterXref.clearExpansions();
        }
    }

    public ReturningResult<Object[]> executeReturning(ServiceProvider serviceProvider, List<Query> participatingQueries, Query modificationBaseQuery, Query exampleQuery, String sqlOverride, boolean queryPlanCacheEnabled) {
        DbmsDialect dbmsDialect = (DbmsDialect)serviceProvider.getService(DbmsDialect.class);
        EntityManager em = (EntityManager)serviceProvider.getService(EntityManager.class);
        SessionImplementor session = (SessionImplementor)em.unwrap(SessionImplementor.class);
        if (session.isClosed()) {
            throw new PersistenceException("Entity manager is closed!");
        }
        SessionFactoryImplementor sessionFactory = session.getSessionFactory();
        JdbcServices jdbcServices = sessionFactory.getJdbcServices();
        JdbcEnvironment jdbcEnvironment = jdbcServices.getJdbcEnvironment();
        SqlAstTranslatorFactory sqlAstTranslatorFactory = jdbcEnvironment.getSqlAstTranslatorFactory();
        ArrayList parameterBinders = new ArrayList();
        HashSet affectedTableNames = new HashSet();
        HashSet filterJdbcParameters = new HashSet();
        JdbcParameterBindingsImpl jdbcParameterBindings = new JdbcParameterBindingsImpl(0);
        for (Query participatingQuery : participatingQueries) {
            final CacheableSqmInterpretation interpretation = HibernateExtendedQuerySupport.buildQueryPlan(participatingQuery);
            JdbcOperationQuery jdbcOperation = this.getJdbcOperation(sessionFactory, interpretation, (QuerySqmImpl)participatingQuery.unwrap(QuerySqmImpl.class));
            if (participatingQuery != exampleQuery) {
                parameterBinders.addAll(jdbcOperation.getParameterBinders());
            }
            affectedTableNames.addAll(jdbcOperation.getAffectedTableNames());
            filterJdbcParameters.addAll(jdbcOperation.getFilterJdbcParameters());
            Map jdbcParamsXref = SqmUtil.generateJdbcParamsXref((DomainParameterXref)interpretation.domainParameterXref, () -> interpretation.getSqmTranslation().getJdbcParamsBySqmParam());
            JdbcParameterBindings tempJdbcParameterBindings = SqmUtil.createJdbcParameterBindings((QueryParameterBindings)((DomainQueryExecutionContext)participatingQuery.unwrap(DomainQueryExecutionContext.class)).getQueryParameterBindings(), (DomainParameterXref)interpretation.domainParameterXref, (Map)jdbcParamsXref, (MappingMetamodel)session.getFactory().getRuntimeMetamodels().getMappingMetamodel(), arg_0 -> ((FromClauseAccess)interpretation.tableGroupAccess).findTableGroup(arg_0), (SqmParameterMappingModelResolutionAccess)new SqmParameterMappingModelResolutionAccess(){

                public <T> MappingModelExpressible<T> getResolvedMappingModelType(SqmParameter<T> parameter) {
                    return (MappingModelExpressible)interpretation.sqmTranslation.getSqmParameterMappingModelTypeResolutions().get(parameter);
                }
            }, (SharedSessionContractImplementor)session);
            if (tempJdbcParameterBindings.getBindings().isEmpty()) continue;
            tempJdbcParameterBindings.visitBindings((arg_0, arg_1) -> ((JdbcParameterBindings)jdbcParameterBindings).addBinding(arg_0, arg_1));
        }
        JdbcOperationQuerySelect exampleQueryJdbcOperation = (JdbcOperationQuerySelect)this.getJdbcOperation(exampleQuery);
        StringBuilder sqlSb = new StringBuilder(sqlOverride.length() + 100);
        sqlSb.append(sqlOverride);
        int[] returningColumnTypes = dbmsDialect.needsReturningSqlTypes() ? HibernateExtendedQuerySupport.getReturningColumnTypes(exampleQueryJdbcOperation, sessionFactory) : null;
        boolean caseInsensitive = Boolean.valueOf(((ConfigurationSource)serviceProvider.getService(ConfigurationSource.class)).getProperty("com.blazebit.persistence.returning_clause_case_sensitive")) == false;
        String[][] returningColumns = HibernateExtendedQuerySupport.getReturningColumns(caseInsensitive, exampleQueryJdbcOperation.getSqlString());
        String finalSql = sqlSb.toString();
        try {
            HibernateReturningResult<Object[]> returningResult = new HibernateReturningResult<Object[]>();
            List results = Collections.EMPTY_LIST;
            boolean success = false;
            CacheableSqmInterpretation interpretation = HibernateExtendedQuerySupport.buildQueryPlan(exampleQuery);
            DomainQueryExecutionContext domainQueryExecutionContext = (DomainQueryExecutionContext)exampleQuery.unwrap(DomainQueryExecutionContext.class);
            JdbcOperationQuerySelect jdbcSelect = (JdbcOperationQuerySelect)sqlAstTranslatorFactory.buildSelectTranslator(sessionFactory, (SelectStatement)interpretation.getSqmTranslation().getSqlAst()).translate((JdbcParameterBindings)jdbcParameterBindings, domainQueryExecutionContext.getQueryOptions());
            JdbcOperationQuerySelect realJdbcSelect = new JdbcOperationQuerySelect(sqlOverride, parameterBinders, jdbcSelect.getJdbcValuesMappingProducer(), affectedTableNames, jdbcSelect.getRowsToSkip(), jdbcSelect.getMaxRows(), (Map)HibernateExtendedQuerySupport.getField(jdbcSelect, "appliedParameters"), jdbcSelect.getLockStrategy(), jdbcSelect.getOffsetParameter(), jdbcSelect.getLimitParameter());
            SqmJdbcExecutionContextAdapter executionContext = new SqmJdbcExecutionContextAdapter(domainQueryExecutionContext, realJdbcSelect){

                public String getQueryIdentifier(String sql) {
                    return sql;
                }

                public boolean hasQueryExecutionToBeAddedToStatistics() {
                    return true;
                }
            };
            session.autoFlushIfRequired(realJdbcSelect.getAffectedTableNames());
            try {
                SubselectFetch.RegistrationHandler subSelectFetchKeyHandler = SubselectFetch.createRegistrationHandler((BatchFetchQueue)session.getPersistenceContext().getBatchFetchQueue(), (SelectStatement)((SelectStatement)interpretation.sqmTranslation.getSqlAst()), (JdbcParametersList)JdbcParametersList.empty(), (JdbcParameterBindings)jdbcParameterBindings);
                results = session.getFactory().getJdbcServices().getJdbcSelectExecutor().list(realJdbcSelect, (JdbcParameterBindings)jdbcParameterBindings, this.hibernateAccess.wrapExecutionContext((ExecutionContext)executionContext, dbmsDialect, returningColumns, returningColumnTypes, returningResult), ROW_TRANSFORMER_STANDARD, ListResultsConsumer.UniqueSemantic.FILTER);
            }
            catch (HibernateException e) {
                LOG.severe("Could not execute the following SQL query: " + sqlOverride);
                if (session.getFactory().getSessionFactoryOptions().isJpaBootstrap()) {
                    throw session.getExceptionConverter().convert(e);
                }
                throw e;
            }
            finally {
                interpretation.domainParameterXref.clearExpansions();
            }
            returningResult.setResultList(results);
            return returningResult;
        }
        catch (Exception e1) {
            throw new RuntimeException(e1);
        }
    }

    private static String[][] getReturningColumns(boolean caseInsensitive, String exampleQuerySql) {
        int fromIndex = exampleQuerySql.indexOf("from");
        int selectIndex = exampleQuerySql.indexOf("select");
        String[] selectItems = HibernateExtendedQuerySupport.splitSelectItems(exampleQuerySql.subSequence(selectIndex + "select".length() + 1, fromIndex));
        String[][] returningColumns = new String[selectItems.length][2];
        for (int i = 0; i < selectItems.length; ++i) {
            String columnName = selectItems[i].substring(selectItems[i].lastIndexOf(46) + 1);
            if (caseInsensitive) {
                returningColumns[i][0] = columnName.toLowerCase();
                returningColumns[i][1] = columnName.toLowerCase();
                continue;
            }
            returningColumns[i][0] = columnName;
            returningColumns[i][1] = columnName;
        }
        return returningColumns;
    }

    private static String[] splitSelectItems(CharSequence itemsString) {
        ArrayList<String> selectItems = new ArrayList<String>();
        StringBuilder sb = new StringBuilder();
        int parenthesis = 0;
        boolean text = false;
        int i = 0;
        int length = itemsString.length();
        while (i < length) {
            char c = itemsString.charAt(i);
            if (text) {
                if (c == '(') {
                    ++parenthesis;
                } else if (c == ')') {
                    --parenthesis;
                } else if (parenthesis == 0 && c == ',') {
                    selectItems.add(HibernateExtendedQuerySupport.trim(sb));
                    sb.setLength(0);
                    text = false;
                    ++i;
                    continue;
                }
                sb.append(c);
            } else if (!Character.isWhitespace(c)) {
                sb.append(c);
                text = true;
            }
            ++i;
        }
        if (text) {
            selectItems.add(HibernateExtendedQuerySupport.trim(sb));
        }
        return selectItems.toArray(new String[selectItems.size()]);
    }

    private static String trim(StringBuilder sb) {
        int i;
        for (i = sb.length() - 1; i >= 0 && Character.isWhitespace(sb.charAt(i)); --i) {
        }
        return sb.substring(0, i + 1);
    }

    private static int[] getReturningColumnTypes(JdbcOperationQuerySelect queryPlan, SessionFactoryImplementor sfi) {
        JdbcValuesMapping jdbcValuesMapping = queryPlan.getJdbcValuesMappingProducer().resolve(null, null, sfi);
        List sqlSelections = jdbcValuesMapping.getSqlSelections();
        ArrayList<Integer> sqlTypes = new ArrayList<Integer>(sqlSelections.size());
        for (int i = 0; i < sqlSelections.size(); ++i) {
            sqlTypes.add(((SqlSelection)sqlSelections.get(i)).getExpressionType().getSingleJdbcMapping().getJdbcType().getDefaultSqlTypeCode());
        }
        int[] returningColumnTypes = new int[sqlTypes.size()];
        for (int i = 0; i < sqlTypes.size(); ++i) {
            returningColumnTypes[i] = (Integer)sqlTypes.get(i);
        }
        return returningColumnTypes;
    }

    private JdbcOperationQuery getJdbcOperation(Query query) {
        QuerySqmImpl hqlQuery = (QuerySqmImpl)query.unwrap(QuerySqmImpl.class);
        SessionFactoryImplementor factory = hqlQuery.getSessionFactory();
        return this.getJdbcOperation(factory, HibernateExtendedQuerySupport.buildQueryPlan(query), hqlQuery);
    }

    private JdbcOperationQuery getJdbcOperation(SessionFactoryImplementor factory, final CacheableSqmInterpretation interpretation, QuerySqmImpl<?> query) {
        JdbcEnvironment jdbcEnvironment = factory.getJdbcServices().getJdbcEnvironment();
        SqlAstTranslatorFactory sqlAstTranslatorFactory = jdbcEnvironment.getSqlAstTranslatorFactory();
        SqmTranslation<?> sqmTranslation = interpretation.getSqmTranslation();
        Statement sqlAst = sqmTranslation.getSqlAst();
        Map jdbcParamsXref = SqmUtil.generateJdbcParamsXref((DomainParameterXref)interpretation.domainParameterXref, () -> interpretation.getSqmTranslation().getJdbcParamsBySqmParam());
        JdbcParameterBindings jdbcParameterBindings = SqmUtil.createJdbcParameterBindings((QueryParameterBindings)query.getQueryParameterBindings(), (DomainParameterXref)interpretation.domainParameterXref, (Map)jdbcParamsXref, (MappingMetamodel)factory.getRuntimeMetamodels().getMappingMetamodel(), arg_0 -> ((FromClauseAccess)interpretation.tableGroupAccess).findTableGroup(arg_0), (SqmParameterMappingModelResolutionAccess)new SqmParameterMappingModelResolutionAccess(){

            public <T> MappingModelExpressible<T> getResolvedMappingModelType(SqmParameter<T> parameter) {
                return (MappingModelExpressible)interpretation.sqmTranslation.getSqmParameterMappingModelTypeResolutions().get(parameter);
            }
        }, (SharedSessionContractImplementor)query.getSession());
        if (sqlAst instanceof SelectStatement) {
            SqlAstTranslator translator = sqlAstTranslatorFactory.buildSelectTranslator(factory, (SelectStatement)sqlAst);
            return (JdbcOperationQuery)translator.translate(jdbcParameterBindings, (QueryOptions)query.getQueryOptions());
        }
        if (sqlAst instanceof DeleteStatement) {
            SqlAstTranslator translator = sqlAstTranslatorFactory.buildDeleteTranslator(factory, (DeleteStatement)sqlAst);
            return (JdbcOperationQuery)translator.translate(jdbcParameterBindings, (QueryOptions)query.getQueryOptions());
        }
        if (sqlAst instanceof UpdateStatement) {
            SqlAstTranslator translator = sqlAstTranslatorFactory.buildUpdateTranslator(factory, (UpdateStatement)sqlAst);
            return (JdbcOperationQuery)translator.translate(jdbcParameterBindings, (QueryOptions)query.getQueryOptions());
        }
        if (sqlAst instanceof InsertStatement) {
            SqlAstTranslator translator = sqlAstTranslatorFactory.buildInsertTranslator(factory, (InsertStatement)sqlAst);
            return (JdbcOperationQuery)translator.translate(jdbcParameterBindings, (QueryOptions)query.getQueryOptions());
        }
        throw new UnsupportedOperationException();
    }

    private static CacheableSqmInterpretation buildQueryPlan(Query query) {
        QuerySqmImpl hqlQuery = (QuerySqmImpl)query.unwrap(QuerySqmImpl.class);
        if (hqlQuery.getSqmStatement() instanceof SqmSelectStatement) {
            SharedSessionContractImplementor session = hqlQuery.getSession();
            SessionFactoryImplementor sessionFactory = session.getFactory();
            SqmInterpretationsKey cacheKey = SqmInterpretationsKey.createInterpretationsKey((SqmInterpretationsKey.InterpretationsKeySource)hqlQuery);
            SqmTranslatorFactory sqmTranslatorFactory = HibernateAccessUtils.getSqmTranslatorFactory(sessionFactory);
            SqmTranslator sqmConverter = sqmTranslatorFactory.createSelectTranslator((SqmSelectStatement)hqlQuery.getSqmStatement(), (QueryOptions)hqlQuery.getQueryOptions(), hqlQuery.getDomainParameterXref(), hqlQuery.getQueryParameterBindings(), hqlQuery.getLoadQueryInfluencers(), (SqlAstCreationContext)sessionFactory, false);
            SqmTranslation interpretation = sqmConverter.translate();
            return new CacheableSqmInterpretation(interpretation, sqmConverter.getFromClauseAccess(), hqlQuery.getDomainParameterXref());
        }
        if (hqlQuery.getSqmStatement() instanceof SqmInsertSelectStatement) {
            SharedSessionContractImplementor session = hqlQuery.getSession();
            SessionFactoryImplementor sessionFactory = session.getFactory();
            SqmInterpretationsKey cacheKey = SqmInterpretationsKey.createInterpretationsKey((SqmInterpretationsKey.InterpretationsKeySource)hqlQuery);
            SqmTranslatorFactory sqmTranslatorFactory = HibernateAccessUtils.getSqmTranslatorFactory(sessionFactory);
            SqmTranslator sqmConverter = sqmTranslatorFactory.createInsertTranslator((SqmInsertStatement)((SqmInsertSelectStatement)hqlQuery.getSqmStatement()), (QueryOptions)hqlQuery.getQueryOptions(), hqlQuery.getDomainParameterXref(), hqlQuery.getQueryParameterBindings(), hqlQuery.getLoadQueryInfluencers(), (SqlAstCreationContext)sessionFactory);
            SqmTranslation interpretation = sqmConverter.translate();
            return new CacheableSqmInterpretation(interpretation, sqmConverter.getFromClauseAccess(), hqlQuery.getDomainParameterXref());
        }
        NonSelectQueryPlan nonSelectQueryPlan = (NonSelectQueryPlan)HibernateExtendedQuerySupport.invokeMethod(hqlQuery, "resolveNonSelectQueryPlan", new Object[0]);
        if (nonSelectQueryPlan instanceof SimpleDeleteQueryPlan) {
            SqmDeleteStatement sqmDelete = (SqmDeleteStatement)HibernateExtendedQuerySupport.getField(nonSelectQueryPlan, "sqmDelete");
            SessionFactoryImplementor factory = hqlQuery.getSessionFactory();
            SqmTranslatorFactory translatorFactory = HibernateAccessUtils.getSqmTranslatorFactory(factory);
            SqmTranslator translator = translatorFactory.createSimpleDeleteTranslator(sqmDelete, (QueryOptions)hqlQuery.getQueryOptions(), hqlQuery.getDomainParameterXref(), hqlQuery.getQueryParameterBindings(), hqlQuery.getLoadQueryInfluencers(), (SqlAstCreationContext)factory);
            SqmTranslation sqmInterpretation = translator.translate();
            return new CacheableSqmInterpretation(sqmInterpretation, translator.getFromClauseAccess(), hqlQuery.getDomainParameterXref());
        }
        if (nonSelectQueryPlan instanceof SimpleUpdateQueryPlan) {
            SqmUpdateStatement sqmUpdate = (SqmUpdateStatement)HibernateExtendedQuerySupport.getField(nonSelectQueryPlan, "sqmUpdate");
            SessionFactoryImplementor factory = hqlQuery.getSessionFactory();
            SqmTranslatorFactory translatorFactory = HibernateAccessUtils.getSqmTranslatorFactory(factory);
            SqmTranslator translator = translatorFactory.createSimpleUpdateTranslator(sqmUpdate, (QueryOptions)hqlQuery.getQueryOptions(), hqlQuery.getDomainParameterXref(), hqlQuery.getQueryParameterBindings(), hqlQuery.getLoadQueryInfluencers(), (SqlAstCreationContext)factory);
            SqmTranslation sqmInterpretation = translator.translate();
            return new CacheableSqmInterpretation(sqmInterpretation, translator.getFromClauseAccess(), hqlQuery.getDomainParameterXref());
        }
        if (nonSelectQueryPlan instanceof MultiTableDeleteQueryPlan || nonSelectQueryPlan instanceof MultiTableUpdateQueryPlan) {
            // empty if block
        }
        throw new UnsupportedOperationException("not yet implemented");
    }

    private static CacheableSqmInterpretation buildQuerySpecPlan(Query query) {
        QuerySqmImpl hqlQuery = (QuerySqmImpl)query.unwrap(QuerySqmImpl.class);
        SharedSessionContractImplementor session = hqlQuery.getSession();
        SessionFactoryImplementor sessionFactory = session.getFactory();
        SqmTranslatorFactory sqmTranslatorFactory = HibernateAccessUtils.getSqmTranslatorFactory(sessionFactory);
        if (hqlQuery.getSqmStatement() instanceof SqmSelectStatement) {
            SqmTranslator sqmConverter = sqmTranslatorFactory.createSelectTranslator((SqmSelectStatement)hqlQuery.getSqmStatement(), (QueryOptions)hqlQuery.getQueryOptions(), hqlQuery.getDomainParameterXref(), hqlQuery.getQueryParameterBindings(), hqlQuery.getLoadQueryInfluencers(), (SqlAstCreationContext)sessionFactory, false);
            SqmTranslation interpretation = sqmConverter.translate();
            return new CacheableSqmInterpretation(interpretation, sqmConverter.getFromClauseAccess(), hqlQuery.getDomainParameterXref());
        }
        if (hqlQuery.getSqmStatement() instanceof SqmInsertSelectStatement) {
            SqmTranslator sqmConverter = sqmTranslatorFactory.createInsertTranslator((SqmInsertStatement)hqlQuery.getSqmStatement(), (QueryOptions)hqlQuery.getQueryOptions(), hqlQuery.getDomainParameterXref(), hqlQuery.getQueryParameterBindings(), hqlQuery.getLoadQueryInfluencers(), (SqlAstCreationContext)sessionFactory);
            SqmTranslation interpretation = sqmConverter.translate();
            return new CacheableSqmInterpretation(interpretation, sqmConverter.getFromClauseAccess(), hqlQuery.getDomainParameterXref());
        }
        throw new IllegalArgumentException("Only supported for insert or select!");
    }

    private static CacheableSqmInterpretation buildCacheableSqmInterpretation(SqmSelectStatement sqm, DomainParameterXref domainParameterXref, ExecutionContext executionContext) {
        SharedSessionContractImplementor session = executionContext.getSession();
        SessionFactoryImplementor sessionFactory = session.getFactory();
        SqmTranslatorFactory sqmTranslatorFactory = HibernateAccessUtils.getSqmTranslatorFactory(sessionFactory);
        SqmTranslator sqmConverter = sqmTranslatorFactory.createSelectTranslator(sqm, executionContext.getQueryOptions(), domainParameterXref, executionContext.getQueryParameterBindings(), executionContext.getLoadQueryInfluencers(), (SqlAstCreationContext)sessionFactory, false);
        FromClauseAccess tableGroupAccess = sqmConverter.getFromClauseAccess();
        SqmTranslation interpretation = sqmConverter.translate();
        return new CacheableSqmInterpretation(interpretation, tableGroupAccess, domainParameterXref);
    }

    private static <T> T invokeMethod(Object object, String method, Object ... args) {
        try {
            if (args.length == 0) {
                Method m = object.getClass().getDeclaredMethod(method, new Class[0]);
                m.setAccessible(true);
                return (T)m.invoke(object, new Object[0]);
            }
            for (Method m : object.getClass().getDeclaredMethods()) {
                if (!method.equals(m.getName())) continue;
                m.setAccessible(true);
                return (T)m.invoke(object, args);
            }
            object.getClass().getDeclaredMethod(method, new Class[0]);
            return null;
        }
        catch (Exception e1) {
            throw new RuntimeException(e1);
        }
    }

    private static <T> T getField(Object object, String field) {
        try {
            Field f = ReflectionUtils.getField(object.getClass(), (String)field);
            f.setAccessible(true);
            return (T)f.get(object);
        }
        catch (Exception e1) {
            throw new RuntimeException(e1);
        }
    }

    private static void setField(Object object, String field, Object value) {
        HibernateExtendedQuerySupport.setField(object, object.getClass(), field, value);
    }

    private static void setField(Object object, Class<?> clazz, String field, Object value) {
        try {
            Field f = ReflectionUtils.getField(clazz, (String)field);
            f.setAccessible(true);
            f.set(object, value);
        }
        catch (Exception e1) {
            throw new RuntimeException(e1);
        }
    }

    static {
        Constructor constructor62 = null;
        Constructor constructor63 = null;
        try {
            constructor63 = TupleMetadata.class.getConstructor(TupleElement[].class, String[].class);
        }
        catch (NoSuchMethodException ex1) {
            try {
                constructor62 = TupleMetadata.class.getConstructor(Map.class);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                // empty catch block
            }
        }
        if (constructor62 == null && constructor63 == null) {
            throw new RuntimeException("Could not find constructor for TupleMetadata. Please report your version of hibernate so we can provide support for it!");
        }
        TUPLE_METADATA_CONSTRUCTOR_62 = constructor62;
        TUPLE_METADATA_CONSTRUCTOR_63 = constructor63;
        try {
            ROW_TRANSFORMER_SINGULAR_RETURN = (RowTransformer)RowTransformerSingularReturnImpl.class.getField("INSTANCE").get(null);
            ROW_TRANSFORMER_STANDARD = (RowTransformer)RowTransformerStandardImpl.class.getField("INSTANCE").get(null);
        }
        catch (IllegalAccessException | NoSuchFieldException ex) {
            throw new RuntimeException("Could not find standard row transformers. Please report your version of hibernate so we can provide support for it!", ex);
        }
    }

    private static class CacheableSqmInterpretation {
        private final SqmTranslation<?> sqmTranslation;
        private final FromClauseAccess tableGroupAccess;
        private final DomainParameterXref domainParameterXref;

        CacheableSqmInterpretation(SqmTranslation<?> sqmTranslation, FromClauseAccess tableGroupAccess, DomainParameterXref domainParameterXref) {
            this.sqmTranslation = sqmTranslation;
            this.tableGroupAccess = tableGroupAccess;
            this.domainParameterXref = domainParameterXref;
        }

        SqmTranslation<?> getSqmTranslation() {
            return this.sqmTranslation;
        }

        FromClauseAccess getTableGroupAccess() {
            return this.tableGroupAccess;
        }

        DomainParameterXref getDomainParameterXref() {
            return this.domainParameterXref;
        }
    }
}

