/*
 * Decompiled with CFR 0.152.
 */
package com.blazebit.persistence.integration.view.spring.impl;

import com.blazebit.persistence.integration.view.spring.impl.SpringTransactionSupport;
import com.blazebit.persistence.view.EntityViews;
import com.blazebit.persistence.view.spi.EntityViewConfiguration;
import com.blazebit.persistence.view.spi.TransactionSupport;
import java.util.Set;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.transaction.PlatformTransactionManager;

@Configuration
public class EntityViewConfigurationProducer {
    private final EntityViewConfiguration configuration = EntityViews.createDefaultConfiguration();
    private PlatformTransactionManager tm;

    public EntityViewConfigurationProducer(Set<Class<?>> entityViewClasses, Set<Class<?>> entityViewListenerClasses) {
        for (Class<?> entityViewClass : entityViewClasses) {
            this.configuration.addEntityView(entityViewClass);
        }
        for (Class<?> entityViewListenerClass : entityViewListenerClasses) {
            this.configuration.addEntityViewListener(entityViewListenerClass);
        }
    }

    @Autowired(required=false)
    public void setTm(PlatformTransactionManager tm) {
        this.tm = tm;
    }

    @Bean
    public EntityViewConfiguration getEntityViewConfiguration() {
        if (this.tm != null) {
            this.configuration.setTransactionSupport((TransactionSupport)new SpringTransactionSupport(this.tm));
        }
        return this.configuration;
    }
}

