/*
 * Decompiled with CFR 0.152.
 */
package com.blazebit.persistence.view.processor.serialization;

import com.blazebit.persistence.view.processor.serialization.MemberSignature;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.ArrayType;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.type.TypeVariable;

public abstract class SerializationField
implements Comparable<SerializationField> {
    public abstract Element getElement();

    public abstract String getName();

    public abstract TypeKind getTypeKind();

    public abstract char getTypeCode();

    public abstract String getTypeString();

    public abstract boolean isPrimitive();

    @Override
    public int compareTo(SerializationField other) {
        boolean isPrim = this.isPrimitive();
        if (isPrim != other.isPrimitive()) {
            return isPrim ? -1 : 1;
        }
        return this.getName().compareTo(other.getName());
    }

    public static String getMethodSignature(ExecutableElement meth) {
        StringBuilder sb = new StringBuilder();
        sb.append('(');
        for (VariableElement variableElement : meth.getParameters()) {
            sb.append(SerializationField.getClassSignature(variableElement.asType()));
        }
        sb.append(')');
        sb.append(SerializationField.getClassSignature(meth.getReturnType()));
        return sb.toString();
    }

    public static String getClassSignature(TypeMirror typeMirror) {
        StringBuilder sb;
        block17: {
            block16: {
                sb = new StringBuilder();
                while (typeMirror.getKind() == TypeKind.ARRAY) {
                    sb.append('[');
                    typeMirror = ((ArrayType)typeMirror).getComponentType();
                }
                if (!typeMirror.getKind().isPrimitive()) break block16;
                switch (typeMirror.getKind()) {
                    case INT: {
                        sb.append('I');
                        break block17;
                    }
                    case BYTE: {
                        sb.append('B');
                        break block17;
                    }
                    case LONG: {
                        sb.append('J');
                        break block17;
                    }
                    case FLOAT: {
                        sb.append('F');
                        break block17;
                    }
                    case DOUBLE: {
                        sb.append('D');
                        break block17;
                    }
                    case SHORT: {
                        sb.append('S');
                        break block17;
                    }
                    case CHAR: {
                        sb.append('C');
                        break block17;
                    }
                    case BOOLEAN: {
                        sb.append('Z');
                        break block17;
                    }
                    default: {
                        throw new UnsupportedOperationException("Unsupported primitive type: " + typeMirror.toString());
                    }
                }
            }
            if (typeMirror.getKind() == TypeKind.TYPEVAR) {
                TypeVariable typeVariable = (TypeVariable)typeMirror;
                typeMirror = typeVariable.getLowerBound().getKind() == TypeKind.NULL ? typeVariable.getUpperBound() : typeVariable.getLowerBound();
            }
            if (typeMirror.getKind() == TypeKind.VOID) {
                sb.append('V');
            } else {
                String className = typeMirror.toString();
                sb.ensureCapacity(sb.length() + className.length() + 2);
                sb.append('L');
                for (int i = 0; i < className.length(); ++i) {
                    char c = className.charAt(i);
                    if (c == '.') {
                        sb.append('/');
                        continue;
                    }
                    sb.append(c);
                }
                sb.append(';');
            }
        }
        return sb.toString();
    }

    public static long computeDefaultSUID(TypeElement clazz, List<SerializationField> fields) {
        try {
            int i;
            ByteArrayOutputStream bout = new ByteArrayOutputStream();
            DataOutputStream dout = new DataOutputStream(bout);
            dout.writeUTF(clazz.getQualifiedName().toString());
            Set<Modifier> modifiers = clazz.getModifiers();
            int classMods = 0;
            if (modifiers.contains((Object)Modifier.PUBLIC)) {
                classMods |= 1;
            }
            if (modifiers.contains((Object)Modifier.FINAL)) {
                classMods |= 0x10;
            }
            if (clazz.getKind() == ElementKind.INTERFACE) {
                classMods |= 0x200;
            }
            if (modifiers.contains((Object)Modifier.ABSTRACT)) {
                classMods |= 0x400;
            }
            ArrayList<ExecutableElement> methods = new ArrayList<ExecutableElement>();
            ArrayList<ExecutableElement> cons = new ArrayList<ExecutableElement>();
            boolean hasStaticInitializer = false;
            for (Element element : clazz.getEnclosedElements()) {
                if (element.getKind() == ElementKind.CONSTRUCTOR) {
                    cons.add((ExecutableElement)element);
                    continue;
                }
                if (element.getKind() == ElementKind.METHOD) {
                    methods.add((ExecutableElement)element);
                    continue;
                }
                if (element.getKind() != ElementKind.STATIC_INIT) continue;
                hasStaticInitializer = true;
            }
            if ((classMods & 0x200) != 0) {
                classMods = methods.size() > 0 ? classMods | 0x400 : classMods & 0xFFFFFBFF;
            }
            dout.writeInt(classMods);
            List<? extends TypeMirror> interfaces = clazz.getInterfaces();
            Object[] objectArray = new String[interfaces.size()];
            for (int i4 = 0; i4 < interfaces.size(); ++i4) {
                objectArray[i4] = ((TypeElement)((DeclaredType)interfaces.get(i4)).asElement()).getQualifiedName().toString();
            }
            Arrays.sort(objectArray);
            for (int i2 = 0; i2 < objectArray.length; ++i2) {
                dout.writeUTF((String)objectArray[i2]);
            }
            MemberSignature[] fieldSigs = new MemberSignature[fields.size()];
            for (int i3 = 0; i3 < fields.size(); ++i3) {
                fieldSigs[i3] = new MemberSignature((VariableElement)fields.get(i3).getElement());
            }
            Arrays.sort(fieldSigs, new Comparator<MemberSignature>(){

                @Override
                public int compare(MemberSignature ms1, MemberSignature ms2) {
                    return ms1.getName().compareTo(ms2.getName());
                }
            });
            for (int i3 = 0; i3 < fieldSigs.length; ++i3) {
                MemberSignature sig = fieldSigs[i3];
                Set<Modifier> fieldModifiers = sig.getModifiers();
                int mods = 0;
                if (fieldModifiers.contains((Object)Modifier.PUBLIC)) {
                    mods |= 1;
                }
                if (fieldModifiers.contains((Object)Modifier.PRIVATE)) {
                    mods |= 2;
                }
                if (fieldModifiers.contains((Object)Modifier.PROTECTED)) {
                    mods |= 4;
                }
                if (fieldModifiers.contains((Object)Modifier.STATIC)) {
                    mods |= 8;
                }
                if (fieldModifiers.contains((Object)Modifier.FINAL)) {
                    mods |= 0x10;
                }
                if (fieldModifiers.contains((Object)Modifier.VOLATILE)) {
                    mods |= 0x40;
                }
                if (fieldModifiers.contains((Object)Modifier.TRANSIENT)) {
                    mods |= 0x80;
                }
                if ((mods & 2) != 0 && (mods & 0x88) != 0) continue;
                dout.writeUTF(sig.getName());
                dout.writeInt(mods);
                dout.writeUTF(sig.getSignature());
            }
            if (hasStaticInitializer) {
                dout.writeUTF("<clinit>");
                dout.writeInt(8);
                dout.writeUTF("()V");
            }
            MemberSignature[] consSigs = new MemberSignature[cons.size()];
            for (int i2 = 0; i2 < cons.size(); ++i2) {
                consSigs[i2] = new MemberSignature((ExecutableElement)cons.get(i2));
            }
            Arrays.sort(consSigs, new Comparator<MemberSignature>(){

                @Override
                public int compare(MemberSignature ms1, MemberSignature ms2) {
                    return ms1.getSignature().compareTo(ms2.getSignature());
                }
            });
            for (int i4 = 0; i4 < consSigs.length; ++i4) {
                MemberSignature sig = consSigs[i4];
                Set<Modifier> constructorModifiers = sig.getModifiers();
                int mods = 0;
                if (constructorModifiers.contains((Object)Modifier.PUBLIC)) {
                    mods |= 1;
                }
                if (constructorModifiers.contains((Object)Modifier.PRIVATE)) {
                    mods |= 2;
                }
                if (constructorModifiers.contains((Object)Modifier.PROTECTED)) {
                    mods |= 4;
                }
                if (constructorModifiers.contains((Object)Modifier.STATIC)) {
                    mods |= 8;
                }
                if (constructorModifiers.contains((Object)Modifier.FINAL)) {
                    mods |= 0x10;
                }
                if (constructorModifiers.contains((Object)Modifier.SYNCHRONIZED)) {
                    mods |= 0x20;
                }
                if (constructorModifiers.contains((Object)Modifier.NATIVE)) {
                    mods |= 0x100;
                }
                if (constructorModifiers.contains((Object)Modifier.ABSTRACT)) {
                    mods |= 0x400;
                }
                if (constructorModifiers.contains((Object)Modifier.STRICTFP)) {
                    mods |= 0x800;
                }
                if ((mods & 2) != 0) continue;
                dout.writeUTF("<init>");
                dout.writeInt(mods);
                dout.writeUTF(sig.getSignature().replace('/', '.'));
            }
            MemberSignature[] methSigs = new MemberSignature[methods.size()];
            for (i = 0; i < methods.size(); ++i) {
                methSigs[i] = new MemberSignature((ExecutableElement)methods.get(i));
            }
            Arrays.sort(methSigs, new Comparator<MemberSignature>(){

                @Override
                public int compare(MemberSignature ms1, MemberSignature ms2) {
                    int comp = ms1.getName().compareTo(ms2.getName());
                    if (comp == 0) {
                        comp = ms1.getSignature().compareTo(ms2.getSignature());
                    }
                    return comp;
                }
            });
            for (i = 0; i < methSigs.length; ++i) {
                MemberSignature sig = methSigs[i];
                Set<Modifier> methodModifiers = sig.getModifiers();
                int mods = 0;
                if (methodModifiers.contains((Object)Modifier.PUBLIC)) {
                    mods |= 1;
                }
                if (methodModifiers.contains((Object)Modifier.PRIVATE)) {
                    mods |= 2;
                }
                if (methodModifiers.contains((Object)Modifier.PROTECTED)) {
                    mods |= 4;
                }
                if (methodModifiers.contains((Object)Modifier.STATIC)) {
                    mods |= 8;
                }
                if (methodModifiers.contains((Object)Modifier.FINAL)) {
                    mods |= 0x10;
                }
                if (methodModifiers.contains((Object)Modifier.SYNCHRONIZED)) {
                    mods |= 0x20;
                }
                if (methodModifiers.contains((Object)Modifier.NATIVE)) {
                    mods |= 0x100;
                }
                if (methodModifiers.contains((Object)Modifier.ABSTRACT)) {
                    mods |= 0x400;
                }
                if (methodModifiers.contains((Object)Modifier.STRICTFP)) {
                    mods |= 0x800;
                }
                if ((mods & 2) != 0) continue;
                dout.writeUTF(sig.getName());
                dout.writeInt(mods);
                dout.writeUTF(sig.getSignature().replace('/', '.'));
            }
            dout.flush();
            MessageDigest md = MessageDigest.getInstance("SHA");
            byte[] hashBytes = md.digest(bout.toByteArray());
            long hash = 0L;
            for (int i5 = Math.min(hashBytes.length, 8) - 1; i5 >= 0; --i5) {
                hash = hash << 8 | (long)(hashBytes[i5] & 0xFF);
            }
            return hash;
        }
        catch (IOException ex) {
            throw new InternalError(ex);
        }
        catch (NoSuchAlgorithmException ex) {
            throw new SecurityException(ex.getMessage());
        }
    }
}

