/*
 * Decompiled with CFR 0.152.
 */
package com.blazebit.persistence.view.processor.annotation;

import com.blazebit.persistence.view.processor.Context;
import com.blazebit.persistence.view.processor.ImportContext;
import com.blazebit.persistence.view.processor.MetaEntityView;
import com.blazebit.persistence.view.processor.TypeUtils;
import com.blazebit.persistence.view.processor.annotation.AnnotationMetaCollection;
import com.blazebit.persistence.view.processor.annotation.AnnotationMetaEntityView;
import javax.lang.model.element.Element;
import javax.lang.model.element.TypeElement;

public class AnnotationMetaMap
extends AnnotationMetaCollection {
    private final String keyType;
    private final String realKeyType;
    private final MetaEntityView keySubviewElement;
    private final String generatedKeyTypePrefix;
    private final String implementationTypeString;

    public AnnotationMetaMap(AnnotationMetaEntityView parent, Element element, String collectionType, String collectionJavaType, String elementCollectionJavaType, String keyType, String realKeyType, String elementType, String realElementType, Context context) {
        super(parent, element, collectionType, collectionJavaType, elementCollectionJavaType, elementType, realElementType, context);
        this.keyType = keyType;
        this.realKeyType = realKeyType;
        TypeElement subviewElement = AnnotationMetaMap.getSubview(keyType, context);
        if (subviewElement == null) {
            this.keySubviewElement = null;
        } else {
            String subviewFqcn = subviewElement.getQualifiedName().toString();
            MetaEntityView subviewEntityView = context.getMetaEntityViewMap().get(subviewFqcn);
            if (subviewEntityView == null) {
                subviewEntityView = new AnnotationMetaEntityView(subviewElement, context);
            }
            this.keySubviewElement = subviewEntityView;
        }
        this.generatedKeyTypePrefix = this.keySubviewElement != null ? TypeUtils.getDerivedTypeName(context.getTypeElement(keyType)) : keyType;
        this.implementationTypeString = elementCollectionJavaType == null ? this.getHostingEntity().importTypeExceptMetamodel(collectionJavaType) + "<" + this.getHostingEntity().importType(realKeyType) + ", " + this.getHostingEntity().importType(realElementType) + ">" : this.getHostingEntity().importTypeExceptMetamodel(collectionJavaType) + "<" + this.getHostingEntity().importType(realKeyType) + ", " + this.getHostingEntity().importType(elementCollectionJavaType) + "<" + this.getHostingEntity().importType(elementType) + ">>";
    }

    public String getKeyType() {
        return this.keyType;
    }

    public String getGeneratedKeyTypePrefix() {
        return this.generatedKeyTypePrefix;
    }

    public boolean isKeySubview() {
        return this.keySubviewElement != null;
    }

    public MetaEntityView getKeySubviewElement() {
        return this.keySubviewElement;
    }

    @Override
    public String getImplementationTypeString() {
        return this.implementationTypeString;
    }

    @Override
    public void appendDefaultValue(StringBuilder sb, boolean createEmpty, boolean createConstructor, ImportContext importContext) {
        if (createEmpty) {
            if (this.isParameter()) {
                sb.append("new ").append(this.importCollectionType(importContext)).append("<>()");
            } else {
                sb.append("(").append(this.getImplementationTypeString()).append(") (").append(this.collectionJavaType).append("<?, ?>) ");
                sb.append(importContext.importType(this.getDerivedTypeName() + "_")).append('.').append(this.getPropertyName());
                if (this.isSubview()) {
                    sb.append(".attr()");
                }
                sb.append(".getMapInstantiator().");
                if (this.getDirtyStateIndex() == -1) {
                    sb.append("createMap(0)");
                } else {
                    sb.append("createRecordingMap(0)");
                }
            }
        } else {
            super.appendDefaultValue(sb, createEmpty, createConstructor, importContext);
        }
    }

    @Override
    public boolean isCreateEmptyFlatViews() {
        return false;
    }

    private String importCollectionType(ImportContext importContext) {
        switch (this.collectionJavaType) {
            case "java.util.Map": {
                if (this.ordered) {
                    return importContext.importType("java.util.LinkedHashMap");
                }
                if (this.sorted) {
                    return importContext.importType("java.util.TreeMap");
                }
                return importContext.importType("java.util.HashMap");
            }
            case "java.util.SortedMap": {
                return importContext.importType("java.util.TreeMap");
            }
            case "java.util.NavigableMap": {
                return importContext.importType("java.util.TreeMap");
            }
        }
        return importContext.importType("java.util.HashMap");
    }

    @Override
    public void appendMetamodelAttributeType(StringBuilder sb, ImportContext importContext) {
        sb.append(importContext.importType(this.getMetaType())).append('<').append(importContext.importType(this.getHostingEntity().getQualifiedName())).append(", ").append(importContext.importType(this.keyType)).append(", ");
        if (this.elementCollectionJavaType != null) {
            sb.append(importContext.importType(this.getModelType())).append(", ");
        }
        this.appendElementType(sb, importContext);
        sb.append('>');
    }
}

