/*
 * Decompiled with CFR 0.152.
 */
package com.blazebit.persistence.view.processor.annotation;

import com.blazebit.persistence.view.processor.Context;
import com.blazebit.persistence.view.processor.MetaAttribute;
import com.blazebit.persistence.view.processor.MetaConstructor;
import com.blazebit.persistence.view.processor.MetaEntityView;
import com.blazebit.persistence.view.processor.annotation.AnnotationMetaAttribute;
import com.blazebit.persistence.view.processor.annotation.AnnotationMetaEntityView;
import com.blazebit.persistence.view.processor.annotation.MetaAttributeGenerationVisitor;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;

public class AnnotationMetaConstructor
implements MetaConstructor {
    private final AnnotationMetaEntityView parent;
    private final boolean isReal;
    private final boolean hasSelfParameter;
    private final String name;
    private final List<MetaAttribute> parameters;
    private final Map<String, String> optionalParameters;

    public AnnotationMetaConstructor(AnnotationMetaEntityView parent, Map<String, TypeMirror> parentOptionalParameters) {
        TypeElement superclass;
        this.parent = parent;
        this.name = "init";
        this.parameters = Collections.emptyList();
        this.hasSelfParameter = false;
        boolean isReal = false;
        TypeMirror superclassMirror = parent.getTypeElement().getSuperclass();
        while (superclassMirror.getKind() != TypeKind.NONE && !"java.lang.Object".equals((superclass = (TypeElement)((DeclaredType)superclassMirror).asElement()).getQualifiedName().toString())) {
            for (Element element : superclass.getEnclosedElements()) {
                String name = element.getSimpleName().toString();
                if (!"<init>".equals(name)) continue;
                isReal = true;
                break;
            }
            if (isReal) break;
            superclassMirror = superclass.getSuperclass();
        }
        this.isReal = isReal;
        TreeMap<String, String> optionalParameters = new TreeMap<String, String>();
        for (Map.Entry entry : parentOptionalParameters.entrySet()) {
            optionalParameters.put((String)entry.getKey(), ((TypeMirror)entry.getValue()).toString());
        }
        this.optionalParameters = optionalParameters;
    }

    public AnnotationMetaConstructor(AnnotationMetaEntityView parent, Map<String, TypeMirror> parentOptionalParameters, Map<String, TypeMirror> optionalParameters, ExecutableElement element, MetaAttributeGenerationVisitor visitor, Context context) {
        this.parent = parent;
        this.isReal = true;
        String name = "init";
        block0: for (AnnotationMirror annotationMirror : element.getAnnotationMirrors()) {
            if (!annotationMirror.getAnnotationType().toString().equals("com.blazebit.persistence.view.ViewConstructor")) continue;
            for (Map.Entry<? extends ExecutableElement, ? extends AnnotationValue> entry : annotationMirror.getElementValues().entrySet()) {
                if (!entry.getKey().getSimpleName().toString().equals("value")) continue;
                name = entry.getValue().getValue().toString();
                break block0;
            }
        }
        this.name = name;
        ArrayList<MetaAttribute> parameters = new ArrayList<MetaAttribute>(element.getParameters().size());
        List<? extends VariableElement> list = element.getParameters();
        boolean hasSelfParameter = false;
        for (int i = 0; i < list.size(); ++i) {
            VariableElement parameter = list.get(i);
            AnnotationMetaAttribute result = parameter.asType().accept(visitor, parameter);
            result.setAttributeIndex(i);
            parameters.add(result);
            for (Map.Entry<String, TypeMirror> entry : result.getOptionalParameters().entrySet()) {
                TypeMirror typeElement = entry.getValue();
                TypeMirror existingTypeElement = optionalParameters.get(entry.getKey());
                if (existingTypeElement != null && !context.getTypeUtils().isAssignable(typeElement, existingTypeElement)) continue;
                optionalParameters.put(entry.getKey(), entry.getValue());
            }
            result.getOptionalParameters().clear();
            hasSelfParameter = hasSelfParameter || result.isSelf();
        }
        this.parameters = parameters;
        this.hasSelfParameter = hasSelfParameter;
        this.optionalParameters = AnnotationMetaConstructor.createOrderedOptionalParameters(parentOptionalParameters, context, optionalParameters);
    }

    private static Map<String, String> createOrderedOptionalParameters(Map<String, TypeMirror> entityOptionalParameters, Context context, Map<String, TypeMirror> elementOptionalParameters) {
        TreeMap<String, String> optionalParameters = new TreeMap<String, String>();
        for (Map.Entry<String, TypeMirror> entry : elementOptionalParameters.entrySet()) {
            if (context.getOptionalParameters().containsKey(entry.getKey())) continue;
            TypeMirror typeElement = entityOptionalParameters.get(entry.getKey());
            if (typeElement == null) {
                optionalParameters.put(entry.getKey(), entry.getValue().toString());
                continue;
            }
            if (context.getTypeUtils().isAssignable(typeElement, entry.getValue())) {
                optionalParameters.put(entry.getKey(), typeElement.toString());
                continue;
            }
            optionalParameters.put(entry.getKey(), entry.getValue().toString());
        }
        for (Map.Entry<String, TypeMirror> entry : entityOptionalParameters.entrySet()) {
            if (context.getOptionalParameters().containsKey(entry.getKey())) continue;
            optionalParameters.put(entry.getKey(), entry.getValue().toString());
        }
        return optionalParameters;
    }

    @Override
    public MetaEntityView getHostingEntity() {
        return this.parent;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public boolean isReal() {
        return this.isReal;
    }

    @Override
    public boolean hasSelfParameter() {
        return this.hasSelfParameter;
    }

    @Override
    public List<MetaAttribute> getParameters() {
        return this.parameters;
    }

    @Override
    public Map<String, String> getOptionalParameters() {
        return this.optionalParameters;
    }
}

