/*
 * Decompiled with CFR 0.152.
 */
package com.blazebit.persistence.view.processor.annotation;

import com.blazebit.persistence.view.processor.AttributeFilter;
import com.blazebit.persistence.view.processor.Context;
import com.blazebit.persistence.view.processor.EntityIdAttribute;
import com.blazebit.persistence.view.processor.EntityViewTypeUtils;
import com.blazebit.persistence.view.processor.ImportContext;
import com.blazebit.persistence.view.processor.MappingKind;
import com.blazebit.persistence.view.processor.MetaAttribute;
import com.blazebit.persistence.view.processor.MetaEntityView;
import com.blazebit.persistence.view.processor.OptionalParameterUtils;
import com.blazebit.persistence.view.processor.TypeUtils;
import com.blazebit.persistence.view.processor.annotation.AnnotationMetaCollection;
import com.blazebit.persistence.view.processor.annotation.AnnotationMetaEntityView;
import com.blazebit.persistence.view.processor.serialization.MetaSerializationField;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.tools.Diagnostic;

public abstract class AnnotationMetaAttribute
implements MetaAttribute {
    private static final String NEW_LINE = System.lineSeparator();
    private final AnnotationMetaEntityView parent;
    private final String getterName;
    private final ElementKind elementKind;
    private final Set<Modifier> modifiers;
    private final String getterPackageName;
    private final String modelType;
    private final String declaredJavaType;
    private final String implementationTypeString;
    private final String convertedModelType;
    private final TypeMirror typeMirror;
    private final TypeKind typeKind;
    private final MetaSerializationField serializationField;
    private final String attributeName;
    private final MappingKind kind;
    private final String mapping;
    private final MetaEntityView subviewElement;
    private final Map<String, AttributeFilter> filters;
    private final Map<String, TypeMirror> optionalParameters;
    private final List<EntityIdAttribute> entityIdAttributes;
    private final boolean mutable;
    private final boolean updatable;
    private final boolean createEmptyFlatViews;
    private final String generatedTypePrefix;
    private final String setterName;
    private final boolean idMember;
    private final boolean versionMember;
    private final boolean self;
    private final boolean supportsDirtyTracking;
    private final String derivedTypeName;
    private int attributeIndex = -1;
    private int dirtyStateIndex = -1;

    /*
     * WARNING - void declaration
     */
    protected AnnotationMetaAttribute(AnnotationMetaEntityView parent, Element element, String modelType, String declaredJavaType, String convertedModelType, Context context, boolean version) {
        HashMap<String, TypeMirror> optionalParameters;
        HashMap<String, AttributeFilter> filters;
        this.parent = parent;
        this.modelType = modelType;
        this.declaredJavaType = declaredJavaType;
        this.implementationTypeString = this.getHostingEntity().importTypeExceptMetamodel(declaredJavaType);
        this.convertedModelType = convertedModelType;
        this.derivedTypeName = TypeUtils.getDerivedTypeName(parent.getTypeElement());
        String mapping = null;
        MappingKind kind = null;
        Boolean updatable = null;
        Boolean mutable = null;
        boolean self = false;
        boolean createEmptyFlatViews = context.isCreateEmptyFlatViews();
        if (version) {
            mapping = element.getSimpleName().toString();
            if (element.getKind() == ElementKind.METHOD) {
                mapping = mapping.substring(3);
            }
            kind = MappingKind.MAPPING;
            updatable = false;
            mutable = false;
            filters = Collections.emptyMap();
            optionalParameters = Collections.emptyMap();
        } else {
            filters = new HashMap();
            optionalParameters = new HashMap();
            block49: for (AnnotationMirror mirror : TypeUtils.getAnnotationMirrors(element, "com.blazebit.persistence.view.IdMapping", "com.blazebit.persistence.view.Mapping", "com.blazebit.persistence.view.MappingCorrelated", "com.blazebit.persistence.view.MappingCorrelatedSimple", "com.blazebit.persistence.view.MappingParameter", "com.blazebit.persistence.view.MappingSubquery", "com.blazebit.persistence.view.UpdatableMapping", "com.blazebit.persistence.view.Self", "com.blazebit.persistence.view.EmptyFlatViewCreation", "com.blazebit.persistence.view.AttributeFilter", "com.blazebit.persistence.view.AttributeFilters")) {
                switch (mirror.getAnnotationType().toString()) {
                    case "com.blazebit.persistence.view.IdMapping": {
                        mapping = (String)TypeUtils.getAnnotationValue(mirror, "value");
                        kind = MappingKind.MAPPING;
                        updatable = false;
                        mutable = false;
                        OptionalParameterUtils.addOptionalParametersTypeElement(optionalParameters, mapping, context);
                        break;
                    }
                    case "com.blazebit.persistence.view.Mapping": {
                        mapping = (String)TypeUtils.getAnnotationValue(mirror, "value");
                        kind = MappingKind.MAPPING;
                        OptionalParameterUtils.addOptionalParametersTypeElement(optionalParameters, mapping, context);
                        break;
                    }
                    case "com.blazebit.persistence.view.MappingCorrelated": {
                        kind = MappingKind.CORRELATED;
                        for (Map.Entry<? extends ExecutableElement, ? extends AnnotationValue> entry : mirror.getElementValues().entrySet()) {
                            switch (entry.getKey().getSimpleName().toString()) {
                                case "correlationBasis": 
                                case "correlationResult": {
                                    OptionalParameterUtils.addOptionalParametersTypeElement(optionalParameters, (String)entry.getValue().getValue(), context);
                                    break;
                                }
                            }
                        }
                        continue block49;
                    }
                    case "com.blazebit.persistence.view.MappingCorrelatedSimple": {
                        Object entry222;
                        kind = MappingKind.CORRELATED;
                        for (Object entry222 : mirror.getElementValues().entrySet()) {
                            switch (((ExecutableElement)entry222.getKey()).getSimpleName().toString()) {
                                case "correlationBasis": 
                                case "correlationResult": 
                                case "correlationExpression": {
                                    OptionalParameterUtils.addOptionalParametersTypeElement(optionalParameters, (String)((AnnotationValue)entry222.getValue()).getValue(), context);
                                    break;
                                }
                            }
                        }
                        continue block49;
                    }
                    case "com.blazebit.persistence.view.MappingParameter": {
                        mapping = (String)TypeUtils.getAnnotationValue(mirror, "value");
                        kind = MappingKind.PARAMETER;
                        updatable = false;
                        mutable = false;
                        TypeMirror typeMirror = context.getOptionalParameters().get(mapping);
                        if (typeMirror == null) {
                            if (element.getKind() == ElementKind.METHOD) {
                                optionalParameters.put(mapping, ((ExecutableElement)element).getReturnType());
                                break;
                            }
                            optionalParameters.put(mapping, element.asType());
                            break;
                        }
                        optionalParameters.put(mapping, typeMirror);
                        break;
                    }
                    case "com.blazebit.persistence.view.MappingSubquery": {
                        kind = MappingKind.SUBQUERY;
                        updatable = false;
                        mutable = false;
                        OptionalParameterUtils.addOptionalParametersTypeElement(optionalParameters, (String)TypeUtils.getAnnotationValue(mirror, "expression"), context);
                        break;
                    }
                    case "com.blazebit.persistence.view.UpdatableMapping": {
                        updatable = true;
                        Object entry222 = mirror.getElementValues().entrySet().iterator();
                        while (entry222.hasNext()) {
                            Map.Entry entry = (Map.Entry)entry222.next();
                            switch (((ExecutableElement)entry.getKey()).getSimpleName().toString()) {
                                case "updatable": {
                                    updatable = (boolean)((Boolean)((AnnotationValue)entry.getValue()).getValue());
                                    break;
                                }
                                case "cascade": {
                                    List annotationValues = (List)((AnnotationValue)entry.getValue()).getValue();
                                    mutable = !annotationValues.isEmpty();
                                    break;
                                }
                            }
                        }
                        continue block49;
                    }
                    case "com.blazebit.persistence.view.Self": {
                        self = true;
                        break;
                    }
                    case "com.blazebit.persistence.view.EmptyFlatViewCreation": {
                        createEmptyFlatViews = (Boolean)TypeUtils.getAnnotationValue(mirror, "value");
                        break;
                    }
                    case "com.blazebit.persistence.view.AttributeFilter": {
                        AnnotationMetaAttribute.addAttributeFilter(filters, mirror, declaredJavaType, context);
                        break;
                    }
                    case "com.blazebit.persistence.view.AttributeFilters": {
                        Object entry222 = ((List)TypeUtils.getAnnotationValue(mirror, "value")).iterator();
                        while (entry222.hasNext()) {
                            AnnotationMirror value = (AnnotationMirror)entry222.next();
                            AnnotationMetaAttribute.addAttributeFilter(filters, value, declaredJavaType, context);
                        }
                        continue block49;
                    }
                }
            }
            if (kind == null) {
                kind = MappingKind.MAPPING;
                mapping = EntityViewTypeUtils.getAttributeName(element);
            }
        }
        this.modifiers = element.getModifiers();
        this.elementKind = element.getKind();
        this.mapping = mapping;
        this.kind = kind;
        this.filters = filters;
        this.optionalParameters = optionalParameters;
        if (kind == MappingKind.PARAMETER || kind == MappingKind.SUBQUERY) {
            this.subviewElement = null;
        } else {
            TypeElement subviewElement = AnnotationMetaAttribute.getSubview(modelType, context);
            if (subviewElement == null) {
                this.subviewElement = null;
            } else {
                String subviewFqcn = subviewElement.getQualifiedName().toString();
                MetaEntityView subviewEntityView = context.getMetaEntityViewMap().get(subviewFqcn);
                if (subviewEntityView == null) {
                    subviewEntityView = new AnnotationMetaEntityView(subviewElement, context);
                }
                this.subviewElement = subviewEntityView;
            }
        }
        this.generatedTypePrefix = this.subviewElement != null ? TypeUtils.getDerivedTypeName(context.getTypeElement(modelType)) : modelType;
        this.createEmptyFlatViews = this.subviewElement != null && this.subviewElement.getIdMember() == null && this.subviewElement.hasEmptyConstructor() ? createEmptyFlatViews : false;
        if (version) {
            this.attributeName = "$$_version";
            this.setterName = null;
            this.typeMirror = element.asType();
            this.supportsDirtyTracking = true;
            this.idMember = false;
            this.versionMember = true;
        } else if (element.getKind() == ElementKind.PARAMETER) {
            this.attributeName = element.getSimpleName().toString();
            this.setterName = null;
            this.typeMirror = element.asType();
            this.supportsDirtyTracking = false;
            this.idMember = false;
            this.versionMember = false;
        } else if (element.getKind() == ElementKind.METHOD) {
            void var20_28;
            String setterName;
            String name = element.getSimpleName().toString();
            if (name.startsWith("get")) {
                this.attributeName = EntityViewTypeUtils.firstToLower(3, name);
                setterName = "set" + name.substring(3);
            } else if (name.startsWith("is")) {
                this.attributeName = EntityViewTypeUtils.firstToLower(2, name);
                setterName = "set" + name.substring(2);
            } else {
                this.attributeName = EntityViewTypeUtils.firstToLower(0, name);
                setterName = name;
                parent.getContext().logMessage(Diagnostic.Kind.WARNING, "Invalid method name for attribute:" + element);
            }
            Element setter = null;
            for (Element element2 : element.getEnclosingElement().getEnclosedElements()) {
                if (!setterName.equals(element2.getSimpleName().toString())) continue;
                setter = element2;
                break;
            }
            ArrayList<? extends TypeMirror> superClasses = new ArrayList<TypeMirror>();
            superClasses.add(parent.getTypeElement().asType());
            boolean bl = false;
            while (var20_28 < superClasses.size()) {
                TypeMirror superClass = (TypeMirror)superClasses.get((int)var20_28);
                Element superClassElement = ((DeclaredType)superClass).asElement();
                for (Element element3 : superClassElement.getEnclosedElements()) {
                    if (!setterName.equals(element3.getSimpleName().toString())) continue;
                    setter = element3;
                    break;
                }
                if ((superClass = ((TypeElement)superClassElement).getSuperclass()).getKind() == TypeKind.DECLARED) {
                    superClasses.add(superClass);
                }
                superClasses.addAll(((TypeElement)superClassElement).getInterfaces());
                ++var20_28;
            }
            String string = this.setterName = setter == null ? null : setter.getSimpleName().toString();
            if (setter != null && updatable == null) {
                updatable = true;
            }
            this.typeMirror = ((ExecutableElement)element).getReturnType();
            this.supportsDirtyTracking = this.subviewElement != null || EntityViewTypeUtils.getMutability(modelType) != EntityViewTypeUtils.Mutability.MUTABLE;
            this.idMember = TypeUtils.containsAnnotation(element, "com.blazebit.persistence.view.IdMapping");
            this.versionMember = mapping != null && (mapping.equals(parent.getEntityVersionAttributeName()) || context.matchesDefaultVersionAttribute(element));
            self = false;
        } else {
            this.attributeName = null;
            this.setterName = null;
            this.typeMirror = null;
            this.supportsDirtyTracking = false;
            this.idMember = false;
            this.versionMember = false;
            self = false;
            parent.getContext().logMessage(Diagnostic.Kind.WARNING, "Invalid unknown attribute element kind " + (Object)((Object)element.getKind()) + " for attribute: " + element);
        }
        if (updatable == null) {
            updatable = false;
        }
        if (mutable == null) {
            mutable = updatable != false || this.subviewElement != null && (this.subviewElement.isUpdatable() || this.subviewElement.isCreatable());
        }
        this.self = self;
        this.updatable = updatable;
        boolean bl = this.mutable = updatable != false || mutable != false;
        if (!version && this.elementKind == ElementKind.METHOD) {
            this.getterName = element.getSimpleName().toString();
        } else {
            StringBuilder sb = new StringBuilder();
            if ("boolean".equals(modelType)) {
                sb.append("is");
            } else {
                sb.append("get");
            }
            if (this.elementKind == ElementKind.PARAMETER) {
                sb.append("Param");
            }
            if (this.attributeName != null) {
                sb.append(Character.toUpperCase(this.attributeName.charAt(0)));
                sb.append(this.getPropertyName(), 1, this.attributeName.length());
            }
            this.getterName = sb.toString();
        }
        this.getterPackageName = version ? null : TypeUtils.getPackageName(context, element);
        this.typeKind = this.typeMirror == null ? null : this.typeMirror.getKind();
        this.serializationField = new MetaSerializationField(this, this.typeMirror);
        this.entityIdAttributes = this.dirtyStateIndex != -1 && !updatable.booleanValue() && (parent.isCreatable() || parent.isUpdatable()) ? (this instanceof AnnotationMetaCollection || this.subviewElement != null ? Collections.emptyList() : EntityViewTypeUtils.getEntityIdAttributes(modelType, context)) : Collections.emptyList();
    }

    public AnnotationMetaAttribute(AnnotationMetaEntityView parent, Element element, String modelType, String declaredJavaType, Context context) {
        this(parent, element, modelType, declaredJavaType, null, context, false);
    }

    private static void addAttributeFilter(Map<String, AttributeFilter> filters, AnnotationMirror mirror, String attributeType, Context context) {
        String name = "";
        TypeMirror type = null;
        for (Map.Entry<? extends ExecutableElement, ? extends AnnotationValue> entry : mirror.getElementValues().entrySet()) {
            switch (entry.getKey().getSimpleName().toString()) {
                case "name": {
                    name = (String)entry.getValue().getValue();
                    break;
                }
                case "value": {
                    type = (TypeMirror)entry.getValue().getValue();
                    break;
                }
            }
        }
        filters.put(name, new AttributeFilter(name, type, attributeType, context));
    }

    protected static TypeElement getSubview(String realType, Context context) {
        switch (realType) {
            case "int": 
            case "boolean": 
            case "byte": 
            case "char": 
            case "double": 
            case "float": 
            case "long": 
            case "short": {
                return null;
            }
        }
        TypeElement typeElement = context.getTypeElement(realType);
        if (typeElement == null || !TypeUtils.containsAnnotation(typeElement, "com.blazebit.persistence.view.EntityView")) {
            return null;
        }
        return typeElement;
    }

    @Override
    public void appendDefaultValue(StringBuilder sb, boolean createEmpty, boolean createConstructor, ImportContext importContext) {
        if (createEmpty && this.createEmptyFlatViews) {
            if (!this.modelType.equals(this.declaredJavaType)) {
                sb.append("(").append(this.declaredJavaType).append(") ");
            }
            String attributeImplementationType = importContext.importType(this.getGeneratedTypePrefix() + "Impl");
            sb.append("new ").append(attributeImplementationType).append("((").append(attributeImplementationType).append(") null, ");
            if (createConstructor) {
                sb.append("blazePersistenceOptionalParameters").append(")");
            } else {
                sb.append(importContext.importType(Collections.class.getName())).append(".emptyMap())");
            }
        } else {
            sb.append(TypeUtils.getDefaultValue(this.typeMirror.getKind()));
        }
    }

    @Override
    public boolean isCreateEmptyFlatViews() {
        return this.createEmptyFlatViews;
    }

    public Map<String, TypeMirror> getOptionalParameters() {
        return this.optionalParameters;
    }

    public boolean isIdMember() {
        return this.idMember;
    }

    public boolean isVersion() {
        return this.versionMember;
    }

    protected String getDerivedTypeName() {
        return this.derivedTypeName;
    }

    @Override
    public void appendMetamodelAttributeType(StringBuilder sb, ImportContext importContext) {
        sb.append(importContext.importType(this.getMetaType())).append('<').append(importContext.importType(this.parent.getQualifiedName())).append(", ");
        this.appendElementType(sb, importContext);
        sb.append('>');
    }

    @Override
    public void appendElementType(StringBuilder sb, ImportContext importContext) {
        sb.append(importContext.importType(this.getModelType()));
    }

    @Override
    public void appendMetamodelAttributeDeclarationString(StringBuilder sb, ImportContext importContext) {
        sb.append("    public static volatile ");
        if (this.isSubview()) {
            if (this.isMultiCollection()) {
                sb.append(this.parent.metamodelImportType(this.generatedTypePrefix + "MultiRelation")).append('<');
                sb.append(importContext.importType(this.parent.getQualifiedName())).append(", ");
                this.appendElementType(sb, this.parent.getMetamodelImportContext());
                sb.append(", ");
            } else {
                sb.append(this.parent.metamodelImportType(this.generatedTypePrefix + "Relation")).append('<').append(importContext.importType(this.parent.getQualifiedName())).append(", ");
            }
        }
        this.appendMetamodelAttributeType(sb, this.parent.getMetamodelImportContext());
        if (this.isSubview()) {
            sb.append('>');
        }
        sb.append(' ').append(this.getPropertyName()).append(';');
    }

    @Override
    public void appendMetamodelAttributeNameDeclarationString(StringBuilder sb, ImportContext importContext) {
        String propertyName = this.getPropertyName();
        sb.append("    public static final ").append(importContext.importType(String.class.getName())).append(" ");
        for (int i = 0; i < propertyName.length(); ++i) {
            char c = propertyName.charAt(i);
            if (Character.isUpperCase(c)) {
                sb.append('_');
            }
            sb.append(Character.toUpperCase(c));
        }
        sb.append(" = ").append("\"").append(propertyName).append("\"").append(";");
    }

    @Override
    public void appendImplementationAttributeDeclarationString(StringBuilder sb) {
        sb.append("    private ");
        if (this.setterName == null && (!this.idMember && !this.versionMember || !this.parent.isCreatable() && !this.parent.isUpdatable())) {
            sb.append("final ");
        }
        sb.append(this.getImplementationTypeString());
        sb.append(' ').append(this.getPropertyName()).append(";");
    }

    @Override
    public void appendImplementationAttributeGetterAndSetterString(StringBuilder sb, Context context) {
        sb.append("    @Override").append(NEW_LINE).append("    public ");
        sb.append(this.getImplementationTypeString());
        sb.append(' ').append(this.getterName).append("() {").append(NEW_LINE).append("        return ").append(this.getPropertyName()).append(";").append(NEW_LINE).append("    }");
        if (this.setterName != null) {
            sb.append(NEW_LINE).append("    @Override").append(NEW_LINE).append("    public void ").append(this.setterName).append('(');
            sb.append(this.getImplementationTypeString());
            sb.append(' ').append(this.getPropertyName()).append(") {").append(NEW_LINE);
            if (this.idMember) {
                if (this.parent.isCreatable()) {
                    sb.append("        if ($$_kind != (byte) 2) {").append(NEW_LINE);
                    sb.append("            throw new IllegalArgumentException(\"Updating the id attribute '").append(this.getPropertyName()).append("' is only allowed for new entity view objects created via EntityViewManager.create()!\");").append(NEW_LINE);
                    sb.append("        }").append(NEW_LINE);
                } else if (this.parent.isUpdatable()) {
                    sb.append("        throw new IllegalArgumentException(\"Updating the id attribute '").append(this.getPropertyName()).append("' is only allowed for new entity view objects created via EntityViewManager.create()!\");").append(NEW_LINE);
                }
            }
            if (this.dirtyStateIndex != -1 && !this.updatable && (this.parent.isCreatable() || this.parent.isUpdatable())) {
                sb.append("        Object tmp;").append(NEW_LINE);
                sb.append("        if (").append(this.getPropertyName()).append(" != this.").append(this.getPropertyName());
                if (!(this instanceof AnnotationMetaCollection)) {
                    if (this.subviewElement != null) {
                        if (this.subviewElement.getIdMember() != null) {
                            String idMethodName = this.subviewElement.getIdMember().getGetterName();
                            sb.append(" && (").append(this.getPropertyName()).append(" == null || (tmp = ").append(this.getPropertyName()).append('.').append(idMethodName);
                            sb.append("()) == null || !java.util.Objects.equals(tmp, this.").append(this.getPropertyName()).append('.').append(idMethodName);
                            sb.append("()))");
                        }
                    } else if (!this.entityIdAttributes.isEmpty()) {
                        for (EntityIdAttribute entityIdAttribute : this.entityIdAttributes) {
                            sb.append(" && (").append(this.getPropertyName()).append(" == null || (tmp = ").append(entityIdAttribute.getIdMethodName()).append('(').append(this.getPropertyName());
                            sb.append(")) == null || !java.util.Objects.equals(tmp, ").append(entityIdAttribute.getIdMethodName()).append("(this.").append(this.getPropertyName());
                            sb.append(")))");
                        }
                    }
                }
                sb.append(") {").append(NEW_LINE);
                sb.append("            throw new IllegalArgumentException(\"Updating the mutable-only attribute '").append(this.getPropertyName()).append("' with a value that has not the same identity is not allowed! Consider making the attribute updatable or update the value directly instead of replacing it!\");").append(NEW_LINE);
                sb.append("        }").append(NEW_LINE);
            }
            boolean renderSetter = true;
            boolean needsMethodAttribute = true;
            if (this.updatable && (this.parent.isUpdatable() || this.parent.isCreatable())) {
                if (this instanceof AnnotationMetaCollection) {
                    if (context.isStrictCascadingCheck()) {
                        sb.append("        throw new IllegalArgumentException(\"Replacing a collection that PERSIST or UPDATE cascades is prohibited by default! Instead, replace the contents by doing clear() and addAll()!\");").append(NEW_LINE);
                        renderSetter = false;
                    }
                } else if (this.subviewElement != null) {
                    sb.append("        ").append(this.parent.implementationImportType("com.blazebit.persistence.view.metamodel.MethodAttribute")).append("<?, ?> m = (").append(this.parent.implementationImportType("com.blazebit.persistence.view.metamodel.MethodAttribute")).append("<?, ?>) ").append(this.parent.implementationImportType(this.derivedTypeName + "_")).append(".").append(this.getPropertyName()).append(".attr();").append(NEW_LINE);
                    needsMethodAttribute = false;
                    sb.append("        if (").append(this.getPropertyName()).append(" != null) {").append(NEW_LINE);
                    sb.append("            Class<?> c;").append(NEW_LINE);
                    sb.append("            boolean isNew;").append(NEW_LINE);
                    sb.append("            if (").append(this.getPropertyName()).append(" instanceof ").append(this.parent.implementationImportType("com.blazebit.persistence.view.spi.type.EntityViewProxy")).append(") {").append(NEW_LINE);
                    sb.append("                c = ((").append(this.parent.implementationImportType("com.blazebit.persistence.view.spi.type.EntityViewProxy")).append(") ").append(this.getPropertyName()).append(").$$_getEntityViewClass();").append(NEW_LINE);
                    sb.append("                isNew = ((").append(this.parent.implementationImportType("com.blazebit.persistence.view.spi.type.EntityViewProxy")).append(") ").append(this.getPropertyName()).append(").$$_isNew();").append(NEW_LINE);
                    sb.append("            } else {").append(NEW_LINE);
                    sb.append("                c = ").append(this.getPropertyName()).append(".getClass();").append(NEW_LINE);
                    sb.append("                isNew = false;").append(NEW_LINE);
                    sb.append("            }").append(NEW_LINE);
                    sb.append("            if (!m.getAllowedSubtypes().contains(c)) {").append(NEW_LINE);
                    sb.append("                throw new IllegalArgumentException(\"Allowed subtypes for attribute '").append(this.getPropertyName()).append("' are \" + m.getAllowedSubtypes() + \" but got an instance of: \" + c.getName());").append(NEW_LINE);
                    sb.append("            }").append(NEW_LINE);
                    if (context.isStrictCascadingCheck()) {
                        sb.append("            if (this != (Object) ").append(this.getPropertyName()).append(" && !isNew && m.getParentRequiringUpdateSubtypes().contains(c) && !((").append(this.parent.implementationImportType("com.blazebit.persistence.view.spi.type.DirtyTracker")).append(") ").append(this.getPropertyName()).append(").$$_hasParent()) {").append(NEW_LINE);
                        sb.append("                throw new IllegalArgumentException(\"Setting instances of type [\" + c.getName() + \"] on attribute '").append(this.getPropertyName()).append("' is not allowed until they are assigned to an attribute that cascades the type!").append(" If you want this attribute to cascade, annotate it with @UpdatableMapping(cascade = { UPDATE }). You can also turn off strict cascading checks by setting ConfigurationProperties.UPDATER_STRICT_CASCADING_CHECK to false\");").append(NEW_LINE);
                        sb.append("            }").append(NEW_LINE);
                        sb.append("            if (this != (Object) ").append(this.getPropertyName()).append(" && isNew && m.getParentRequiringCreateSubtypes().contains(c) && !((").append(this.parent.implementationImportType("com.blazebit.persistence.view.spi.type.DirtyTracker")).append(") ").append(this.getPropertyName()).append(").$$_hasParent()) {").append(NEW_LINE);
                        sb.append("                throw new IllegalArgumentException(\"Setting instances of type [\" + c.getName() + \"] on attribute '").append(this.getPropertyName()).append("' is not allowed until they are assigned to an attribute that cascades the type!").append(" If you want this attribute to cascade, annotate it with @UpdatableMapping(cascade = { PERSIST }). You can also turn off strict cascading checks by setting ConfigurationProperties.UPDATER_STRICT_CASCADING_CHECK to false\");").append(NEW_LINE);
                        sb.append("            }").append(NEW_LINE);
                    }
                    sb.append("        }").append(NEW_LINE);
                }
            }
            if (renderSetter) {
                if (this.dirtyStateIndex != -1 && (this.parent.isUpdatable() || this.parent.isCreatable())) {
                    if (this instanceof AnnotationMetaCollection) {
                        sb.append("        if (this.").append(this.getPropertyName()).append(" != ").append(this.getPropertyName()).append(" && this.").append(this.getPropertyName()).append(" instanceof ").append(this.parent.implementationImportType("com.blazebit.persistence.view.spi.type.BasicDirtyTracker")).append(") {").append(NEW_LINE);
                        sb.append("            ((").append(this.parent.implementationImportType("com.blazebit.persistence.view.spi.type.BasicDirtyTracker")).append(") this.").append(this.getPropertyName()).append(").$$_unsetParent();").append(NEW_LINE);
                        sb.append("        }").append(NEW_LINE);
                    } else if (this.subviewElement != null) {
                        if (needsMethodAttribute) {
                            sb.append("        ").append(this.parent.implementationImportType("com.blazebit.persistence.view.metamodel.MethodAttribute")).append("<?, ?> m = (").append(this.parent.implementationImportType("com.blazebit.persistence.view.metamodel.MethodAttribute")).append("<?, ?>) ").append(this.parent.implementationImportType(this.derivedTypeName + "_")).append(".").append(this.getPropertyName()).append(".attr();").append(NEW_LINE);
                        }
                        if (this.kind != MappingKind.CORRELATED) {
                            sb.append("        if (!m.isPersistCascaded() && !m.isUpdateCascaded() && this.").append(this.getPropertyName()).append(" != ").append(this.getPropertyName()).append(" && this.").append(this.getPropertyName()).append(" instanceof ").append(this.parent.implementationImportType("com.blazebit.persistence.view.spi.type.MutableStateTrackable")).append(") {").append(NEW_LINE);
                            sb.append("            ((").append(this.parent.implementationImportType("com.blazebit.persistence.view.spi.type.MutableStateTrackable")).append(") this.").append(this.getPropertyName()).append(").$$_removeReadOnlyParent(this, ").append(this.dirtyStateIndex).append(");").append(NEW_LINE);
                            sb.append("        } else ");
                        } else {
                            sb.append("        ");
                        }
                        sb.append("if (this.").append(this.getPropertyName()).append(" != ").append(this.getPropertyName()).append(" && this.").append(this.getPropertyName()).append(" instanceof ").append(this.parent.implementationImportType("com.blazebit.persistence.view.spi.type.BasicDirtyTracker")).append(") {").append(NEW_LINE);
                        sb.append("            ((").append(this.parent.implementationImportType("com.blazebit.persistence.view.spi.type.BasicDirtyTracker")).append(") this.").append(this.getPropertyName()).append(").$$_unsetParent();").append(NEW_LINE);
                        sb.append("        }").append(NEW_LINE);
                    }
                    sb.append("        if (this.$$_mutableState != null) {").append(NEW_LINE);
                    sb.append("            this.$$_mutableState[").append(this.dirtyStateIndex).append("] = ").append(this.getPropertyName()).append(";").append(NEW_LINE);
                    sb.append("        }").append(NEW_LINE);
                    sb.append("        this.$$_markDirty(").append(this.dirtyStateIndex).append(");").append(NEW_LINE);
                    if (this instanceof AnnotationMetaCollection || this.subviewElement != null) {
                        sb.append("        if (").append(this.getPropertyName()).append(" != null && this.").append(this.getPropertyName()).append(" != ").append(this.getPropertyName()).append(") {").append(NEW_LINE);
                        if (this instanceof AnnotationMetaCollection) {
                            sb.append("            ");
                        } else if (this.kind != MappingKind.CORRELATED) {
                            sb.append("            if (!m.isPersistCascaded() && !m.isUpdateCascaded() && ").append(this.getPropertyName()).append(" instanceof ").append(this.parent.implementationImportType("com.blazebit.persistence.view.spi.type.MutableStateTrackable")).append(") {").append(NEW_LINE);
                            sb.append("                ((").append(this.parent.implementationImportType("com.blazebit.persistence.view.spi.type.MutableStateTrackable")).append(") ").append(this.getPropertyName()).append(").$$_addReadOnlyParent(this, ").append(this.dirtyStateIndex).append(");").append(NEW_LINE);
                            sb.append("            } else ");
                        } else {
                            sb.append("            ");
                        }
                        sb.append("if (").append(this.getPropertyName()).append(" instanceof ").append(this.parent.implementationImportType("com.blazebit.persistence.view.spi.type.BasicDirtyTracker")).append(") {").append(NEW_LINE);
                        sb.append("                ((").append(this.parent.implementationImportType("com.blazebit.persistence.view.spi.type.BasicDirtyTracker")).append(") ").append(this.getPropertyName()).append(").$$_setParent(this, ").append(this.dirtyStateIndex).append(");").append(NEW_LINE);
                        sb.append("            }").append(NEW_LINE);
                        sb.append("        }").append(NEW_LINE);
                    }
                }
                if (!this.idMember || this.parent.isCreatable() || !this.parent.isUpdatable()) {
                    sb.append("        this.").append(this.getPropertyName()).append(" = ").append(this.getPropertyName()).append(";").append(NEW_LINE);
                }
            }
            sb.append("    }");
            if (!this.entityIdAttributes.isEmpty() && this.parent.addAccessorForType(this.modelType)) {
                for (EntityIdAttribute entityIdAttribute : this.entityIdAttributes) {
                    String accessor = entityIdAttribute.getIdMethodName() + "_accessor";
                    sb.append(NEW_LINE);
                    if (entityIdAttribute.getKind() == ElementKind.METHOD) {
                        sb.append("    private static final ").append(this.parent.implementationImportType(Method.class.getName())).append(" ").append(accessor).append(";").append(NEW_LINE);
                        sb.append("    static {").append(NEW_LINE);
                        sb.append("        try {").append(NEW_LINE);
                        sb.append("            Method m = ").append(this.parent.implementationImportType(this.modelType)).append(".class.getDeclaredMethod(\"").append(entityIdAttribute.getName()).append("\");").append(NEW_LINE);
                        sb.append("            m.setAccessible(true);").append(NEW_LINE);
                        sb.append("            ").append(accessor).append(" = m;").append(NEW_LINE);
                        sb.append("        } catch (Exception ex) {").append(NEW_LINE);
                        sb.append("            throw new RuntimeException(\"Could not initialize accessor!\", ex);").append(NEW_LINE);
                        sb.append("        }").append(NEW_LINE);
                        sb.append("    }").append(NEW_LINE);
                    } else {
                        sb.append("    private static final ").append(this.parent.implementationImportType(Field.class.getName())).append(" ").append(accessor).append(";").append(NEW_LINE);
                        sb.append("    static {").append(NEW_LINE);
                        sb.append("        try {").append(NEW_LINE);
                        sb.append("            Field f = ").append(this.parent.implementationImportType(this.modelType)).append(".class.getDeclaredField(\"").append(entityIdAttribute.getName()).append("\");").append(NEW_LINE);
                        sb.append("            f.setAccessible(true);").append(NEW_LINE);
                        sb.append("            ").append(accessor).append(" = f;").append(NEW_LINE);
                        sb.append("        } catch (Exception ex) {").append(NEW_LINE);
                        sb.append("            throw new RuntimeException(\"Could not initialize accessor!\", ex);").append(NEW_LINE);
                        sb.append("        }").append(NEW_LINE);
                        sb.append("    }").append(NEW_LINE);
                    }
                    sb.append("    private Object ").append(entityIdAttribute.getIdAttributeName()).append("(Object o) {").append(NEW_LINE);
                    if (entityIdAttribute.getKind() == ElementKind.METHOD) {
                        sb.append("        try {").append(NEW_LINE);
                        sb.append("            return ").append(entityIdAttribute.getIdAttributeName()).append(".invoke(o);").append(";").append(NEW_LINE);
                        sb.append("        } catch (Exception ex) {").append(NEW_LINE);
                        sb.append("            throw new RuntimeException(\"Could not access id!\", ex);").append(NEW_LINE);
                        sb.append("        }");
                    } else {
                        sb.append("        try {").append(NEW_LINE);
                        sb.append("            return ").append(entityIdAttribute.getIdAttributeName()).append(".get(o);").append(";").append(NEW_LINE);
                        sb.append("        } catch (Exception ex) {").append(NEW_LINE);
                        sb.append("            throw new RuntimeException(\"Could not access id!\", ex);").append(NEW_LINE);
                        sb.append("        }");
                    }
                    sb.append("    }");
                }
            }
        }
    }

    @Override
    public void appendBuilderAttributeDeclarationString(StringBuilder sb) {
        if (this.elementKind == ElementKind.PARAMETER) {
            sb.append("    ");
        }
        sb.append("    protected ");
        sb.append(this.getBuilderImplementationTypeString());
        sb.append(' ').append(this.getPropertyName()).append(";");
    }

    @Override
    public void appendBuilderAttributeGetterAndSetterString(StringBuilder sb) {
        sb.append("    public ").append(this.getBuilderImplementationTypeString()).append(' ');
        sb.append(this.getterName);
        sb.append("() {").append(NEW_LINE).append("        return ").append(this.getPropertyName()).append(";").append(NEW_LINE).append("    }");
        sb.append(NEW_LINE);
        sb.append("    public void set");
        if (this.elementKind == ElementKind.PARAMETER) {
            sb.append("Param");
        }
        sb.append(Character.toUpperCase(this.getPropertyName().charAt(0)));
        sb.append(this.getPropertyName(), 1, this.getPropertyName().length());
        sb.append('(');
        sb.append(this.getBuilderImplementationTypeString());
        sb.append(' ').append(this.getPropertyName()).append(") {").append(NEW_LINE).append("        this.").append(this.getPropertyName()).append(" = ").append(this.getPropertyName()).append(";").append(NEW_LINE).append("    }");
    }

    @Override
    public String getImplementationTypeString() {
        return this.implementationTypeString;
    }

    @Override
    public String getBuilderImplementationTypeString() {
        if (this.convertedModelType == null) {
            return this.getImplementationTypeString();
        }
        return this.parent.builderImportType(this.modelType);
    }

    @Override
    public Collection<AttributeFilter> getFilters() {
        return this.filters.values();
    }

    @Override
    public boolean isParameter() {
        return this.elementKind == ElementKind.PARAMETER;
    }

    @Override
    public Set<Modifier> getGetterModifiers() {
        return this.modifiers;
    }

    @Override
    public String getGetterPackageName() {
        return this.getterPackageName;
    }

    @Override
    public MappingKind getKind() {
        return this.kind;
    }

    @Override
    public String getMapping() {
        return this.mapping;
    }

    @Override
    public int getAttributeIndex() {
        return this.attributeIndex;
    }

    @Override
    public void setAttributeIndex(int attributeIndex) {
        this.attributeIndex = attributeIndex;
    }

    @Override
    public int getDirtyStateIndex() {
        return this.dirtyStateIndex;
    }

    @Override
    public void setDirtyStateIndex(int dirtyStateIndex) {
        this.dirtyStateIndex = dirtyStateIndex;
    }

    @Override
    public String getSetterName() {
        return this.setterName;
    }

    @Override
    public boolean supportsDirtyTracking() {
        return this.supportsDirtyTracking;
    }

    @Override
    public String getPropertyName() {
        return this.attributeName;
    }

    @Override
    public String getGetterName() {
        return this.getterName;
    }

    @Override
    public MetaEntityView getHostingEntity() {
        return this.parent;
    }

    @Override
    public boolean isSubview() {
        return this.subviewElement != null;
    }

    @Override
    public boolean isMultiCollection() {
        return false;
    }

    @Override
    public MetaEntityView getSubviewElement() {
        return this.subviewElement;
    }

    @Override
    public boolean isSynthetic() {
        return false;
    }

    @Override
    public boolean isMutable() {
        return this.mutable;
    }

    @Override
    public boolean isSelf() {
        return this.self;
    }

    @Override
    public boolean isPrimitive() {
        return this.typeMirror.getKind().isPrimitive();
    }

    @Override
    public abstract String getMetaType();

    @Override
    public String getModelType() {
        return this.modelType;
    }

    @Override
    public String getGeneratedTypePrefix() {
        return this.generatedTypePrefix;
    }

    @Override
    public String getDeclaredJavaType() {
        return this.declaredJavaType;
    }

    @Override
    public String getConvertedModelType() {
        return this.convertedModelType;
    }

    @Override
    public TypeKind getTypeKind() {
        return this.typeKind;
    }

    @Override
    public MetaSerializationField getSerializationField() {
        return this.serializationField;
    }
}

