/*
 * Decompiled with CFR 0.152.
 */
package com.blazebit.persistence.view.impl.update.flush;

import com.blazebit.persistence.parser.EntityMetamodel;
import com.blazebit.persistence.parser.util.JpaMetamodelUtils;
import com.blazebit.persistence.spi.ExtendedAttribute;
import com.blazebit.persistence.spi.ExtendedManagedType;
import com.blazebit.persistence.view.impl.EntityViewManagerImpl;
import com.blazebit.persistence.view.impl.update.flush.UnmappedAttributeCascadeDeleter;
import com.blazebit.persistence.view.impl.update.flush.UnmappedBasicAttributeCascadeDeleter;
import com.blazebit.persistence.view.impl.update.flush.UnmappedCollectionAttributeCascadeDeleter;
import com.blazebit.persistence.view.impl.update.flush.UnmappedMapAttributeCascadeDeleter;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.persistence.metamodel.Attribute;
import javax.persistence.metamodel.PluralAttribute;

public class UnmappedAttributeCascadeDeleterUtil {
    private UnmappedAttributeCascadeDeleterUtil() {
    }

    public static List<UnmappedAttributeCascadeDeleter> createUnmappedCascadeDeleters(EntityViewManagerImpl evm, Class<?> entityClass, String ownerIdAttributeName) {
        EntityMetamodel entityMetamodel = evm.getMetamodel().getEntityMetamodel();
        ExtendedManagedType extendedManagedType = (ExtendedManagedType)entityMetamodel.getManagedType(ExtendedManagedType.class, entityClass);
        Map attributes = extendedManagedType.getOwnedAttributes();
        ArrayList<UnmappedAttributeCascadeDeleter> deleters = new ArrayList<UnmappedAttributeCascadeDeleter>(attributes.size());
        for (Map.Entry entry : attributes.entrySet()) {
            ExtendedAttribute extendedAttribute = (ExtendedAttribute)entry.getValue();
            if (extendedAttribute.getAttribute().isCollection()) {
                if (((PluralAttribute)extendedAttribute.getAttribute()).getCollectionType() == PluralAttribute.CollectionType.MAP) {
                    deleters.add(new UnmappedMapAttributeCascadeDeleter(evm, (String)entry.getKey(), extendedAttribute, entityClass, ownerIdAttributeName, true));
                    continue;
                }
                deleters.add(new UnmappedCollectionAttributeCascadeDeleter(evm, (String)entry.getKey(), extendedAttribute, entityClass, ownerIdAttributeName, true));
                continue;
            }
            if (!JpaMetamodelUtils.isAssociation((Attribute)extendedAttribute.getAttribute()) || !extendedAttribute.isDeleteCascaded()) continue;
            deleters.add(new UnmappedBasicAttributeCascadeDeleter(evm, (String)entry.getKey(), extendedAttribute, ownerIdAttributeName, true));
        }
        return deleters;
    }
}

