/*
 * Decompiled with CFR 0.152.
 */
package com.blazebit.persistence.view.impl.update.flush;

import com.blazebit.persistence.view.impl.update.flush.FetchGraphNode;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class CompositeAttributeFetchGraphNode<X extends CompositeAttributeFetchGraphNode<X, T>, T extends FetchGraphNode<?>>
implements FetchGraphNode<X> {
    protected final Class<?> viewType;
    protected final Map<String, Integer> attributeIndexMapping;
    protected final T[] flushers;
    protected final Boolean persist;

    public CompositeAttributeFetchGraphNode(Class<?> viewType, T[] flushers, Boolean persist) {
        this.viewType = viewType;
        this.flushers = flushers;
        this.attributeIndexMapping = CompositeAttributeFetchGraphNode.createAttributeToIndexMapping(flushers);
        this.persist = persist;
    }

    public CompositeAttributeFetchGraphNode(Class<?> viewType, Map<String, Integer> attributeIndexMapping, T[] flushers, Boolean persist) {
        this.viewType = viewType;
        this.attributeIndexMapping = attributeIndexMapping;
        this.flushers = flushers;
        this.persist = persist;
    }

    private static Map<String, Integer> createAttributeToIndexMapping(FetchGraphNode[] flushers) {
        HashMap<String, Integer> map = new HashMap<String, Integer>(flushers.length);
        for (int i = 0; i < flushers.length; ++i) {
            map.put(flushers[i].getAttributeName(), i);
        }
        return map;
    }

    @Override
    public String getAttributeName() {
        return null;
    }

    @Override
    public String getMapping() {
        return null;
    }

    @Override
    public void appendFetchJoinQueryFragment(String base, StringBuilder sb) {
        for (int i = 0; i < this.flushers.length; ++i) {
            if (this.flushers[i] == null) continue;
            this.flushers[i].appendFetchJoinQueryFragment(base, sb);
        }
    }

    @Override
    public FetchGraphNode<?> mergeWith(List<X> fetchGraphNodes) {
        CompositeAttributeFetchGraphNode firstNode = (CompositeAttributeFetchGraphNode)fetchGraphNodes.get(0);
        T[] firstFlushers = firstNode.flushers;
        HashMap<String, Integer> newAttributeIndexMapping = null;
        List<List<T>> newFlushers = null;
        for (int i = 0; i < fetchGraphNodes.size(); ++i) {
            T nodeFlusher;
            int j;
            T[] nodeFlushers;
            CompositeAttributeFetchGraphNode node = (CompositeAttributeFetchGraphNode)fetchGraphNodes.get(i);
            if (node.persist == null || node.persist.booleanValue()) continue;
            if (firstNode.viewType != node.viewType) {
                if (newAttributeIndexMapping == null) {
                    newAttributeIndexMapping = new HashMap<String, Integer>(firstNode.attributeIndexMapping);
                    if (newFlushers == null) {
                        newFlushers = CompositeAttributeFetchGraphNode.newFlushersList(firstFlushers);
                    }
                }
                CompositeAttributeFetchGraphNode.addAttributeIndexMappings(newAttributeIndexMapping, node.attributeIndexMapping, newFlushers);
                nodeFlushers = node.flushers;
                for (j = 0; j < nodeFlushers.length; ++j) {
                    Integer newIndex;
                    List<T> flushers;
                    nodeFlusher = nodeFlushers[j];
                    if (nodeFlusher == null || (flushers = newFlushers.get(newIndex = (Integer)newAttributeIndexMapping.get(nodeFlusher.getAttributeName()))).contains(nodeFlusher)) continue;
                    flushers.add(nodeFlusher);
                }
                continue;
            }
            nodeFlushers = node.flushers;
            for (j = 0; j < firstFlushers.length; ++j) {
                if (firstFlushers[j] == nodeFlushers[j] || nodeFlushers[j] == null) continue;
                nodeFlusher = nodeFlushers[j];
                if (newFlushers == null) {
                    newFlushers = CompositeAttributeFetchGraphNode.newFlushersList(firstFlushers);
                    newFlushers.get(j).add(nodeFlusher);
                    continue;
                }
                List<T> flushers = newFlushers.get(j);
                if (flushers.contains(nodeFlusher)) continue;
                flushers.add(nodeFlusher);
            }
        }
        if (newFlushers == null) {
            return this;
        }
        FetchGraphNode[] newFlusherArray = new FetchGraphNode[newFlushers.size()];
        for (int i = 0; i < newFlushers.size(); ++i) {
            FetchGraphNode<?> newFlusher;
            List flushers = (List)newFlushers.get(i);
            if (flushers.isEmpty()) continue;
            FetchGraphNode firstFlusher = (FetchGraphNode)flushers.get(0);
            newFlusherArray[i] = newAttributeIndexMapping == null && flushers.size() == 1 ? firstFlusher : (newFlusher = firstFlusher.mergeWith(flushers));
        }
        if (newAttributeIndexMapping == null) {
            return new CompositeAttributeFetchGraphNode(this.viewType, this.attributeIndexMapping, newFlusherArray, null);
        }
        return new CompositeAttributeFetchGraphNode(null, newAttributeIndexMapping, newFlusherArray, null);
    }

    private static <T> void addAttributeIndexMappings(Map<String, Integer> newAttributeIndexMapping, Map<String, Integer> attributeIndexMapping, List<List<T>> newFlushers) {
        for (String newAttribute : attributeIndexMapping.keySet()) {
            if (newAttributeIndexMapping.containsKey(newAttribute)) continue;
            newAttributeIndexMapping.put(newAttribute, newAttributeIndexMapping.size());
            newFlushers.add(new ArrayList());
        }
    }

    private static <T> List<List<T>> newFlushersList(T[] firstFlushers) {
        ArrayList<List<T>> newFlushers = new ArrayList<List<T>>(firstFlushers.length);
        for (int i = 0; i < firstFlushers.length; ++i) {
            ArrayList<T> flushers = new ArrayList<T>();
            if (firstFlushers[i] != null) {
                flushers.add(firstFlushers[i]);
            }
            newFlushers.add(flushers);
        }
        return newFlushers;
    }
}

